/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.lhadecompressor;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sourceforge.lhadecompressor.LhaDecoderInputStream;
import net.sourceforge.lhadecompressor.LhaEntry;
import net.sourceforge.lhadecompressor.LhaEntryReader;
import net.sourceforge.lhadecompressor.LhaException;

public class LhaInputStream
extends FilterInputStream {
    private LhaDecoderInputStream dis;
    private String encoding;
    private LhaEntry entry;
    private boolean closed;

    public LhaInputStream(InputStream in) {
        this(in, "MS932");
    }

    public LhaInputStream(InputStream in, String encoding) {
        super(in);
        this.encoding = encoding;
        this.dis = null;
        this.entry = null;
        this.closed = true;
    }

    public LhaEntry getNextEntry() throws LhaException, IOException {
        if (this.entry != null) {
            this.dis.closeEntry();
        }
        LhaEntryReader hr = new LhaEntryReader(this.encoding){

            @Override
            protected int _read(byte[] b) throws IOException {
                return LhaInputStream.this.in.read(b);
            }
        };
        this.entry = hr.readHeader();
        if (this.entry != null) {
            this.dis = new LhaDecoderInputStream(this.in, this.entry);
            this.closed = false;
        } else {
            this.dis = null;
            this.closed = true;
        }
        return this.entry;
    }

    private final void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        return this.dis.available();
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        return this.dis.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        return this.dis.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureOpen();
        return this.dis.skip(n);
    }

    @Override
    public void close() throws IOException {
        if (this.dis != null) {
            this.closed = true;
            this.dis.close();
            this.dis = null;
        }
        super.close();
    }
}

