/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.text.BadLocationException;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.fife.ui.rsyntaxtextarea.RSTAView;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaDefaultInputMap;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaEditorKit;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextAreaHighlighter;
import org.fife.ui.rsyntaxtextarea.SyntaxView;
import org.fife.ui.rsyntaxtextarea.WrappedSyntaxView;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaUI;

public class RSyntaxTextAreaUI
extends RTextAreaUI {
    private static final String SHARED_ACTION_MAP_NAME = "RSyntaxTextAreaUI.actionMap";
    private static final String SHARED_INPUT_MAP_NAME = "RSyntaxTextAreaUI.inputMap";
    private static final EditorKit defaultKit = new RSyntaxTextAreaEditorKit();

    public static ComponentUI createUI(JComponent ta) {
        return new RSyntaxTextAreaUI(ta);
    }

    public RSyntaxTextAreaUI(JComponent rSyntaxTextArea) {
        super(rSyntaxTextArea);
    }

    @Override
    public View create(Element elem) {
        RTextArea c = this.getRTextArea();
        if (c instanceof RSyntaxTextArea) {
            RSyntaxTextArea area = (RSyntaxTextArea)c;
            View v = area.getLineWrap() ? new WrappedSyntaxView(elem) : new SyntaxView(elem);
            return v;
        }
        return null;
    }

    @Override
    protected Highlighter createHighlighter() {
        return new RSyntaxTextAreaHighlighter();
    }

    @Override
    protected String getActionMapName() {
        return SHARED_ACTION_MAP_NAME;
    }

    @Override
    public EditorKit getEditorKit(JTextComponent tc) {
        return defaultKit;
    }

    @Override
    protected InputMap getRTextAreaInputMap() {
        InputMapUIResource map = new InputMapUIResource();
        InputMap shared = (InputMap)UIManager.get(SHARED_INPUT_MAP_NAME);
        if (shared == null) {
            shared = new RSyntaxTextAreaDefaultInputMap();
            UIManager.put(SHARED_INPUT_MAP_NAME, shared);
        }
        map.setParent(shared);
        return map;
    }

    @Override
    protected void paintBackground(Graphics g) {
        super.paintBackground(g);
        this.paintMatchedBracket(g);
    }

    protected void paintMatchedBracket(Graphics g) {
        Rectangle match;
        RSyntaxTextArea rsta = (RSyntaxTextArea)this.textArea;
        if (rsta.isBracketMatchingEnabled() && (match = rsta.match) != null) {
            if (rsta.getAnimateBracketMatching()) {
                g.setColor(rsta.getMatchedBracketBGColor());
                g.fillRoundRect(match.x, match.y, match.width, match.height - 1, 5, 5);
                g.setColor(rsta.getMatchedBracketBorderColor());
                g.drawRoundRect(match.x, match.y, match.width, match.height - 1, 5, 5);
            } else {
                g.setColor(rsta.getMatchedBracketBGColor());
                g.fillRect(match.x, match.y, match.width, match.height - 1);
                g.setColor(rsta.getMatchedBracketBorderColor());
                g.drawRect(match.x, match.y, match.width, match.height - 1);
            }
        }
    }

    @Override
    protected void propertyChange(PropertyChangeEvent e) {
        String name = e.getPropertyName();
        if (name.equals("RSTA.syntaxScheme")) {
            this.modelChanged();
        } else {
            super.propertyChange(e);
        }
    }

    public void refreshSyntaxHighlighting() {
        this.modelChanged();
    }

    @Override
    public int yForLineContaining(int offs) throws BadLocationException {
        Rectangle alloc = this.getVisibleEditorRect();
        if (alloc != null) {
            RSTAView view = (RSTAView)((Object)this.getRootView(this.textArea).getView(0));
            return view.yForLineContaining(alloc, offs);
        }
        return -1;
    }
}

