/*
 * Decompiled with CFR 0.152.
 */
package org.monte.ilbmdemo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.monte.media.ilbm.ColorCyclingMemoryImageSource;
import org.monte.media.ilbm.ILBMDecoder;
import org.monte.media.pbm.PBMDecoder;

public class ILBMViewer
extends JPanel {
    protected String PBM_HEADER = "PBM BMHD";
    protected String ILBM_HEADER = "ILBMBMHD";

    public ILBMViewer() {
        this.initComponents();
    }

    protected BufferedImage getAmigaPicture(File f) throws IOException {
        return ImageIO.read(f);
    }

    protected BufferedImage getAmigaPictureViaByteArray(File f) throws IOException {
        return this.getAmigaPicture(this.getData(f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getData(File f) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (FileInputStream in = new FileInputStream(f);){
            byte[] buf = new byte[512];
            int len = in.read(buf);
            while (len != -1) {
                out.write(buf, 0, len);
                len = in.read(buf);
            }
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Image getAmigaPictureWithColorCycling(File f) throws IOException {
        byte[] data = this.getData(f);
        if (this.PBM_HEADER.equals(new String(data, 8, this.PBM_HEADER.length()))) {
            try {
                Image image = this.getAmigaPBMPictureWithColorCycling(f);
                return image;
            }
            finally {
                return null;
            }
        }
        if (!this.ILBM_HEADER.equals(new String(data, 8, this.ILBM_HEADER.length()))) {
            return null;
        }
        try (FileInputStream in = new FileInputStream(f);){
            ColorCyclingMemoryImageSource ccmis = new ILBMDecoder(in).produce().get(0);
            if (ccmis.isColorCyclingAvailable()) {
                ccmis.start();
            }
            Image image = Toolkit.getDefaultToolkit().createImage(ccmis);
            return image;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getAmigaPBMPictureWithColorCycling(File f) throws IOException {
        try (FileInputStream in = new FileInputStream(f);){
            ColorCyclingMemoryImageSource ccmis;
            ArrayList<ColorCyclingMemoryImageSource> imageList = new PBMDecoder(in).produce();
            if (imageList.isEmpty()) {
                in.close();
                in = new FileInputStream(f);
                imageList = new ILBMDecoder(in).produce();
            }
            if ((ccmis = imageList.get(0)).isColorCyclingAvailable()) {
                ccmis.start();
            }
            Image image = Toolkit.getDefaultToolkit().createImage(ccmis);
            return image;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getAmigaPicture(String f) throws IOException {
        try (FileInputStream in = new FileInputStream(f);){
            ColorCyclingMemoryImageSource ccmis;
            ArrayList<ColorCyclingMemoryImageSource> imageList = new PBMDecoder(in).produce();
            if (imageList.isEmpty()) {
                in.close();
                in = new FileInputStream(f);
                imageList = new ILBMDecoder(in).produce();
            }
            if ((ccmis = imageList.get(0)).isColorCyclingAvailable()) {
                ccmis.start();
            }
            Image g = Toolkit.getDefaultToolkit().createImage(ccmis);
            BufferedImage result = new BufferedImage(g.getWidth(null), g.getHeight(null), 1);
            result.createGraphics().drawImage(g, 0, 0, null);
            BufferedImage bufferedImage = result;
            return bufferedImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getAmigaPicture(byte[] f) throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(f);){
            ColorCyclingMemoryImageSource ccmis;
            ArrayList<ColorCyclingMemoryImageSource> imageList = new PBMDecoder(in).produce();
            if (imageList.isEmpty()) {
                in.close();
                in = new ByteArrayInputStream(f);
                imageList = new ILBMDecoder(in).produce();
            }
            if ((ccmis = imageList.get(0)).isColorCyclingAvailable()) {
                ccmis.start();
            }
            Image g = Toolkit.getDefaultToolkit().createImage(ccmis);
            BufferedImage result = new BufferedImage(g.getWidth(null), g.getHeight(null), 1);
            result.createGraphics().drawImage(g, 0, 0, null);
            BufferedImage bufferedImage = result;
            return bufferedImage;
        }
    }

    private void initComponents() {
        JLabel label = new JLabel();
        this.setLayout(new BorderLayout());
        label.setHorizontalAlignment(0);
        label.setText("Drop ILBM file here.");
        this.add((Component)label, "Center");
    }
}

