/*
 * Decompiled with CFR 0.152.
 */
package org.monte.pbmdemo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.monte.media.gui.Worker;
import org.monte.media.ilbm.ColorCyclingMemoryImageSource;
import org.monte.media.ilbm.ILBMDecoder;
import org.monte.media.io.ByteArrayImageInputStream;
import org.monte.media.pbm.PBMDecoder;

public class PBMViewer
extends JPanel {
    private Handler handler = new Handler();
    private JLabel label;

    public PBMViewer() {
        this.initComponents();
        new DropTarget(this, this.handler);
        new DropTarget(this.label, this.handler);
    }

    protected BufferedImage getAmigaPicture(File f) throws IOException {
        return ImageIO.read(f);
    }

    protected BufferedImage getAmigaPictureViaByteArray(File f) throws IOException {
        return this.getAmigaPicture(this.getData(f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getData(File f) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (FileInputStream in = new FileInputStream(f);){
            byte[] buf = new byte[512];
            int len = in.read(buf);
            while (len != -1) {
                out.write(buf, 0, len);
                len = in.read(buf);
            }
        }
        return out.toByteArray();
    }

    protected BufferedImage getAmigaPicture(byte[] data) throws IOException {
        return ImageIO.read(new ByteArrayImageInputStream(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Image getAmigaPictureWithColorCycling(File f) throws IOException {
        try (FileInputStream in = new FileInputStream(f);){
            ColorCyclingMemoryImageSource ccmis;
            ArrayList<ColorCyclingMemoryImageSource> imageList = new PBMDecoder(in).produce();
            if (imageList.isEmpty()) {
                in.close();
                in = new FileInputStream(f);
                imageList = new ILBMDecoder(in).produce();
            }
            if ((ccmis = imageList.get(0)).isColorCyclingAvailable()) {
                ccmis.start();
            }
            Image g = Toolkit.getDefaultToolkit().createImage(ccmis);
            BufferedImage c = new BufferedImage(g.getWidth(null), g.getHeight(null), 1);
            c.createGraphics().drawImage(g, 0, 0, null);
            String h = f.getCanonicalPath();
            while (h.contains(".")) {
                h = h.substring(0, h.length() - 1);
            }
            h = h + ".png";
            ImageIO.write((RenderedImage)c, "PNG", new File(h));
            Image image = g;
            return image;
        }
    }

    public void showAmigaImages(final List<File> files) {
        this.label.setEnabled(false);
        if (this.label.getIcon() instanceof ImageIcon) {
            ImageIcon icon = (ImageIcon)this.label.getIcon();
            this.label.setIcon(null);
            this.label.setDisabledIcon(null);
            icon.getImage().flush();
        }
        new Worker<Image>(){

            @Override
            protected Image construct() throws Exception {
                Iterator iterator = files.iterator();
                if (iterator.hasNext()) {
                    File f = (File)iterator.next();
                    return PBMViewer.this.getAmigaPictureWithColorCycling(f);
                }
                return null;
            }

            @Override
            protected void done(Image value) {
                if (value == null) {
                    this.failed(new IOException("Could not load image."));
                    return;
                }
                PBMViewer.this.label.setText(null);
                ImageIcon icon = new ImageIcon(value);
                PBMViewer.this.label.setIcon(icon);
                PBMViewer.this.label.setDisabledIcon(icon);
                SwingUtilities.getWindowAncestor(PBMViewer.this).pack();
            }

            @Override
            protected void failed(Throwable error) {
                error.printStackTrace();
                PBMViewer.this.label.setText("<html><b>Error</b><br>" + error.getMessage());
                SwingUtilities.getWindowAncestor(PBMViewer.this).pack();
            }

            @Override
            protected void finished() {
                PBMViewer.this.label.setEnabled(true);
            }
        }.start();
    }

    public void showAmigaImage(final File files) {
        this.label.setEnabled(false);
        if (this.label.getIcon() instanceof ImageIcon) {
            ImageIcon icon = (ImageIcon)this.label.getIcon();
            this.label.setIcon(null);
            this.label.setDisabledIcon(null);
            icon.getImage().flush();
        }
        new Worker<Image>(){

            @Override
            protected Image construct() throws Exception {
                return PBMViewer.this.getAmigaPictureWithColorCycling(files);
            }

            @Override
            protected void done(Image value) {
                if (value == null) {
                    this.failed(new IOException("Could not load image."));
                    return;
                }
                PBMViewer.this.label.setText(null);
                ImageIcon icon = new ImageIcon(value);
                PBMViewer.this.label.setIcon(icon);
                PBMViewer.this.label.setDisabledIcon(icon);
                SwingUtilities.getWindowAncestor(PBMViewer.this).pack();
            }

            @Override
            protected void failed(Throwable error) {
                error.printStackTrace();
                PBMViewer.this.label.setText("<html><b>Error</b><br>" + error.getMessage());
                SwingUtilities.getWindowAncestor(PBMViewer.this).pack();
            }

            @Override
            protected void finished() {
                PBMViewer.this.label.setEnabled(true);
            }
        }.start();
    }

    private void initComponents() {
        this.label = new JLabel();
        this.setLayout(new BorderLayout());
        this.label.setHorizontalAlignment(0);
        this.label.setText("Drop PBM or ILBM file here.");
        this.add((Component)this.label, "Center");
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame f = new JFrame("PBM Image Viewer");
                f.setDefaultCloseOperation(3);
                f.add(new PBMViewer());
                f.setSize(200, 200);
                f.setVisible(true);
            }
        });
    }

    private class Handler
    implements DropTargetListener {
        private Handler() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent event) {
            if (event.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                event.acceptDrag(1);
            } else {
                event.rejectDrag();
            }
        }

        @Override
        public void dragExit(DropTargetEvent event) {
        }

        @Override
        public void dragOver(DropTargetDragEvent event) {
            if (event.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                event.acceptDrag(1);
            } else {
                event.rejectDrag();
            }
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            if (event.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                event.acceptDrop(1);
                try {
                    List files = (List)event.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    PBMViewer.this.showAmigaImages(files);
                }
                catch (IOException e) {
                    JOptionPane.showConfirmDialog(PBMViewer.this, "Could not access the dropped data.", "PBMViewer: Drop Failed", -1, 1);
                }
                catch (UnsupportedFlavorException e) {
                    JOptionPane.showConfirmDialog(PBMViewer.this, "Unsupported data flavor.", "PBMViewer: Drop Failed", -1, 1);
                }
            } else {
                event.rejectDrop();
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
        }
    }
}

