/*
 * Decompiled with CFR 0.152.
 */
package org.monte.screenrecorder;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.monte.media.AudioFormatKeys;
import org.monte.media.Format;
import org.monte.media.FormatKeys;
import org.monte.media.VideoFormatKeys;
import org.monte.media.gui.Worker;
import org.monte.media.math.Rational;
import org.monte.screenrecorder.ScreenRecorder;

public class ScreenRecorderMain
extends JFrame {
    private Handler handler = new Handler();
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd 'at' HH.mm.ss");
    private volatile Worker recorder;
    private ScreenRecorder screenRecorder;
    private int depth;
    private int format;
    private int encoding;
    private int cursor;
    private int audio;
    private int area;
    private double screenRate;
    private double mouseRate;
    private JComboBox areaChoice;
    private JLabel areaLabel;
    private JComboBox audioChoice;
    private JLabel audioLabel;
    private JComboBox colorsChoice;
    private JLabel colorsLabel;
    private JComboBox cursorChoice;
    private JLabel demoLabel;
    private JComboBox encodingChoice;
    private JLabel encodingLabel;
    private JComboBox formatChoice;
    private JLabel formatLabel;
    private JLabel infoLabel;
    private JLabel mouseLabel;
    private JSpinner mouseRateField;
    private JLabel mouseRateLabel;
    private JSpinner screenRateField;
    private JLabel screenRateLabel;
    private JButton startStopButton;

    public ScreenRecorderMain() {
        this.initComponents();
        String version = ScreenRecorderMain.class.getPackage().getImplementationVersion();
        if (version != null) {
            this.setTitle(this.getTitle() + " " + version);
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            this.infoLabel.setText(this.infoLabel.getText().replaceAll("\"Movies\"", "\"Videos\""));
        }
        ((JPanel)this.getContentPane()).setBorder(new EmptyBorder(12, 20, 20, 20));
        this.pack();
        Preferences prefs = Preferences.userNodeForPackage(ScreenRecorderMain.class);
        this.depth = Math.min(Math.max(0, prefs.getInt("ScreenRecording.colorDepth", 3)), this.colorsChoice.getItemCount() - 1);
        this.colorsChoice.setSelectedIndex(this.depth);
        this.format = Math.min(Math.max(0, prefs.getInt("ScreenRecording.format", 0)), this.formatChoice.getItemCount() - 1);
        this.formatChoice.setSelectedIndex(this.format);
        this.encoding = Math.min(Math.max(0, prefs.getInt("ScreenRecording.encoding", 0)), this.encodingChoice.getItemCount() - 1);
        this.encodingChoice.setSelectedIndex(this.encoding);
        this.cursor = Math.min(Math.max(0, prefs.getInt("ScreenRecording.cursor", 1)), this.cursorChoice.getItemCount() - 1);
        this.cursorChoice.setSelectedIndex(this.cursor);
        this.screenRate = prefs.getDouble("ScreenRecording.screenRate", 15.0);
        SpinnerNumberModel screenRateModel = new SpinnerNumberModel(this.screenRate, 1.0, 30.0, 1.0);
        this.screenRateField.setModel(screenRateModel);
        this.mouseRate = prefs.getDouble("ScreenRecording.mouseRate", 30.0);
        SpinnerNumberModel mouseRateModel = new SpinnerNumberModel(this.mouseRate, 1.0, 30.0, 1.0);
        this.mouseRateField.setModel(mouseRateModel);
        this.audioChoice.setModel(new DefaultComboBoxModel<Object>(new Object[]{new AudioItem("No Audio", 0, 0), new AudioItem("8.000 Hz", 8000, 16), new AudioItem("11.025 Hz", 11025, 16), new AudioItem("22.050 Hz", 22050, 16), new AudioItem("44.100 Hz", 44100, 16)}));
        this.audio = prefs.getInt("ScreenRecording.audio", 0);
        this.audioChoice.setSelectedIndex(this.audio);
        this.areaChoice.setModel(new DefaultComboBoxModel<Object>(new Object[]{new AreaItem("Entire Screen", null, 8), new AreaItem("Entire Screen @ 1280 x 800", null, new Dimension(1280, 800), 8), new AreaItem("Entire Screen @ 1280 x 720", null, new Dimension(1280, 720), 8), new AreaItem("Entire Screen @ 1024 x 768", null, new Dimension(1024, 768), 8), new AreaItem("Entire Screen @   800 x 600", null, new Dimension(800, 600), 8), new AreaItem("Entire Screen @   640 x 480", null, new Dimension(640, 480), 8), new AreaItem("1280 x 720 Center", new Dimension(1280, 720), 0), new AreaItem("1280 x 720 Top Left", new Dimension(1280, 720), 8), new AreaItem("1280 x 720 Bottom Left", new Dimension(1280, 720), 6), new AreaItem("1024 x 768 Center", new Dimension(1024, 768), 0), new AreaItem("1024 x 768 Top Left", new Dimension(1024, 768), 8), new AreaItem("1024 x 768 Bottom Left", new Dimension(1024, 768), 6), new AreaItem("  800 x 600 Center", new Dimension(1024, 768), 0), new AreaItem("  800 x 600 Top Left", new Dimension(1024, 768), 8), new AreaItem("  800 x 600 Bottom Left", new Dimension(1024, 768), 6), new AreaItem("  640 x 480 Center", new Dimension(1024, 768), 0), new AreaItem("  640 x 480 Top Left", new Dimension(1024, 768), 8), new AreaItem("  640 x 480 Bottom Left", new Dimension(1024, 768), 6)}));
        this.area = prefs.getInt("ScreenRecording.area", 0);
        this.areaChoice.setSelectedIndex(this.area);
        this.getRootPane().setDefaultButton(this.startStopButton);
        this.updateEncodingChoice();
    }

    private void initComponents() {
        this.demoLabel = new JLabel();
        this.formatLabel = new JLabel();
        this.formatChoice = new JComboBox();
        this.colorsLabel = new JLabel();
        this.colorsChoice = new JComboBox();
        this.infoLabel = new JLabel();
        this.startStopButton = new JButton();
        this.mouseLabel = new JLabel();
        this.cursorChoice = new JComboBox();
        this.audioLabel = new JLabel();
        this.audioChoice = new JComboBox();
        this.screenRateLabel = new JLabel();
        this.screenRateField = new JSpinner();
        this.mouseRateLabel = new JLabel();
        this.mouseRateField = new JSpinner();
        this.encodingLabel = new JLabel();
        this.encodingChoice = new JComboBox();
        this.areaLabel = new JLabel();
        this.areaChoice = new JComboBox();
        FormListener formListener = new FormListener();
        this.setDefaultCloseOperation(0);
        this.setTitle("Screen Recorder");
        this.addWindowListener(formListener);
        this.demoLabel.setText("<html><b>This is a demo of the Monte Media Library.</b><br>Copyright \u00a9 2012 Werner Randelshofer. All rights reserved.<br> This software can be licensed under Creative Commons Attribution 3.0.");
        this.formatLabel.setText("Format:");
        this.formatChoice.setModel(new DefaultComboBoxModel<String>(new String[]{"AVI", "QuickTime"}));
        this.formatChoice.addActionListener(formListener);
        this.colorsLabel.setText("Colors:");
        this.colorsChoice.setModel(new DefaultComboBoxModel<String>(new String[]{"Hundreds", "Thousands", "Millions"}));
        this.infoLabel.setFont(new Font("Lucida Grande", 0, 11));
        this.infoLabel.setText("<html>When you press the Start button, this window will be minized before the recording starts.<br> \nTo stop the recording restore this window.<br>  The recording will be stored in the folder \"Movies\" inside your home folder.<br> A new file will be created every hour or when the file size limit is reached.");
        this.startStopButton.setText("Start");
        this.startStopButton.addActionListener(formListener);
        this.mouseLabel.setText("Mouse:");
        this.cursorChoice.setModel(new DefaultComboBoxModel<String>(new String[]{"No Cursor", "Black Cursor", "White Cursor"}));
        this.audioLabel.setText("Audio:");
        this.audioChoice.setModel(new DefaultComboBoxModel<String>(new String[]{"No Audio", "44.100 kHz"}));
        this.screenRateLabel.setText("Screen Rate:");
        this.mouseRateLabel.setText("Mouse Rate:");
        this.encodingLabel.setText("Encoding:");
        this.encodingChoice.setModel(new DefaultComboBoxModel<String>(new String[]{"Screen Capture", "Run Length", "None", "PNG", "JPEG 100 %", "JPEG   50 %"}));
        this.areaLabel.setText("Area:");
        this.areaChoice.setModel(new DefaultComboBoxModel<String>(new String[]{"Entire Screen", "1024 x 768 Top Left Corner", "1024 x 768 Bottom Left Corner", "  800 x 600 Top Left Corner", "  800 x 600 Bottom Left Corner", " "}));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.demoLabel, -2, 490, -2).addComponent(this.startStopButton, GroupLayout.Alignment.TRAILING).addComponent(this.infoLabel, -2, 490, -2)).addContainerGap(46, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.colorsLabel).addComponent(this.mouseLabel).addComponent(this.formatLabel).addComponent(this.audioLabel).addComponent(this.areaLabel)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.formatChoice, -2, -1, -2).addComponent(this.colorsChoice, -2, -1, -2).addComponent(this.cursorChoice, -2, -1, -2).addComponent(this.audioChoice, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 35, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.screenRateLabel, GroupLayout.Alignment.TRAILING).addComponent(this.mouseRateLabel, GroupLayout.Alignment.TRAILING)).addComponent(this.encodingLabel)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.encodingChoice, -2, -1, -2).addComponent(this.screenRateField, -2, 77, -2).addComponent(this.mouseRateField, -2, 77, -2)).addGap(34, 34, 34)).addGroup(layout.createSequentialGroup().addComponent(this.areaChoice, -2, -1, -2).addContainerGap()))));
        layout.linkSize(0, this.audioChoice, this.colorsChoice, this.cursorChoice, this.formatChoice);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.demoLabel, -2, -1, -2).addGap(30, 30, 30).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.formatChoice, -2, -1, -2).addComponent(this.formatLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.encodingChoice, -2, -1, -2).addComponent(this.encodingLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.colorsChoice, -2, -1, -2).addComponent(this.colorsLabel)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.screenRateField, -2, -1, -2).addComponent(this.screenRateLabel)).addGap(1, 1, 1))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cursorChoice, -2, -1, -2).addComponent(this.mouseLabel)).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.mouseRateField, -2, -1, -2).addComponent(this.mouseRateLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.audioChoice, -2, -1, -2).addComponent(this.audioLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.areaChoice, -2, -1, -2).addComponent(this.areaLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 16, Short.MAX_VALUE).addComponent(this.infoLabel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.startStopButton).addContainerGap()));
        this.pack();
    }

    private void updateValues() {
        Preferences prefs = Preferences.userNodeForPackage(ScreenRecorderMain.class);
        this.format = this.formatChoice.getSelectedIndex();
        prefs.putInt("ScreenRecording.format", this.format);
        this.encoding = this.encodingChoice.getSelectedIndex();
        prefs.putInt("ScreenRecording.encoding", this.encoding);
        this.depth = this.colorsChoice.getSelectedIndex();
        prefs.putInt("ScreenRecording.colorDepth", this.depth);
        this.cursor = this.cursorChoice.getSelectedIndex();
        prefs.putInt("ScreenRecording.cursor", this.cursor);
        this.audio = this.audioChoice.getSelectedIndex();
        prefs.putInt("ScreenRecording.audio", this.audio);
        this.area = this.areaChoice.getSelectedIndex();
        prefs.putInt("ScreenRecording.area", this.area);
        if (this.screenRateField.getValue() instanceof Double) {
            this.screenRate = (Double)this.screenRateField.getValue();
            prefs.putDouble("ScreenRecording.screenRate", this.screenRate);
        }
        if (this.mouseRateField.getValue() instanceof Double) {
            this.mouseRate = (Double)this.mouseRateField.getValue();
            prefs.putDouble("ScreenRecording.mouseRate", this.mouseRate);
        }
    }

    private void start() throws IOException, AWTException {
        this.updateValues();
        if (this.screenRecorder == null) {
            String crsr;
            String videoFormatName;
            String compressorName;
            String mimeType;
            int bitDepth;
            float quality = 1.0f;
            switch (this.depth) {
                default: {
                    bitDepth = 8;
                    break;
                }
                case 1: {
                    bitDepth = 16;
                    break;
                }
                case 2: {
                    bitDepth = 24;
                }
            }
            block4 : switch (this.format) {
                default: {
                    mimeType = "video/avi";
                    switch (this.encoding) {
                        default: {
                            compressorName = "tscc";
                            videoFormatName = "tscc";
                            break;
                        }
                        case 1: {
                            compressorName = "RLE ";
                            videoFormatName = "RLE ";
                            bitDepth = 8;
                            break;
                        }
                        case 2: {
                            compressorName = "DIB ";
                            videoFormatName = "DIB ";
                            if (bitDepth != 16) break block4;
                            bitDepth = 24;
                            break;
                        }
                        case 3: {
                            compressorName = "png ";
                            videoFormatName = "png ";
                            bitDepth = 24;
                            break;
                        }
                        case 4: {
                            compressorName = "MJPG";
                            videoFormatName = "MJPG";
                            bitDepth = 24;
                            break;
                        }
                        case 5: {
                            compressorName = "MJPG";
                            videoFormatName = "MJPG";
                            bitDepth = 24;
                            quality = 0.5f;
                            break;
                        }
                    }
                    break;
                }
                case 1: {
                    mimeType = "video/quicktime";
                    switch (this.encoding) {
                        default: {
                            if (bitDepth == 8) {
                                videoFormatName = "rle ";
                                compressorName = "Animation";
                                break block4;
                            }
                            compressorName = "tscc";
                            videoFormatName = "tscc";
                            compressorName = "tscc";
                            break block4;
                        }
                        case 1: {
                            videoFormatName = "rle ";
                            compressorName = "Animation";
                            break block4;
                        }
                        case 2: {
                            videoFormatName = "raw ";
                            compressorName = "NONE";
                            break block4;
                        }
                        case 3: {
                            videoFormatName = "png ";
                            compressorName = "PNG";
                            bitDepth = 24;
                            break block4;
                        }
                        case 4: {
                            videoFormatName = "jpeg";
                            compressorName = "Photo - JPEG";
                            bitDepth = 24;
                            break block4;
                        }
                        case 5: 
                    }
                    videoFormatName = "jpeg";
                    compressorName = "Photo - JPEG";
                    bitDepth = 24;
                    quality = 0.5f;
                }
            }
            AudioItem item = (AudioItem)this.audioChoice.getItemAt(this.audio);
            int audioRate = item.sampleRate;
            int audioBitsPerSample = item.bitsPerSample;
            switch (this.cursor) {
                default: {
                    crsr = null;
                    break;
                }
                case 1: {
                    crsr = "black";
                    break;
                }
                case 2: {
                    crsr = "white";
                }
            }
            GraphicsConfiguration cfg = this.getGraphicsConfiguration();
            Rectangle areaRect = null;
            Dimension outputDimension = null;
            AreaItem item2 = (AreaItem)this.areaChoice.getItemAt(this.area);
            if (item2.inputDimension != null) {
                areaRect = new Rectangle(0, 0, ((AreaItem)item2).inputDimension.width, ((AreaItem)item2).inputDimension.height);
            }
            outputDimension = item2.outputDimension;
            Rectangle screenBounds = cfg.getBounds();
            if (areaRect == null) {
                areaRect = (Rectangle)screenBounds.clone();
            }
            switch (item2.alignment) {
                case 0: {
                    areaRect.x = screenBounds.x + (screenBounds.width - areaRect.width) / 2;
                    areaRect.y = screenBounds.y + (screenBounds.height - areaRect.height) / 2;
                    break;
                }
                case 8: {
                    areaRect.x = screenBounds.x;
                    areaRect.y = screenBounds.y;
                    break;
                }
                case 6: {
                    areaRect.x = screenBounds.x;
                    areaRect.y = screenBounds.y + screenBounds.height - areaRect.height;
                    break;
                }
            }
            areaRect = areaRect.intersection(screenBounds);
            if (outputDimension == null) {
                outputDimension = areaRect.getSize();
            }
            this.screenRecorder = new ScreenRecorder(cfg, areaRect, new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, VideoFormatKeys.MimeTypeKey, mimeType}), new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.EncodingKey, videoFormatName, VideoFormatKeys.CompressorNameKey, compressorName, VideoFormatKeys.WidthKey, outputDimension.width, VideoFormatKeys.HeightKey, outputDimension.height, VideoFormatKeys.DepthKey, bitDepth, VideoFormatKeys.FrameRateKey, Rational.valueOf(this.screenRate), VideoFormatKeys.QualityKey, Float.valueOf(quality), VideoFormatKeys.KeyFrameIntervalKey, (int)(this.screenRate * 60.0)}), crsr == null ? null : new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, VideoFormatKeys.EncodingKey, crsr, VideoFormatKeys.FrameRateKey, Rational.valueOf(this.mouseRate)}), audioRate == 0 ? null : new Format(new Object[]{VideoFormatKeys.MediaTypeKey, FormatKeys.MediaType.AUDIO, AudioFormatKeys.SampleRateKey, Rational.valueOf(audioRate), AudioFormatKeys.SampleSizeInBitsKey, audioBitsPerSample}));
            this.startStopButton.setText("Stop");
            this.screenRecorder.addChangeListener(this.handler);
            this.screenRecorder.start();
        }
    }

    private void stop() {
        if (this.screenRecorder != null) {
            final ScreenRecorder r = this.screenRecorder;
            this.startStopButton.setEnabled(false);
            this.screenRecorder = null;
            new Worker(){

                protected Object construct() throws Exception {
                    r.stop();
                    return null;
                }

                @Override
                protected void finished() {
                    ScreenRecorder.State state = r.getState();
                    ScreenRecorderMain.this.startStopButton.setEnabled(true);
                    ScreenRecorderMain.this.startStopButton.setText("Start");
                }
            }.start();
        }
    }

    private void recordingFailed() {
        if (this.screenRecorder != null) {
            this.screenRecorder = null;
            this.startStopButton.setEnabled(true);
            this.startStopButton.setText("Start");
            this.setExtendedState(0);
            JOptionPane.showMessageDialog(this, "<html><b>Sorry. Screen Recording failed.</b>", "Screen Recorder", 0);
        }
    }

    private void updateEncodingChoice() {
        int index = this.encodingChoice.getSelectedIndex();
        switch (this.formatChoice.getSelectedIndex()) {
            case 0: {
                this.encodingChoice.setModel(new DefaultComboBoxModel<String>(new String[]{"Screen Capture", "Run Length", "None", "PNG", "JPEG 100 %", "JPEG  50 %"}));
                break;
            }
            case 1: {
                this.encodingChoice.setModel(new DefaultComboBoxModel<String>(new String[]{"Screen Capture", "Animation", "None", "PNG", "JPEG 100 %", "JPEG  50 %"}));
            }
        }
        this.encodingChoice.setSelectedIndex(index);
    }

    private void startStopPerformed(ActionEvent evt) {
        if (this.screenRecorder == null) {
            this.setExtendedState(1);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        ScreenRecorderMain.this.start();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        ScreenRecorderMain.this.setExtendedState(0);
                        JOptionPane.showMessageDialog(ScreenRecorderMain.this, "<html><b>Sorry. Screen Recording failed.</b><br>" + t.getMessage(), "Screen Recorder", 0);
                        ScreenRecorderMain.this.stop();
                    }
                }
            });
        } else {
            this.stop();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.stop();
        this.dispose();
    }

    private void formWindowDeiconified(WindowEvent evt) {
        this.stop();
    }

    private void formatChoicePerformed(ActionEvent evt) {
        this.updateEncodingChoice();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new ScreenRecorderMain().setVisible(true);
            }
        });
    }

    private class FormListener
    implements ActionListener,
    WindowListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == ScreenRecorderMain.this.formatChoice) {
                ScreenRecorderMain.this.formatChoicePerformed(evt);
            } else if (evt.getSource() == ScreenRecorderMain.this.startStopButton) {
                ScreenRecorderMain.this.startStopPerformed(evt);
            }
        }

        @Override
        public void windowActivated(WindowEvent evt) {
        }

        @Override
        public void windowClosed(WindowEvent evt) {
        }

        @Override
        public void windowClosing(WindowEvent evt) {
            if (evt.getSource() == ScreenRecorderMain.this) {
                ScreenRecorderMain.this.formWindowClosing(evt);
            }
        }

        @Override
        public void windowDeactivated(WindowEvent evt) {
        }

        @Override
        public void windowDeiconified(WindowEvent evt) {
            if (evt.getSource() == ScreenRecorderMain.this) {
                ScreenRecorderMain.this.formWindowDeiconified(evt);
            }
        }

        @Override
        public void windowIconified(WindowEvent evt) {
        }

        @Override
        public void windowOpened(WindowEvent evt) {
        }
    }

    private static class AreaItem {
        private String title;
        private Dimension inputDimension;
        private Dimension outputDimension;
        private int alignment;

        public AreaItem(String title, Dimension dim, int alignment) {
            this(title, dim, null, alignment);
        }

        public AreaItem(String title, Dimension inputDim, Dimension outputDim, int alignment) {
            this.title = title;
            this.inputDimension = inputDim;
            this.outputDimension = outputDim;
            this.alignment = alignment;
        }

        public String toString() {
            return this.title;
        }
    }

    private static class AudioItem {
        private String title;
        private int sampleRate;
        private int bitsPerSample;

        public AudioItem(String title, int sampleRate, int bitsPerSample) {
            this.title = title;
            this.sampleRate = sampleRate;
            this.bitsPerSample = bitsPerSample;
        }

        public String toString() {
            return this.title;
        }
    }

    private class Handler
    implements ChangeListener {
        private Handler() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ScreenRecorder r = ScreenRecorderMain.this.screenRecorder;
            if (r != null && r.getState() == ScreenRecorder.State.FAILED) {
                ScreenRecorderMain.this.recordingFailed();
            }
        }
    }
}

