/*
 * Decompiled with CFR 0.152.
 */
package pacman;

import java.awt.Graphics;
import java.awt.Image;
import jemu.core.samples.Samples;
import pacman.Main;
import pacman.Sprite;

public class Fruit {
    static final int NUM_FRUITS = 4;
    static final int FRUIT_X = 8;
    static final int FRUIT_Y = 13;
    static final int FRUIT_WAIT_TIMER = 1200;
    static final int FRUIT_ON_TIMER = 480;
    protected Main parent;
    protected Image FruitImage;
    protected Sprite FruitSprite;
    protected int FruitTimer;
    protected boolean bFruit;
    protected boolean bWait;

    Fruit(Main main) {
        this.parent = main;
        this.FruitImage = main.LoadImage("images/fruit.gif", 16, 80);
        this.FruitSprite = new Sprite(main, this.FruitImage, 16, 16);
        this.FruitSprite.setHotspot(7, 12);
        this.FruitSprite.setRepair();
        this.reset();
    }

    public void reset() {
        this.FruitSprite.setFrame(0);
        this.FruitTimer = 1200;
        this.bWait = true;
        this.bFruit = false;
    }

    public void repair(Graphics graphics) {
        this.FruitSprite.drawRepair(graphics);
    }

    public void draw(Graphics graphics) {
        this.FruitSprite.grabRepair(369, 336);
        this.FruitSprite.draw(graphics, 369, 336);
        if (this.parent.game.state == 1) {
            --this.FruitTimer;
            if (this.FruitTimer <= 0) {
                if (this.bWait) {
                    this.FruitSprite.setFrame(1 + this.parent.random_range(4));
                    this.bWait = false;
                    this.bFruit = true;
                    this.FruitTimer = 480;
                } else {
                    this.FruitSprite.setFrame(0);
                    this.bWait = true;
                    this.bFruit = false;
                    this.FruitTimer = 1200;
                }
            }
        }
    }

    public void collide() {
        if (this.parent.game.pacman.PacManX % 32 == 0 && this.parent.game.pacman.PacManY % 24 == 0 && this.parent.game.pacman.PacManX / 32 == 8 && this.parent.game.pacman.PacManY / 24 == 13 && this.bFruit) {
            Samples.PAC_EATFRUIT.play();
            this.FruitSprite.setFrame(0);
            this.bFruit = false;
            this.parent.game.pacman.addScore(2000);
        }
    }
}

