/*
 * Decompiled with CFR 0.152.
 */
package tiled.core;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Vector;
import tiled.core.LayerLockedException;
import tiled.core.MapChangeListener;
import tiled.core.MapChangedEvent;
import tiled.core.MapLayer;
import tiled.core.MapObject;
import tiled.core.MultilayerPlane;
import tiled.core.ObjectGroup;
import tiled.core.Tile;
import tiled.core.TileLayer;
import tiled.core.TileSet;
import tiled.mapeditor.Resources;

public class Map
extends MultilayerPlane {
    public static final int MDO_ORTHO = 1;
    public static final int MDO_ISO = 2;
    public static final int MDO_HEX = 4;
    public static final int MDO_SHIFTED = 5;
    private Vector<MapLayer> specialLayers;
    private Vector<TileSet> tilesets;
    private LinkedList<MapObject> objects;
    private int tileWidth;
    private int tileHeight;
    private int orientation = 1;
    private final List mapChangeListeners = new LinkedList();
    private Properties properties = new Properties();
    private String filename;

    public Map(int width, int height) {
        super(width, height);
        this.tilesets = new Vector();
        this.specialLayers = new Vector();
        this.objects = new LinkedList();
    }

    public void addMapChangeListener(MapChangeListener listener) {
        this.mapChangeListeners.add(listener);
    }

    public void removeMapChangeListener(MapChangeListener listener) {
        this.mapChangeListeners.remove(listener);
    }

    protected void fireMapChanged() {
        Iterator iterator = this.mapChangeListeners.iterator();
        MapChangedEvent event = null;
        while (iterator.hasNext()) {
            if (event == null) {
                event = new MapChangedEvent(this);
            }
            ((MapChangeListener)iterator.next()).mapChanged(event);
        }
    }

    protected void fireTilesetRemoved(int index) {
        Iterator iterator = this.mapChangeListeners.iterator();
        MapChangedEvent event = null;
        while (iterator.hasNext()) {
            if (event == null) {
                event = new MapChangedEvent(this);
            }
            ((MapChangeListener)iterator.next()).tilesetRemoved(event, index);
        }
    }

    protected void fireTilesetAdded(TileSet tileset) {
        Iterator iterator = this.mapChangeListeners.iterator();
        MapChangedEvent event = null;
        while (iterator.hasNext()) {
            if (event == null) {
                event = new MapChangedEvent(this);
            }
            ((MapChangeListener)iterator.next()).tilesetAdded(event, tileset);
        }
    }

    protected void fireTilesetsSwapped(int index0, int index1) {
        Iterator iterator = this.mapChangeListeners.iterator();
        MapChangedEvent event = null;
        while (iterator.hasNext()) {
            if (event == null) {
                event = new MapChangedEvent(this);
            }
            ((MapChangeListener)iterator.next()).tilesetsSwapped(event, index0, index1);
        }
    }

    public void touch() {
        this.fireMapChanged();
    }

    public void addLayerSpecial(MapLayer layer) {
        layer.setMap(this);
        this.specialLayers.add(layer);
        this.fireMapChanged();
    }

    @Override
    public MapLayer addLayer(MapLayer layer) {
        layer.setMap(this);
        super.addLayer(layer);
        this.fireMapChanged();
        return layer;
    }

    public MapLayer addLayer() {
        TileLayer layer = new TileLayer(this, this.bounds.width, this.bounds.height);
        layer.setName(Resources.getString("general.layer.layer") + " " + super.getTotalLayers());
        super.addLayer(layer);
        this.fireMapChanged();
        return layer;
    }

    @Override
    public void setLayer(int index, MapLayer layer) {
        layer.setMap(this);
        super.setLayer(index, layer);
        this.fireMapChanged();
    }

    public MapLayer addObjectGroup() {
        ObjectGroup layer = new ObjectGroup(this);
        layer.setName(Resources.getString("general.objectgroup.objectgroup") + " " + super.getTotalLayers());
        super.addLayer(layer);
        this.fireMapChanged();
        return layer;
    }

    public void addTileset(TileSet tileset) {
        if (tileset == null || this.tilesets.indexOf(tileset) > -1) {
            return;
        }
        Tile t = tileset.getTile(0);
        if (t != null) {
            int tw = t.getWidth();
            int th = t.getHeight();
            if (tw != this.tileWidth && this.tileWidth == 0) {
                this.tileWidth = tw;
                this.tileHeight = th;
            }
        }
        this.tilesets.add(tileset);
        this.fireTilesetAdded(tileset);
    }

    public void removeTileset(TileSet tileset) throws LayerLockedException {
        int tilesetIndex = this.tilesets.indexOf(tileset);
        if (tilesetIndex == -1) {
            return;
        }
        Iterator tileIterator = tileset.iterator();
        while (tileIterator.hasNext()) {
            Tile tile = (Tile)tileIterator.next();
            ListIterator<MapLayer> layerIterator = this.getLayers();
            while (layerIterator.hasNext()) {
                MapLayer ml = (MapLayer)layerIterator.next();
                if (!(ml instanceof TileLayer)) continue;
                ((TileLayer)ml).removeTile(tile);
            }
        }
        this.tilesets.remove(tileset);
        this.fireTilesetRemoved(tilesetIndex);
    }

    public void addObject(MapObject o) {
        this.objects.add(o);
    }

    public Iterator<MapObject> getObjects() {
        return this.objects.iterator();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties prop) {
        this.properties = prop;
    }

    @Override
    public MapLayer removeLayer(int index) {
        MapLayer layer = super.removeLayer(index);
        this.fireMapChanged();
        return layer;
    }

    public void removeLayerSpecial(MapLayer layer) {
        if (this.specialLayers.remove(layer)) {
            this.fireMapChanged();
        }
    }

    public void removeAllSpecialLayers() {
        this.specialLayers.clear();
        this.fireMapChanged();
    }

    @Override
    public void removeAllLayers() {
        super.removeAllLayers();
        this.fireMapChanged();
    }

    @Override
    public void setLayerVector(Vector<MapLayer> layers) {
        super.setLayerVector(layers);
        this.fireMapChanged();
    }

    @Override
    public void swapLayerUp(int index) {
        super.swapLayerUp(index);
        this.fireMapChanged();
    }

    @Override
    public void swapLayerDown(int index) {
        super.swapLayerDown(index);
        this.fireMapChanged();
    }

    @Override
    public void mergeLayerDown(int index) {
        super.mergeLayerDown(index);
        this.fireMapChanged();
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setTileWidth(int width) {
        this.tileWidth = width;
        this.fireMapChanged();
    }

    public void setTileHeight(int height) {
        this.tileHeight = height;
        this.fireMapChanged();
    }

    @Override
    public void resize(int width, int height, int dx, int dy) {
        super.resize(width, height, dx, dy);
        this.fireMapChanged();
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public String getFilename() {
        return this.filename;
    }

    public Iterator getLayersSpecial() {
        return this.specialLayers.iterator();
    }

    public Vector<TileSet> getTilesets() {
        return this.tilesets;
    }

    public TileSet findTileSetForTileGID(int gid) {
        TileSet has = null;
        for (TileSet tileset : this.tilesets) {
            if (tileset.getFirstGid() > gid) continue;
            has = tileset;
        }
        return has;
    }

    public int getWidth() {
        return this.bounds.width;
    }

    public int getHeight() {
        return this.bounds.height;
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public boolean contains(int x, int y) {
        return x >= 0 && y >= 0 && x < this.bounds.width && y < this.bounds.height;
    }

    public int getTileHeightMax() {
        int maxHeight = this.tileHeight;
        for (TileSet tileset : this.tilesets) {
            int height = tileset.getTileHeight();
            if (height <= maxHeight) continue;
            maxHeight = height;
        }
        return maxHeight;
    }

    public void swapTileSets(int index0, int index1) {
        if (index0 == index1) {
            return;
        }
        TileSet set = this.tilesets.get(index0);
        this.tilesets.set(index0, this.tilesets.get(index1));
        this.tilesets.set(index1, set);
        if (index0 > index1) {
            int temp = index1;
            index1 = index0;
            index0 = temp;
        }
        this.fireTilesetsSwapped(index0, index1);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public String toString() {
        return "Map[" + this.bounds.width + "x" + this.bounds.height + "x" + this.getTotalLayers() + "][" + this.tileWidth + "x" + this.tileHeight + "]";
    }
}

