/*
 * Decompiled with CFR 0.152.
 */
package tiled.core;

import java.awt.Rectangle;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import tiled.core.MapLayer;
import tiled.core.TileLayer;

public class MultilayerPlane
implements Iterable<MapLayer> {
    private Vector<MapLayer> layers = new Vector();
    protected Rectangle bounds = new Rectangle();

    public MultilayerPlane() {
    }

    public MultilayerPlane(int width, int height) {
        this();
        this.bounds.width = width;
        this.bounds.height = height;
    }

    public int getTotalLayers() {
        return this.layers.size();
    }

    public void fitBoundsToLayers() {
        int width = 0;
        int height = 0;
        Rectangle layerBounds = new Rectangle();
        for (int i = 0; i < this.layers.size(); ++i) {
            this.getLayer(i).getBounds(layerBounds);
            if (width < layerBounds.width) {
                width = layerBounds.width;
            }
            if (height >= layerBounds.height) continue;
            height = layerBounds.height;
        }
        this.bounds.width = width;
        this.bounds.height = height;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.bounds);
    }

    public MapLayer addLayer(MapLayer layer) {
        this.layers.add(layer);
        return layer;
    }

    public void addLayerAfter(MapLayer l, MapLayer after) {
        this.layers.add(this.layers.indexOf(after) + 1, l);
    }

    public void addLayer(int index, MapLayer layer) {
        this.layers.add(index, layer);
    }

    public void setLayer(int index, MapLayer layer) {
        this.layers.set(index, layer);
    }

    public void addAllLayers(Collection<MapLayer> layers) {
        this.layers.addAll(layers);
    }

    public MapLayer removeLayer(int index) {
        return this.layers.remove(index);
    }

    public void removeAllLayers() {
        this.layers.removeAllElements();
    }

    public Vector<MapLayer> getLayerVector() {
        return this.layers;
    }

    public void setLayerVector(Vector<MapLayer> layers) {
        this.layers = layers;
    }

    public void swapLayerUp(int index) {
        if (index + 1 == this.layers.size()) {
            throw new RuntimeException("Can't swap up when already at the top.");
        }
        MapLayer hold = this.layers.get(index + 1);
        this.layers.set(index + 1, this.getLayer(index));
        this.layers.set(index, hold);
    }

    public void swapLayerDown(int index) {
        if (index - 1 < 0) {
            throw new RuntimeException("Can't swap down when already at the bottom.");
        }
        MapLayer hold = this.layers.get(index - 1);
        this.layers.set(index - 1, this.getLayer(index));
        this.layers.set(index, hold);
    }

    public void mergeLayerDown(int index) {
        TileLayer ntl;
        if (index - 1 < 0) {
            throw new RuntimeException("Can't merge down bottom layer.");
        }
        try {
            ntl = (TileLayer)this.getLayer(index - 1).clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return;
        }
        this.getLayer(index).mergeOnto(ntl);
        this.setLayer(index - 1, ntl);
        this.removeLayer(index);
    }

    public MapLayer getLayer(int i) {
        try {
            return this.layers.get(i);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    public ListIterator<MapLayer> getLayers() {
        return this.layers.listIterator();
    }

    public void resize(int width, int height, int dx, int dy) {
        ListIterator<MapLayer> itr = this.getLayers();
        while (itr.hasNext()) {
            MapLayer layer = itr.next();
            if (layer.bounds.equals(this.bounds)) {
                layer.resize(width, height, dx, dy);
                continue;
            }
            layer.setOffset(layer.bounds.x + dx, layer.bounds.y + dy);
        }
        this.bounds.width = width;
        this.bounds.height = height;
    }

    public boolean inBounds(int x, int y) {
        return x >= 0 && y >= 0 && x < this.bounds.width && y < this.bounds.height;
    }

    @Override
    public Iterator<MapLayer> iterator() {
        return this.layers.iterator();
    }
}

