/*
 * Decompiled with CFR 0.152.
 */
package tiled.core;

import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.Iterator;
import java.util.LinkedList;
import tiled.core.Map;
import tiled.core.MapLayer;
import tiled.core.MapObject;

public class ObjectGroup
extends MapLayer {
    private LinkedList<MapObject> objects = new LinkedList();

    public ObjectGroup() {
    }

    public ObjectGroup(Map map) {
        super(map);
    }

    public ObjectGroup(Map map, int origx, int origy) {
        super(map);
        this.setBounds(new Rectangle(origx, origy, 0, 0));
    }

    public ObjectGroup(Rectangle area) {
        super(area);
    }

    @Override
    public void rotate(int angle) {
    }

    @Override
    public void mirror(int dir) {
    }

    @Override
    public void mergeOnto(MapLayer other) {
    }

    @Override
    public void maskedMergeOnto(MapLayer other, Area mask) {
    }

    @Override
    public void copyFrom(MapLayer other) {
    }

    @Override
    public void maskedCopyFrom(MapLayer other, Area mask) {
    }

    @Override
    public void copyTo(MapLayer other) {
    }

    @Override
    public void resize(int width, int height, int dx, int dy) {
    }

    @Override
    public boolean isEmpty() {
        return this.objects.isEmpty();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ObjectGroup clone = (ObjectGroup)super.clone();
        clone.objects = new LinkedList();
        for (MapObject object : this.objects) {
            MapObject objectClone = (MapObject)object.clone();
            clone.objects.add(objectClone);
            objectClone.setObjectGroup(clone);
        }
        return clone;
    }

    @Override
    public MapLayer createDiff(MapLayer ml) {
        return null;
    }

    public void addObject(MapObject o) {
        this.objects.add(o);
        o.setObjectGroup(this);
    }

    public void removeObject(MapObject o) {
        this.objects.remove(o);
        o.setObjectGroup(null);
    }

    public Iterator<MapObject> getObjects() {
        return this.objects.iterator();
    }

    public MapObject getObjectAt(int x, int y) {
        for (MapObject obj : this.objects) {
            if (obj.getWidth() == 0 && obj.getX() + this.bounds.x == x) {
                return obj;
            }
            if (obj.getHeight() == 0 && obj.getY() + this.bounds.y == y) {
                return obj;
            }
            Rectangle rect = new Rectangle(obj.getX() + this.bounds.x * this.myMap.getTileWidth(), obj.getY() + this.bounds.y * this.myMap.getTileHeight(), obj.getWidth(), obj.getHeight());
            if (!rect.contains(x, y)) continue;
            return obj;
        }
        return null;
    }

    public MapObject getObjectNear(int x, int y, double zoom) {
        Rectangle2D.Double mouse = new Rectangle2D.Double((double)x - zoom - 1.0, (double)y - zoom - 1.0, 2.0 * zoom + 1.0, 2.0 * zoom + 1.0);
        for (MapObject obj : this.objects) {
            RectangularShape shape = obj.getWidth() == 0 && obj.getHeight() == 0 ? new Ellipse2D.Double((double)obj.getX() * zoom, (double)obj.getY() * zoom, 10.0 * zoom, 10.0 * zoom) : new Rectangle2D.Double(obj.getX() + this.bounds.x * this.myMap.getTileWidth(), obj.getY() + this.bounds.y * this.myMap.getTileHeight(), obj.getWidth() > 0 ? (double)obj.getWidth() : zoom, obj.getHeight() > 0 ? (double)obj.getHeight() : zoom);
            if (!shape.intersects(mouse)) continue;
            return obj;
        }
        return null;
    }
}

