/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.actions;

import javax.swing.JOptionPane;
import tiled.core.Map;
import tiled.core.TileLayer;
import tiled.mapeditor.MapEditor;
import tiled.mapeditor.Resources;
import tiled.mapeditor.actions.AbstractLayerAction;
import tiled.util.TileMergeHelper;

public class MergeAllLayersAction
extends AbstractLayerAction {
    public MergeAllLayersAction(MapEditor editor) {
        super(editor, Resources.getString("action.layer.mergeall.name"), Resources.getString("action.layer.mergeall.tooltip"));
    }

    @Override
    protected void doPerformAction() {
        Map map = this.editor.getCurrentMap();
        int ret = JOptionPane.showConfirmDialog(this.editor.getAppFrame(), "Do you wish to merge tile images, and create a new tile set?", "Merge Tiles?", 1);
        if (ret == 0) {
            TileMergeHelper tmh = new TileMergeHelper(map);
            int len = map.getTotalLayers();
            TileLayer newLayer = tmh.merge(0, len, true);
            map.removeAllLayers();
            map.addLayer(newLayer);
            newLayer.setName("Merged Layer");
            map.addTileset(tmh.getSet());
            this.editor.setCurrentLayer(0);
        } else if (ret == 1) {
            while (map.getTotalLayers() > 1) {
                map.mergeLayerDown(this.editor.getCurrentLayerIndex());
            }
            this.editor.setCurrentLayer(0);
        }
    }
}

