/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.brush;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import tiled.core.MultilayerPlane;
import tiled.mapeditor.brush.Brush;
import tiled.view.MapView;

public abstract class AbstractBrush
extends MultilayerPlane
implements Brush {
    protected int numLayers = 1;
    protected MultilayerPlane affectedMp;
    protected boolean paintingStarted = false;
    protected int initLayer;

    public AbstractBrush() {
    }

    public AbstractBrush(AbstractBrush ab) {
        this.numLayers = ab.numLayers;
    }

    public void setAffectedLayers(int num) {
        this.numLayers = num;
    }

    @Override
    public int getAffectedLayers() {
        return this.numLayers;
    }

    @Override
    public void startPaint(MultilayerPlane mp, int x, int y, int button, int layer) {
        this.affectedMp = mp;
        this.initLayer = layer;
        this.paintingStarted = true;
    }

    @Override
    public Rectangle doPaint(int x, int y) throws Exception {
        if (!this.paintingStarted) {
            throw new Exception("Attempted to call doPaint() without calling startPaint()!");
        }
        return null;
    }

    @Override
    public void endPaint() {
        this.paintingStarted = false;
    }

    @Override
    public void drawPreview(Graphics2D g2d, Dimension dimension, MapView mv) {
    }

    public abstract Shape getShape();
}

