/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.dialogs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.PixelGrabber;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import tiled.mapeditor.Resources;
import tiled.mapeditor.widget.ImageViewPanel;
import tiled.mapeditor.widget.VerticalStaticJPanel;

public class ImageColorDialog
extends JDialog
implements MouseListener,
MouseMotionListener {
    private Image image;
    private JButton cancelButton;
    private Color color;
    private JPanel colorPanel;
    private int[] pixels;
    private static final String DIALOG_TITLE = Resources.getString("dialog.imagecolor.title");
    private static final String CANCEL_BUTTON = Resources.getString("general.button.cancel");

    public ImageColorDialog(Image image) {
        this.image = image;
        PixelGrabber pg = new PixelGrabber(image, 0, 0, -1, -1, true);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.pixels = (int[])pg.getPixels();
        this.init();
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.setModal(true);
    }

    private void init() {
        ImageViewPanel imagePanel = new ImageViewPanel(this.image);
        imagePanel.addMouseListener(this);
        imagePanel.addMouseMotionListener(this);
        this.setTitle(DIALOG_TITLE);
        this.color = new Color(255, 103, 139);
        this.colorPanel = new JPanel();
        this.colorPanel.setPreferredSize(new Dimension(25, 25));
        this.colorPanel.setBackground(this.color);
        this.cancelButton = new JButton(CANCEL_BUTTON);
        JScrollPane imageScrollPane = new JScrollPane(imagePanel);
        imageScrollPane.setAutoscrolls(true);
        VerticalStaticJPanel mainPanel = new VerticalStaticJPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(imageScrollPane);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.fill = 2;
        buttonPanel.add(this.colorPanel);
        c.gridx = 1;
        buttonPanel.add(Box.createRigidArea(new Dimension(25, 5)));
        c.gridx = 2;
        buttonPanel.add(this.cancelButton);
        mainPanel.add(buttonPanel);
        this.setContentPane(mainPanel);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ImageColorDialog.this.color = null;
                ImageColorDialog.this.dispose();
            }
        });
    }

    public Color showDialog() {
        this.setVisible(true);
        return this.color;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.grabColor(e.getX(), e.getY());
        this.dispose();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.grabColor(e.getX(), e.getY());
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.grabColor(e.getX(), e.getY());
    }

    private void grabColor(int x, int y) {
        int w = this.image.getWidth(null);
        int h = this.image.getHeight(null);
        if (this.pixels != null && x < w && y < h) {
            int r = this.pixels[y * w + x] >> 16 & 0xFF;
            int g = this.pixels[y * w + x] >> 8 & 0xFF;
            int b = this.pixels[y * w + x] & 0xFF;
            this.color = new Color(r, g, b);
            this.colorPanel.setBackground(this.color);
        }
    }
}

