/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.plugin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JFrame;
import javax.swing.ProgressMonitor;
import tiled.io.MapReader;
import tiled.io.MapWriter;
import tiled.io.PluggableMapIO;
import tiled.util.TiledConfiguration;

public final class PluginClassLoader
extends URLClassLoader {
    private final Vector plugins = new Vector();
    private final Vector readers = new Vector();
    private final Vector writers = new Vector();
    private final Hashtable<String, String> readerFormats = new Hashtable();
    private final Hashtable<String, String> writerFormats = new Hashtable();
    private static PluginClassLoader instance;

    private PluginClassLoader() {
        super(new URL[0]);
    }

    public static synchronized PluginClassLoader getInstance() {
        if (instance == null) {
            instance = new PluginClassLoader();
        }
        return instance;
    }

    public void readPlugins(String base, JFrame parent) throws Exception {
        File[] files;
        File dir;
        String baseURL = base;
        if (base == null) {
            baseURL = TiledConfiguration.root().get("pluginsDir", "tiled_plugins");
        }
        if (!(dir = new File(baseURL)).exists() || !dir.canRead()) {
            return;
        }
        int total = 0;
        for (File file : files = dir.listFiles()) {
            String aPath = file.getAbsolutePath();
            if (!aPath.endsWith(".jar")) continue;
            ++total;
        }
        ProgressMonitor monitor = new ProgressMonitor(parent, "Loading plugins", "", 0, total - 1);
        monitor.setProgress(0);
        monitor.setMillisToPopup(0);
        monitor.setMillisToDecideToPopup(0);
        for (int i = 0; i < files.length; ++i) {
            String aPath = files[i].getAbsolutePath();
            String aName = aPath.substring(aPath.lastIndexOf(File.separatorChar) + 1);
            if (!aPath.endsWith(".jar")) continue;
            try {
                monitor.setNote("Reading " + aName + "...");
                JarFile jf = new JarFile(files[i]);
                monitor.setProgress(i);
                if (jf.getManifest() == null) continue;
                String readerClassName = jf.getManifest().getMainAttributes().getValue("Reader-Class");
                String writerClassName = jf.getManifest().getMainAttributes().getValue("Writer-Class");
                Class readerClass = null;
                Class writerClass = null;
                if (readerClassName == null && writerClassName == null) continue;
                monitor.setNote("Loading " + aName + "...");
                this.addURL(new File(aPath).toURI().toURL());
                if (readerClassName != null) {
                    JarEntry reader = jf.getJarEntry(readerClassName.replace('.', '/') + ".class");
                    if (reader != null) {
                        readerClass = this.loadFromJar(jf, reader, readerClassName);
                    } else {
                        System.err.println("Manifest entry " + readerClassName + " does not match any class in the jar.");
                    }
                }
                if (writerClassName != null) {
                    JarEntry writer = jf.getJarEntry(writerClassName.replace('.', '/') + ".class");
                    if (writer != null) {
                        writerClass = this.loadFromJar(jf, writer, writerClassName);
                    } else {
                        System.err.println("Manifest entry " + writerClassName + " does not match any class in the jar.");
                    }
                }
                boolean bPlugin = false;
                if (PluginClassLoader.isReader(readerClass)) {
                    bPlugin = true;
                }
                if (PluginClassLoader.isWriter(writerClass)) {
                    bPlugin = true;
                }
                if (!bPlugin) continue;
                if (readerClass != null) {
                    this._add(readerClass);
                }
                if (writerClass == null) continue;
                this._add(writerClass);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public MapReader[] getReaders() {
        return this.readers.toArray(new MapReader[this.readers.size()]);
    }

    public MapWriter[] getWriters() {
        return this.writers.toArray(new MapWriter[this.writers.size()]);
    }

    public Object getReaderFor(String file) throws Exception {
        for (String key : this.readerFormats.keySet()) {
            String ext = key.substring(1);
            if (!file.toLowerCase().endsWith(ext)) continue;
            return this.loadClass(this.readerFormats.get(key)).newInstance();
        }
        throw new Exception("No reader plugin exists for this file type.");
    }

    public Object getWriterFor(String file) throws Exception {
        for (String key : this.writerFormats.keySet()) {
            String ext = key.substring(1);
            if (!file.toLowerCase().endsWith(ext)) continue;
            return this.loadClass(this.writerFormats.get(key)).newInstance();
        }
        throw new Exception("No writer plugin exists for this file type.");
    }

    public Class loadFromJar(JarFile jf, JarEntry je, String className) throws IOException {
        int n;
        byte[] buffer = new byte[(int)je.getSize()];
        InputStream in = jf.getInputStream(je);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((n = in.read(buffer)) > 0) {
            baos.write(buffer, 0, n);
        }
        buffer = baos.toByteArray();
        if ((long)buffer.length < je.getSize()) {
            throw new IOException("Failed to read entire entry! (" + buffer.length + "<" + je.getSize() + ")");
        }
        return this.defineClass(className, buffer, 0, buffer.length);
    }

    private static boolean doesImplement(Class klass, String interfaceName) throws Exception {
        Class<?>[] interfaces;
        if (klass == null) {
            return false;
        }
        for (Class<?> anInterface : interfaces = klass.getInterfaces()) {
            String name = anInterface.toString();
            if (!name.substring(name.indexOf(32) + 1).equals(interfaceName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isReader(Class klass) throws Exception {
        return PluginClassLoader.doesImplement(klass, "tiled.io.MapReader");
    }

    private static boolean isWriter(Class writerClass) throws Exception {
        return PluginClassLoader.doesImplement(writerClass, "tiled.io.MapWriter");
    }

    private void _add(Class klass) throws Exception {
        try {
            PluggableMapIO p = (PluggableMapIO)klass.newInstance();
            String clname = klass.toString();
            clname = clname.substring(clname.indexOf(32) + 1);
            String filter = p.getFilter();
            String[] extensions = filter.split(",");
            if (PluginClassLoader.isReader(klass)) {
                for (String extension : extensions) {
                    this.readerFormats.put(extension, clname);
                }
                this.readers.add(p);
            } else if (PluginClassLoader.isWriter(klass)) {
                for (String extension : extensions) {
                    this.writerFormats.put(extension, clname);
                }
                this.writers.add(p);
            }
        }
        catch (NoClassDefFoundError e) {
            System.err.println("**Failed loading plugin: " + e.toString());
        }
    }
}

