/*
 * Decompiled with CFR 0.152.
 */
package tiled.mapeditor.widget;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import tiled.view.MapView;

public class MiniMapViewer
extends JPanel {
    public static final int MAX_HEIGHT = 150;
    private MapView myView;
    private JScrollPane mainPanel;
    private double scale = 0.0625;
    private BufferedImage renderedMap;

    public MiniMapViewer() {
        this.setSize(150, 150);
    }

    public MiniMapViewer(MapView view) {
        this();
        this.setView(view);
    }

    public void setView(MapView view) {
        this.myView = view;
        this.myView.setZoom(this.scale);
        Dimension d = this.myView.getPreferredSize();
        this.renderedMap = new BufferedImage(d.width, d.height, 2);
        Graphics2D g = this.renderedMap.createGraphics();
        g.setClip(0, 0, d.width, d.height);
        this.myView.paint(g);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.myView != null) {
            return this.myView.getPreferredSize();
        }
        return new Dimension(0, 0);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public void setMainPanel(JScrollPane main) {
        this.mainPanel = main;
    }

    public void refresh() {
        if (this.renderedMap != null && this.myView != null) {
            Dimension d = this.myView.getPreferredSize();
            Graphics2D g = this.renderedMap.createGraphics();
            g.setClip(0, 0, d.width, d.height);
            this.myView.paint(g);
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.renderedMap != null) {
            g.drawImage(this.renderedMap, 0, 0, null);
        }
        if (this.mainPanel != null) {
            g.setColor(Color.yellow);
            Rectangle viewArea = this.mainPanel.getViewport().getBounds();
            if (viewArea != null) {
                g.drawRect((int)((double)(viewArea.x - 1) * this.scale), (int)((double)(viewArea.y - 1) * this.scale), (int)((double)(viewArea.width - 1) * this.scale), (int)((double)(viewArea.height - 1) * this.scale));
            }
        }
    }
}

