/*
 * Decompiled with CFR 0.152.
 */
package tiled.util;

import java.util.Random;

public class MersenneTwister
extends Random {
    public static final int N = 624;
    public static final int M = 397;
    public static final int MATRIX_A = -1727483681;
    public static final int UPPER_MASK = Integer.MIN_VALUE;
    public static final int LOWER_MASK = Integer.MAX_VALUE;
    private long[] mt = new long[624];
    private int mti = 625;

    public MersenneTwister() {
    }

    public MersenneTwister(long s) {
        this();
        this.initGenRand(s);
    }

    public void initGenRand(long s) {
        this.mt[0] = s;
        this.mti = 1;
        while (this.mti < 624) {
            this.mt[this.mti] = 1812433253L * (this.mt[this.mti - 1] ^ this.mt[this.mti - 1] >> 30) + (long)this.mti;
            int n = this.mti++;
            this.mt[n] = this.mt[n] & 0xFFFFFFFFFFFFFFFFL;
        }
    }

    public void initByArray(long[] init_key, int key_length) {
        int k;
        this.initGenRand(19650218L);
        int i = 1;
        int j = 0;
        int n = k = 624 > key_length ? 624 : key_length;
        while (k != 0) {
            this.mt[i] = (this.mt[i] ^ (this.mt[i - 1] ^ this.mt[i - 1] >> 30) * 1664525L) + init_key[j] + (long)j;
            int n2 = i++;
            this.mt[n2] = this.mt[n2] & 0xFFFFFFFFFFFFFFFFL;
            ++j;
            if (i >= 624) {
                this.mt[0] = this.mt[623];
                i = 1;
            }
            if (j >= key_length) {
                j = 0;
            }
            --k;
        }
        for (k = 623; k != 0; --k) {
            this.mt[i] = (this.mt[i] ^ (this.mt[i - 1] ^ this.mt[i - 1] >> 30) * 1566083941L) - (long)i;
            int n3 = i++;
            this.mt[n3] = this.mt[n3] & 0xFFFFFFFFFFFFFFFFL;
            if (i < 624) continue;
            this.mt[0] = this.mt[623];
            i = 1;
        }
        this.mt[0] = Integer.MIN_VALUE;
    }

    public long genrand() {
        int y;
        long[] mag01 = new long[]{0L, -1727483681L};
        if (this.mti >= 624) {
            int kk;
            if (this.mti == 625) {
                this.initGenRand(5489L);
            }
            for (kk = 0; kk < 227; ++kk) {
                y = (int)(this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE);
                this.mt[kk] = this.mt[kk + 397] ^ (long)(y >> 1) ^ mag01[y & 1];
            }
            while (kk < 623) {
                y = (int)(this.mt[kk] & Integer.MIN_VALUE | this.mt[kk + 1] & Integer.MAX_VALUE);
                this.mt[kk] = this.mt[kk + -227] ^ (long)(y >> 1) ^ mag01[y & 1];
                ++kk;
            }
            y = (int)(this.mt[623] & Integer.MIN_VALUE | this.mt[0] & Integer.MAX_VALUE);
            this.mt[623] = this.mt[396] ^ (long)(y >> 1) ^ mag01[y & 1];
            this.mti = 0;
        }
        y = (int)this.mt[this.mti++];
        y ^= y >> 11;
        y ^= y << 7 & 0x9D2C5680;
        y ^= y << 15 & 0xEFC60000;
        y ^= y >> 18;
        return y;
    }

    @Override
    protected synchronized int next(int bits) {
        return (int)this.genrand();
    }
}

