/*
 * Decompiled with CFR 0.152.
 */
package tiled.view;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import tiled.core.Map;
import tiled.core.MapLayer;
import tiled.core.MultilayerPlane;
import tiled.core.ObjectGroup;
import tiled.core.TileLayer;
import tiled.mapeditor.Resources;
import tiled.mapeditor.brush.Brush;
import tiled.mapeditor.selection.SelectionLayer;
import tiled.view.HexMapView;
import tiled.view.IsoMapView;
import tiled.view.OrthoMapView;
import tiled.view.ShiftedMapView;

public abstract class MapView
extends JPanel
implements Scrollable {
    public static final int PF_BOUNDARYMODE = 2;
    public static final int PF_COORDINATES = 4;
    public static final int PF_NOSPECIAL = 8;
    public static int ZOOM_NORMALSIZE = 5;
    protected Map map;
    protected Brush currentBrush;
    protected int modeFlags;
    protected double zoom = 1.0;
    protected int zoomLevel = ZOOM_NORMALSIZE;
    protected boolean showGrid;
    protected boolean antialiasGrid;
    protected Color gridColor;
    protected int gridOpacity;
    protected static double[] zoomLevels = new double[]{0.0625, 0.125, 0.25, 0.5, 0.75, 1.0, 1.5, 2.0, 3.0, 4.0};
    private static final Color DEFAULT_BACKGROUND_COLOR = new Color(64, 64, 64);
    public static final Color DEFAULT_GRID_COLOR = Color.black;
    protected static Image propertyFlagImage;

    protected MapView(Map map) {
        if (propertyFlagImage == null) {
            try {
                propertyFlagImage = Resources.getImage("propertyflag-12.png");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.map = map;
        this.setOpaque(true);
    }

    public void toggleMode(int modeModifier) {
        this.modeFlags ^= modeModifier;
        this.revalidate();
        this.repaint();
    }

    public void setMode(int modeModifier, boolean value) {
        this.modeFlags = value ? (this.modeFlags |= modeModifier) : (this.modeFlags &= ~modeModifier);
        this.revalidate();
        this.repaint();
    }

    public boolean getMode(int modeModifier) {
        return (this.modeFlags & modeModifier) != 0;
    }

    public void setGridColor(Color gridColor) {
        this.gridColor = gridColor;
        this.repaint();
    }

    public void setGridOpacity(int gridOpacity) {
        this.gridOpacity = gridOpacity;
        this.repaint();
    }

    public void setAntialiasGrid(boolean antialiasGrid) {
        this.antialiasGrid = antialiasGrid;
        this.repaint();
    }

    public boolean getShowGrid() {
        return this.showGrid;
    }

    public void setShowGrid(boolean showGrid) {
        this.showGrid = showGrid;
        this.revalidate();
        this.repaint();
    }

    public void setBrush(Brush brush) {
        this.currentBrush = brush;
    }

    public boolean zoomIn() {
        if (this.zoomLevel < zoomLevels.length - 1) {
            this.setZoomLevel(this.zoomLevel + 1);
        }
        return this.zoomLevel < zoomLevels.length - 1;
    }

    public boolean zoomOut() {
        if (this.zoomLevel > 0) {
            this.setZoomLevel(this.zoomLevel - 1);
        }
        return this.zoomLevel > 0;
    }

    public void setZoom(double zoom) {
        if (zoom > 0.0) {
            this.zoom = zoom;
            this.setSize(this.getPreferredSize());
        }
    }

    public void setZoomLevel(int zoomLevel) {
        if (zoomLevel >= 0 && zoomLevel < zoomLevels.length) {
            this.zoomLevel = zoomLevel;
            this.setZoom(zoomLevels[zoomLevel]);
        }
    }

    public double getZoom() {
        return this.zoom;
    }

    public int getZoomLevel() {
        return this.zoomLevel;
    }

    @Override
    public abstract Dimension getPreferredSize();

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public abstract int getScrollableBlockIncrement(Rectangle var1, int var2, int var3);

    @Override
    public abstract int getScrollableUnitIncrement(Rectangle var1, int var2, int var3);

    public static MapView createViewforMap(Map p) {
        MapView mapView = null;
        int orientation = p.getOrientation();
        if (orientation == 2) {
            mapView = new IsoMapView(p);
        } else if (orientation == 1) {
            mapView = new OrthoMapView(p);
        } else if (orientation == 4) {
            mapView = new HexMapView(p);
        } else if (orientation == 5) {
            mapView = new ShiftedMapView(p);
        }
        return mapView;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g.create();
        Rectangle clip = g2d.getClipBounds();
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.setColor(DEFAULT_BACKGROUND_COLOR);
        g2d.fillRect(clip.x, clip.y, clip.width, clip.height);
        this.paintSubMap(this.map, g2d, 1.0f);
        if (!this.getMode(8)) {
            Iterator li = this.map.getLayersSpecial();
            while (li.hasNext()) {
                MapLayer layer = (MapLayer)li.next();
                if (!layer.isVisible()) continue;
                if (layer instanceof SelectionLayer) {
                    g2d.setComposite(AlphaComposite.getInstance(10, 0.3f));
                    g2d.setColor(((SelectionLayer)layer).getHighlightColor());
                }
                this.paintLayer(g2d, (TileLayer)layer);
            }
            if (this.currentBrush != null) {
                this.currentBrush.drawPreview(g2d, this);
            }
        }
        g2d.setColor(this.gridColor);
        if (this.showGrid) {
            if (this.gridOpacity < 255) {
                g2d.setComposite(AlphaComposite.getInstance(10, (float)this.gridOpacity / 255.0f));
            } else {
                g2d.setComposite(AlphaComposite.SrcOver);
            }
            if (this.antialiasGrid) {
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
            g2d.setStroke(new BasicStroke());
            this.paintGrid(g2d);
        }
        if (this.getMode(4)) {
            g2d.setComposite(AlphaComposite.SrcOver);
            this.paintCoordinates(g2d);
        }
    }

    public void paintSubMap(MultilayerPlane m, Graphics2D g2d, float mapOpacity) {
        ListIterator<MapLayer> li = m.getLayers();
        while (li.hasNext()) {
            MapLayer layer = (MapLayer)li.next();
            if (layer == null) continue;
            float opacity = layer.getOpacity() * mapOpacity;
            if (!layer.isVisible() || !(opacity > 0.0f)) continue;
            if (opacity < 1.0f) {
                g2d.setComposite(AlphaComposite.getInstance(10, opacity));
            } else {
                g2d.setComposite(AlphaComposite.SrcOver);
            }
            if (layer instanceof TileLayer) {
                this.paintLayer(g2d, (TileLayer)layer);
                continue;
            }
            if (!(layer instanceof ObjectGroup)) continue;
            this.paintObjectGroup(g2d, (ObjectGroup)layer);
        }
    }

    protected abstract void paintLayer(Graphics2D var1, TileLayer var2);

    protected abstract void paintObjectGroup(Graphics2D var1, ObjectGroup var2);

    protected void paintEdge(Graphics2D g2d, MapLayer layer, int x, int y) {
    }

    public void repaintRegion(Rectangle region) {
        this.repaint();
    }

    protected abstract void paintGrid(Graphics2D var1);

    protected abstract void paintCoordinates(Graphics2D var1);

    protected abstract void paintPropertyFlags(Graphics2D var1, TileLayer var2);

    protected abstract Polygon createGridPolygon(int var1, int var2, int var3);

    public abstract Point screenToTileCoords(int var1, int var2);

    public abstract Point screenToPixelCoords(int var1, int var2);

    public abstract Point tileToScreenCoords(int var1, int var2);
}

