/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JSONArray {
    private ArrayList myArrayList;

    public JSONArray() {
        this.myArrayList = new ArrayList();
    }

    public JSONArray(JSONTokener jSONTokener) throws ParseException {
        this();
        if (jSONTokener.nextClean() != '[') {
            throw jSONTokener.syntaxError("A JSONArray must start with '['");
        }
        if (jSONTokener.nextClean() == ']') {
            return;
        }
        jSONTokener.back();
        block4: while (true) {
            if (jSONTokener.nextClean() == ',') {
                jSONTokener.back();
                this.myArrayList.add(null);
            } else {
                jSONTokener.back();
                this.myArrayList.add(jSONTokener.nextValue());
            }
            switch (jSONTokener.nextClean()) {
                case ',': {
                    if (jSONTokener.nextClean() == ']') {
                        return;
                    }
                    jSONTokener.back();
                    continue block4;
                }
                case ']': {
                    return;
                }
            }
            break;
        }
        throw jSONTokener.syntaxError("Expected a ',' or ']'");
    }

    public JSONArray(String string) throws ParseException {
        this(new JSONTokener(string));
    }

    public JSONArray(Collection collection) {
        this.myArrayList = new ArrayList(collection);
    }

    public Object get(int n) throws NoSuchElementException {
        Object object = this.opt(n);
        if (object == null) {
            throw new NoSuchElementException("JSONArray[" + n + "] not found.");
        }
        return object;
    }

    ArrayList getArrayList() {
        return this.myArrayList;
    }

    public boolean getBoolean(int n) throws ClassCastException, NoSuchElementException {
        Object object = this.get(n);
        if (object == Boolean.FALSE || object.equals("false")) {
            return false;
        }
        if (object == Boolean.TRUE || object.equals("true")) {
            return true;
        }
        throw new ClassCastException("JSONArray[" + n + "] not a Boolean.");
    }

    public double getDouble(int n) throws NoSuchElementException, NumberFormatException {
        Object object = this.get(n);
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            return Double.parseDouble((String)object);
        }
        throw new NumberFormatException("JSONObject[" + n + "] is not a number.");
    }

    public int getInt(int n) throws NoSuchElementException, NumberFormatException {
        Object object = this.get(n);
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return (int)this.getDouble(n);
    }

    public JSONArray getJSONArray(int n) throws NoSuchElementException {
        Object object = this.get(n);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw new NoSuchElementException("JSONArray[" + n + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(int n) throws NoSuchElementException {
        Object object = this.get(n);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw new NoSuchElementException("JSONArray[" + n + "] is not a JSONObject.");
    }

    public String getString(int n) throws NoSuchElementException {
        return this.get(n).toString();
    }

    public boolean isNull(int n) {
        Object object = this.opt(n);
        return object == null || object.equals(null);
    }

    public String join(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.myArrayList.size(); ++i) {
            Object e;
            if (i > 0) {
                stringBuffer.append(string);
            }
            if ((e = this.myArrayList.get(i)) == null) {
                stringBuffer.append("null");
                continue;
            }
            if (e instanceof String) {
                stringBuffer.append(JSONObject.quote((String)e));
                continue;
            }
            if (e instanceof Number) {
                stringBuffer.append(JSONObject.numberToString((Number)e));
                continue;
            }
            stringBuffer.append(e.toString());
        }
        return stringBuffer.toString();
    }

    public int length() {
        return this.myArrayList.size();
    }

    public Object opt(int n) {
        if (n < 0 || n >= this.length()) {
            return null;
        }
        return this.myArrayList.get(n);
    }

    public boolean optBoolean(int n) {
        return this.optBoolean(n, false);
    }

    public boolean optBoolean(int n, boolean bl) {
        Object object = this.opt(n);
        if (object != null) {
            if (object == Boolean.FALSE || object.equals("false")) {
                return false;
            }
            if (object == Boolean.TRUE || object.equals("true")) {
                return true;
            }
        }
        return bl;
    }

    public double optDouble(int n) {
        return this.optDouble(n, Double.NaN);
    }

    public double optDouble(int n, double d) {
        Object object = this.opt(n);
        if (object != null) {
            if (object instanceof Number) {
                return ((Number)object).doubleValue();
            }
            try {
                return Double.parseDouble((String)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return d;
    }

    public int optInt(int n) {
        return this.optInt(n, 0);
    }

    public int optInt(int n, int n2) {
        Object object = this.opt(n);
        if (object != null) {
            if (object instanceof Number) {
                return ((Number)object).intValue();
            }
            try {
                return Integer.parseInt((String)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n2;
    }

    public JSONArray optJSONArray(int n) {
        Object object = this.opt(n);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        return null;
    }

    public JSONObject optJSONObject(int n) {
        Object object = this.opt(n);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        return null;
    }

    public String optString(int n) {
        return this.optString(n, "");
    }

    public String optString(int n, String string) {
        Object object = this.opt(n);
        if (object != null) {
            return object.toString();
        }
        return string;
    }

    public JSONArray put(boolean bl) {
        this.put(new Boolean(bl));
        return this;
    }

    public JSONArray put(double d) {
        this.put(new Double(d));
        return this;
    }

    public JSONArray put(int n) {
        this.put(new Integer(n));
        return this;
    }

    public JSONArray put(Object object) {
        this.myArrayList.add(object);
        return this;
    }

    public JSONArray put(int n, boolean bl) {
        this.put(n, new Boolean(bl));
        return this;
    }

    public JSONArray put(int n, double d) {
        this.put(n, new Double(d));
        return this;
    }

    public JSONArray put(int n, int n2) {
        this.put(n, new Integer(n2));
        return this;
    }

    public JSONArray put(int n, Object object) throws NoSuchElementException, NullPointerException {
        if (n < 0) {
            throw new NoSuchElementException("JSONArray[" + n + "] not found.");
        }
        if (object == null) {
            throw new NullPointerException();
        }
        if (n < this.length()) {
            this.myArrayList.set(n, object);
        } else {
            while (n != this.length()) {
                this.put(null);
            }
            this.put(object);
        }
        return this;
    }

    public JSONObject toJSONObject(JSONArray jSONArray) {
        if (jSONArray == null || jSONArray.length() == 0 || this.length() == 0) {
            return null;
        }
        JSONObject jSONObject = new JSONObject();
        for (int i = 0; i < jSONArray.length(); ++i) {
            jSONObject.put(jSONArray.getString(i), this.opt(i));
        }
        return jSONObject;
    }

    public String toString() {
        return '[' + this.join(",") + ']';
    }

    public String toString(int n) {
        return this.toString(n, 0);
    }

    String toString(int n, int n2) {
        int n3;
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        n2 += n;
        for (n3 = 0; n3 < n2; ++n3) {
            string = string + ' ';
        }
        stringBuffer.append("[\n");
        for (n3 = 0; n3 < this.myArrayList.size(); ++n3) {
            if (n3 > 0) {
                stringBuffer.append(",\n");
            }
            stringBuffer.append(string);
            Object e = this.myArrayList.get(n3);
            if (e == null) {
                stringBuffer.append("null");
                continue;
            }
            if (e instanceof String) {
                stringBuffer.append(JSONObject.quote((String)e));
                continue;
            }
            if (e instanceof Number) {
                stringBuffer.append(JSONObject.numberToString((Number)e));
                continue;
            }
            if (e instanceof JSONObject) {
                stringBuffer.append(((JSONObject)e).toString(n, n2));
                continue;
            }
            if (e instanceof JSONArray) {
                stringBuffer.append(((JSONArray)e).toString(n, n2));
                continue;
            }
            stringBuffer.append(e.toString());
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

