/*
 * Decompiled with CFR 0.152.
 */
package org.json;

import java.text.ParseException;
import org.json.JSONArray;
import org.json.JSONObject;

public class JSONTokener {
    private int myIndex = 0;
    private String mySource;

    public JSONTokener(String string) {
        this.mySource = string;
    }

    public void back() {
        if (this.myIndex > 0) {
            --this.myIndex;
        }
    }

    public static int dehexchar(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c + 10 - 65;
        }
        if (c >= 'a' && c <= 'f') {
            return c + 10 - 97;
        }
        return -1;
    }

    public boolean more() {
        return this.myIndex < this.mySource.length();
    }

    public char next() {
        char c = this.more() ? this.mySource.charAt(this.myIndex) : (char)'\u0000';
        ++this.myIndex;
        return c;
    }

    public char next(char c) throws ParseException {
        char c2 = this.next();
        if (c2 != c) {
            throw this.syntaxError("Expected '" + c + "' and instead saw '" + c2 + "'.");
        }
        return c2;
    }

    public String next(int n) throws ParseException {
        int n2 = this.myIndex;
        int n3 = n2 + n;
        if (n3 >= this.mySource.length()) {
            throw this.syntaxError("Substring bounds error");
        }
        this.myIndex += n;
        return this.mySource.substring(n2, n3);
    }

    public char nextClean() throws ParseException {
        char c;
        block4: while (true) {
            if ((c = this.next()) == '/') {
                switch (this.next()) {
                    case '/': {
                        while ((c = this.next()) != '\n' && c != '\r' && c != '\u0000') {
                        }
                        continue block4;
                    }
                    case '*': {
                        while (true) {
                            if ((c = this.next()) == '\u0000') {
                                throw this.syntaxError("Unclosed comment.");
                            }
                            if (c != '*') continue;
                            if (this.next() == '/') continue block4;
                            this.back();
                        }
                    }
                    default: {
                        this.back();
                        return '/';
                    }
                }
            }
            if (c == '\u0000' || c > ' ') break;
        }
        return c;
    }

    public String nextString(char c) throws ParseException {
        StringBuffer stringBuffer = new StringBuffer();
        block13: while (true) {
            char c2 = this.next();
            switch (c2) {
                case '\u0000': 
                case '\n': 
                case '\r': {
                    throw this.syntaxError("Unterminated string");
                }
                case '\\': {
                    c2 = this.next();
                    switch (c2) {
                        case 'b': {
                            stringBuffer.append('\b');
                            continue block13;
                        }
                        case 't': {
                            stringBuffer.append('\t');
                            continue block13;
                        }
                        case 'n': {
                            stringBuffer.append('\n');
                            continue block13;
                        }
                        case 'f': {
                            stringBuffer.append('\f');
                            continue block13;
                        }
                        case 'r': {
                            stringBuffer.append('\r');
                            continue block13;
                        }
                        case 'u': {
                            stringBuffer.append((char)Integer.parseInt(this.next(4), 16));
                            continue block13;
                        }
                        case 'x': {
                            stringBuffer.append((char)Integer.parseInt(this.next(2), 16));
                            continue block13;
                        }
                    }
                    stringBuffer.append(c2);
                    continue block13;
                }
            }
            if (c2 == c) {
                return stringBuffer.toString();
            }
            stringBuffer.append(c2);
        }
    }

    public String nextTo(char c) {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            char c2;
            if ((c2 = this.next()) == c || c2 == '\u0000' || c2 == '\n' || c2 == '\r') {
                if (c2 != '\u0000') {
                    this.back();
                }
                return stringBuffer.toString().trim();
            }
            stringBuffer.append(c2);
        }
    }

    public String nextTo(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            char c;
            if (string.indexOf(c = this.next()) >= 0 || c == '\u0000' || c == '\n' || c == '\r') {
                if (c != '\u0000') {
                    this.back();
                }
                return stringBuffer.toString().trim();
            }
            stringBuffer.append(c);
        }
    }

    public Object nextValue() throws ParseException {
        char c = this.nextClean();
        if (c == '\"' || c == '\'') {
            return this.nextString(c);
        }
        if (c == '{') {
            this.back();
            return new JSONObject(this);
        }
        if (c == '[') {
            this.back();
            return new JSONArray(this);
        }
        StringBuffer stringBuffer = new StringBuffer();
        char c2 = c;
        while (c >= ' ' && c != ':' && c != ',' && c != ']' && c != '}' && c != '/') {
            stringBuffer.append(c);
            c = this.next();
        }
        this.back();
        String string = stringBuffer.toString().trim();
        if (string.equals("true")) {
            return Boolean.TRUE;
        }
        if (string.equals("false")) {
            return Boolean.FALSE;
        }
        if (string.equals("null")) {
            return JSONObject.NULL;
        }
        if (c2 >= '0' && c2 <= '9' || c2 == '.' || c2 == '-' || c2 == '+') {
            try {
                return new Integer(string);
            }
            catch (Exception exception) {
                try {
                    return new Double(string);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        if (string.length() == 0) {
            throw this.syntaxError("Missing value.");
        }
        return string;
    }

    public char skipTo(char c) {
        char c2;
        int n = this.myIndex;
        do {
            if ((c2 = this.next()) != '\u0000') continue;
            this.myIndex = n;
            return c2;
        } while (c2 != c);
        this.back();
        return c2;
    }

    public void skipPast(String string) {
        this.myIndex = this.mySource.indexOf(string, this.myIndex);
        this.myIndex = this.myIndex < 0 ? this.mySource.length() : (this.myIndex += string.length());
    }

    public ParseException syntaxError(String string) {
        return new ParseException(string + this.toString(), this.myIndex);
    }

    public String toString() {
        return " at character " + this.myIndex + " of " + this.mySource;
    }

    void unescape() {
        this.mySource = JSONTokener.unescape(this.mySource);
    }

    public static String unescape(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '+') {
                c = ' ';
            } else if (c == '%' && i + 2 < n) {
                int n2 = JSONTokener.dehexchar(string.charAt(i + 1));
                int n3 = JSONTokener.dehexchar(string.charAt(i + 2));
                if (n2 >= 0 && n3 >= 0) {
                    c = (char)(n2 * 16 + n3);
                    i += 2;
                }
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

