/*
 * Decompiled with CFR 0.152.
 */
package com.incors.plaf.kunststoff;

import com.incors.plaf.kunststoff.KunststoffLookAndFeel;
import com.incors.plaf.kunststoff.KunststoffUtilities;
import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalToggleButtonUI;

public class KunststoffToggleButtonUI
extends MetalToggleButtonUI {
    private static final KunststoffToggleButtonUI buttonUI = new KunststoffToggleButtonUI();

    public static ComponentUI createUI(JComponent c2) {
        return buttonUI;
    }

    public void paint(Graphics g2, JComponent c2) {
        super.paint(g2, c2);
        if (!c2.isOpaque()) {
            return;
        }
        Container parent = c2.getParent();
        if (parent instanceof JToolBar) {
            int orientation = ((JToolBar)parent).getOrientation();
            Point loc = c2.getLocation();
            ColorUIResource colorReflection = KunststoffLookAndFeel.getComponentGradientColorReflection();
            ColorUIResource colorShadow = KunststoffLookAndFeel.getComponentGradientColorShadow();
            if (orientation == 0) {
                if (colorReflection != null) {
                    Color colorReflectionFaded = KunststoffUtilities.getTranslucentColor(colorReflection, 0);
                    Rectangle rectReflection = new Rectangle(0, -loc.y, parent.getWidth(), parent.getHeight() / 2);
                    KunststoffUtilities.drawGradient(g2, colorReflection, colorReflectionFaded, rectReflection, true);
                }
                if (colorShadow != null) {
                    Color colorShadowFaded = KunststoffUtilities.getTranslucentColor(colorShadow, 0);
                    Rectangle rectShadow = new Rectangle(0, parent.getHeight() / 2 - loc.y, parent.getWidth(), parent.getHeight() / 2);
                    KunststoffUtilities.drawGradient(g2, colorShadowFaded, colorShadow, rectShadow, true);
                }
            } else {
                if (colorReflection != null) {
                    Color colorReflectionFaded = KunststoffUtilities.getTranslucentColor(colorReflection, 0);
                    Rectangle rectReflection = new Rectangle(0, 0, parent.getWidth() / 2, parent.getHeight());
                    KunststoffUtilities.drawGradient(g2, colorReflection, colorReflectionFaded, rectReflection, false);
                }
                if (colorShadow != null) {
                    Color colorShadowFaded = KunststoffUtilities.getTranslucentColor(colorShadow, 0);
                    Rectangle rectShadow = new Rectangle(parent.getWidth() / 2 - loc.x, 0, parent.getWidth(), parent.getHeight());
                    KunststoffUtilities.drawGradient(g2, colorShadowFaded, colorShadow, rectShadow, false);
                }
            }
        } else {
            ColorUIResource colorShadow;
            ColorUIResource colorReflection = KunststoffLookAndFeel.getComponentGradientColorReflection();
            if (colorReflection != null) {
                Color colorReflectionFaded = KunststoffUtilities.getTranslucentColor(colorReflection, 0);
                Rectangle rect = new Rectangle(0, 0, c2.getWidth(), c2.getHeight() / 2);
                KunststoffUtilities.drawGradient(g2, colorReflection, colorReflectionFaded, rect, true);
            }
            if ((colorShadow = KunststoffLookAndFeel.getComponentGradientColorShadow()) != null) {
                Color colorShadowFaded = KunststoffUtilities.getTranslucentColor(colorShadow, 0);
                Rectangle rect = new Rectangle(0, c2.getHeight() / 2, c2.getWidth(), c2.getHeight() / 2);
                KunststoffUtilities.drawGradient(g2, colorShadowFaded, colorShadow, rect, true);
            }
        }
    }
}

