/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.awt.geom;

import com.itextpdf.awt.geom.Dimension;
import com.itextpdf.awt.geom.Point;
import com.itextpdf.awt.geom.Rectangle2D;
import com.itextpdf.awt.geom.Shape;
import java.io.Serializable;

public class Rectangle
extends Rectangle2D
implements Shape,
Serializable {
    private static final long serialVersionUID = -4345857070255674764L;
    public double x;
    public double y;
    public double width;
    public double height;

    public Rectangle() {
        this.setBounds(0, 0, 0, 0);
    }

    public Rectangle(Point p) {
        this.setBounds(p.x, p.y, 0.0, 0.0);
    }

    public Rectangle(Point p, Dimension d2) {
        this.setBounds(p.x, p.y, d2.width, d2.height);
    }

    public Rectangle(double x, double y, double width, double height) {
        this.setBounds(x, y, width, height);
    }

    public Rectangle(int width, int height) {
        this.setBounds(0, 0, width, height);
    }

    public Rectangle(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public Rectangle(com.itextpdf.text.Rectangle r) {
        r.normalize();
        this.setBounds(r.getLeft(), r.getBottom(), r.getWidth(), r.getHeight());
    }

    public Rectangle(Dimension d2) {
        this.setBounds(0.0, 0.0, d2.width, d2.height);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public boolean isEmpty() {
        return this.width <= 0.0 || this.height <= 0.0;
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public void setSize(int mx, int my) {
        this.setSize((double)mx, (double)my);
    }

    public void setSize(double width, double height) {
        this.width = width;
        this.height = height;
    }

    public void setSize(Dimension d2) {
        this.setSize(d2.width, d2.height);
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public void setLocation(int mx, int my) {
        this.setLocation((double)mx, (double)my);
    }

    public void setLocation(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }

    public void setRect(double x, double y, double width, double height) {
        int x1 = (int)Math.floor(x);
        int y1 = (int)Math.floor(y);
        int x2 = (int)Math.ceil(x + width);
        int y2 = (int)Math.ceil(y + height);
        this.setBounds(x1, y1, x2 - x1, y2 - y1);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Rectangle2D getBounds2D() {
        return this.getBounds();
    }

    public void setBounds(int x, int y, int width, int height) {
        this.setBounds((double)x, (double)y, (double)width, (double)height);
    }

    public void setBounds(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.height = height;
        this.width = width;
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void grow(int mx, int my) {
        this.translate((double)mx, (double)my);
    }

    public void grow(double dx, double dy) {
        this.x -= dx;
        this.y -= dy;
        this.width += dx + dx;
        this.height += dy + dy;
    }

    public void translate(int mx, int my) {
        this.translate((double)mx, (double)my);
    }

    public void translate(double mx, double my) {
        this.x += mx;
        this.y += my;
    }

    public void add(int px, int py) {
        this.add((double)px, (double)py);
    }

    public void add(double px, double py) {
        double x1 = Math.min(this.x, px);
        double x2 = Math.max(this.x + this.width, px);
        double y1 = Math.min(this.y, py);
        double y2 = Math.max(this.y + this.height, py);
        this.setBounds(x1, y1, x2 - x1, y2 - y1);
    }

    public void add(Point p) {
        this.add(p.x, p.y);
    }

    public void add(Rectangle r) {
        double x1 = Math.min(this.x, r.x);
        double x2 = Math.max(this.x + this.width, r.x + r.width);
        double y1 = Math.min(this.y, r.y);
        double y2 = Math.max(this.y + this.height, r.y + r.height);
        this.setBounds(x1, y1, x2 - x1, y2 - y1);
    }

    public boolean contains(int px, int py) {
        return this.contains((double)px, (double)py);
    }

    public boolean contains(double px, double py) {
        if (this.isEmpty()) {
            return false;
        }
        if (px < this.x || py < this.y) {
            return false;
        }
        return (px -= this.x) < this.width && (py -= this.y) < this.height;
    }

    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public boolean contains(int rx, int ry, int rw, int rh) {
        return this.contains(rx, ry) && this.contains(rx + rw - 1, ry + rh - 1);
    }

    public boolean contains(double rx, double ry, double rw, double rh) {
        return this.contains(rx, ry) && this.contains(rx + rw - 0.01, ry + rh - 0.01);
    }

    public boolean contains(Rectangle r) {
        return this.contains(r.x, r.y, r.width, r.height);
    }

    public Rectangle2D createIntersection(Rectangle2D r) {
        if (r instanceof Rectangle) {
            return this.intersection((Rectangle)r);
        }
        Rectangle2D.Double dst = new Rectangle2D.Double();
        Rectangle2D.intersect(this, r, dst);
        return dst;
    }

    public Rectangle intersection(Rectangle r) {
        double x1 = Math.max(this.x, r.x);
        double y1 = Math.max(this.y, r.y);
        double x2 = Math.min(this.x + this.width, r.x + r.width);
        double y2 = Math.min(this.y + this.height, r.y + r.height);
        return new Rectangle(x1, y1, x2 - x1, y2 - y1);
    }

    public boolean intersects(Rectangle r) {
        return !this.intersection(r).isEmpty();
    }

    public int outcode(double px, double py) {
        int code = 0;
        if (this.width <= 0.0) {
            code |= 5;
        } else if (px < this.x) {
            code |= 1;
        } else if (px > this.x + this.width) {
            code |= 4;
        }
        if (this.height <= 0.0) {
            code |= 0xA;
        } else if (py < this.y) {
            code |= 2;
        } else if (py > this.y + this.height) {
            code |= 8;
        }
        return code;
    }

    public Rectangle2D createUnion(Rectangle2D r) {
        if (r instanceof Rectangle) {
            return this.union((Rectangle)r);
        }
        Rectangle2D.Double dst = new Rectangle2D.Double();
        Rectangle2D.union(this, r, dst);
        return dst;
    }

    public Rectangle union(Rectangle r) {
        Rectangle dst = new Rectangle(this);
        dst.add(r);
        return dst;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Rectangle) {
            Rectangle r = (Rectangle)obj;
            return r.x == this.x && r.y == this.y && r.width == this.width && r.height == this.height;
        }
        return false;
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
    }
}

