/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import com.itextpdf.text.pdf.parser.ContentByteUtils;
import com.itextpdf.text.pdf.parser.LocationTextExtractionStrategy;
import com.itextpdf.text.pdf.parser.PdfTextExtractor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;

public class PdfContentReaderTool {
    public static String getDictionaryDetail(PdfDictionary dic) {
        return PdfContentReaderTool.getDictionaryDetail(dic, 0);
    }

    public static String getDictionaryDetail(PdfDictionary dic, int depth) {
        StringBuffer builder = new StringBuffer();
        builder.append('(');
        ArrayList<PdfName> subDictionaries = new ArrayList<PdfName>();
        for (PdfName key : dic.getKeys()) {
            PdfObject val = dic.getDirectObject(key);
            if (val.isDictionary()) {
                subDictionaries.add(key);
            }
            builder.append(key);
            builder.append('=');
            builder.append(val);
            builder.append(", ");
        }
        builder.setLength(builder.length() - 2);
        builder.append(')');
        for (PdfName pdfSubDictionaryName : subDictionaries) {
            builder.append('\n');
            for (int i2 = 0; i2 < depth + 1; ++i2) {
                builder.append('\t');
            }
            builder.append("Subdictionary ");
            builder.append(pdfSubDictionaryName);
            builder.append(" = ");
            builder.append(PdfContentReaderTool.getDictionaryDetail(dic.getAsDict(pdfSubDictionaryName), depth + 1));
        }
        return builder.toString();
    }

    public static String getXObjectDetail(PdfDictionary resourceDic) throws IOException {
        StringBuilder sb = new StringBuilder();
        PdfDictionary xobjects = resourceDic.getAsDict(PdfName.XOBJECT);
        if (xobjects == null) {
            return "No XObjects";
        }
        for (PdfName entryName : xobjects.getKeys()) {
            int ch;
            PdfStream xobjectStream = xobjects.getAsStream(entryName);
            sb.append("------ " + entryName + " - subtype = " + xobjectStream.get(PdfName.SUBTYPE) + " = " + xobjectStream.getAsNumber(PdfName.LENGTH) + " bytes ------\n");
            if (xobjectStream.get(PdfName.SUBTYPE).equals(PdfName.IMAGE)) continue;
            byte[] contentBytes = ContentByteUtils.getContentBytesFromContentObject(xobjectStream);
            ByteArrayInputStream is = new ByteArrayInputStream(contentBytes);
            while ((ch = ((InputStream)is).read()) != -1) {
                sb.append((char)ch);
            }
            sb.append("------ " + entryName + " - subtype = " + xobjectStream.get(PdfName.SUBTYPE) + "End of Content" + "------\n");
        }
        return sb.toString();
    }

    public static void listContentStreamForPage(PdfReader reader, int pageNum, PrintWriter out) throws IOException {
        int ch;
        out.println("==============Page " + pageNum + "====================");
        out.println("- - - - - Dictionary - - - - - -");
        PdfDictionary pageDictionary = reader.getPageN(pageNum);
        out.println(PdfContentReaderTool.getDictionaryDetail(pageDictionary));
        out.println("- - - - - XObject Summary - - - - - -");
        out.println(PdfContentReaderTool.getXObjectDetail(pageDictionary.getAsDict(PdfName.RESOURCES)));
        out.println("- - - - - Content Stream - - - - - -");
        RandomAccessFileOrArray f2 = reader.getSafeFile();
        byte[] contentBytes = reader.getPageContent(pageNum, f2);
        f2.close();
        out.flush();
        ByteArrayInputStream is = new ByteArrayInputStream(contentBytes);
        while ((ch = ((InputStream)is).read()) != -1) {
            out.print((char)ch);
        }
        out.flush();
        out.println("- - - - - Text Extraction - - - - - -");
        String extractedText = PdfTextExtractor.getTextFromPage(reader, pageNum, new LocationTextExtractionStrategy());
        if (extractedText.length() != 0) {
            out.println(extractedText);
        } else {
            out.println("No text found on page " + pageNum);
        }
        out.println();
    }

    public static void listContentStream(File pdfFile, PrintWriter out) throws IOException {
        PdfReader reader = new PdfReader(pdfFile.getCanonicalPath());
        int maxPageNum = reader.getNumberOfPages();
        for (int pageNum = 1; pageNum <= maxPageNum; ++pageNum) {
            PdfContentReaderTool.listContentStreamForPage(reader, pageNum, out);
        }
    }

    public static void listContentStream(File pdfFile, int pageNum, PrintWriter out) throws IOException {
        PdfReader reader = new PdfReader(pdfFile.getCanonicalPath());
        PdfContentReaderTool.listContentStreamForPage(reader, pageNum, out);
    }

    public static void main(String[] args) {
        try {
            if (args.length < 1 || args.length > 3) {
                System.out.println("Usage:  PdfContentReaderTool <pdf file> [<output file>|stdout] [<page num>]");
                return;
            }
            PrintWriter writer = new PrintWriter(System.out);
            if (args.length >= 2 && args[1].compareToIgnoreCase("stdout") != 0) {
                System.out.println("Writing PDF content to " + args[1]);
                writer = new PrintWriter(new FileOutputStream(new File(args[1])));
            }
            int pageNum = -1;
            if (args.length >= 3) {
                pageNum = Integer.parseInt(args[2]);
            }
            if (pageNum == -1) {
                PdfContentReaderTool.listContentStream(new File(args[0]), writer);
            } else {
                PdfContentReaderTool.listContentStream(new File(args[0]), pageNum, writer);
            }
            writer.flush();
            if (args.length >= 2) {
                writer.close();
                System.out.println("Finished writing content to " + args[1]);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace(System.err);
        }
    }
}

