/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.io.RandomAccessSourceFactory;
import com.itextpdf.text.pdf.CMapAwareDocumentFont;
import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PRTokeniser;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfContentParser;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfLiteral;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import com.itextpdf.text.pdf.parser.ContentByteUtils;
import com.itextpdf.text.pdf.parser.ContentOperator;
import com.itextpdf.text.pdf.parser.GraphicsState;
import com.itextpdf.text.pdf.parser.ImageRenderInfo;
import com.itextpdf.text.pdf.parser.InlineImageUtils;
import com.itextpdf.text.pdf.parser.MarkedContentInfo;
import com.itextpdf.text.pdf.parser.Matrix;
import com.itextpdf.text.pdf.parser.RenderListener;
import com.itextpdf.text.pdf.parser.TextRenderInfo;
import com.itextpdf.text.pdf.parser.XObjectDoHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfContentStreamProcessor {
    public static final String DEFAULTOPERATOR = "DefaultOperator";
    private final Map<String, ContentOperator> operators;
    private ResourceDictionary resources;
    private final Stack<GraphicsState> gsStack = new Stack();
    private Matrix textMatrix;
    private Matrix textLineMatrix;
    private final RenderListener renderListener;
    private final Map<PdfName, XObjectDoHandler> xobjectDoHandlers;
    private final Map<Integer, CMapAwareDocumentFont> cachedFonts = new HashMap<Integer, CMapAwareDocumentFont>();
    private final Stack<MarkedContentInfo> markedContentStack = new Stack();

    public PdfContentStreamProcessor(RenderListener renderListener) {
        this.renderListener = renderListener;
        this.operators = new HashMap<String, ContentOperator>();
        this.populateOperators();
        this.xobjectDoHandlers = new HashMap<PdfName, XObjectDoHandler>();
        this.populateXObjectDoHandlers();
        this.reset();
    }

    private void populateXObjectDoHandlers() {
        this.registerXObjectDoHandler(PdfName.DEFAULT, new IgnoreXObjectDoHandler());
        this.registerXObjectDoHandler(PdfName.FORM, new FormXObjectDoHandler());
        this.registerXObjectDoHandler(PdfName.IMAGE, new ImageXObjectDoHandler());
    }

    public XObjectDoHandler registerXObjectDoHandler(PdfName xobjectSubType, XObjectDoHandler handler) {
        return this.xobjectDoHandlers.put(xobjectSubType, handler);
    }

    private CMapAwareDocumentFont getFont(PRIndirectReference ind) {
        Integer n2 = ind.getNumber();
        CMapAwareDocumentFont font = this.cachedFonts.get(n2);
        if (font == null) {
            font = new CMapAwareDocumentFont(ind);
            this.cachedFonts.put(n2, font);
        }
        return font;
    }

    private CMapAwareDocumentFont getFont(PdfDictionary fontResource) {
        return new CMapAwareDocumentFont(fontResource);
    }

    private void populateOperators() {
        this.registerContentOperator(DEFAULTOPERATOR, new IgnoreOperatorContentOperator());
        this.registerContentOperator("q", new PushGraphicsState());
        this.registerContentOperator("Q", new PopGraphicsState());
        this.registerContentOperator("cm", new ModifyCurrentTransformationMatrix());
        this.registerContentOperator("gs", new ProcessGraphicsStateResource());
        SetTextCharacterSpacing tcOperator = new SetTextCharacterSpacing();
        this.registerContentOperator("Tc", tcOperator);
        SetTextWordSpacing twOperator = new SetTextWordSpacing();
        this.registerContentOperator("Tw", twOperator);
        this.registerContentOperator("Tz", new SetTextHorizontalScaling());
        SetTextLeading tlOperator = new SetTextLeading();
        this.registerContentOperator("TL", tlOperator);
        this.registerContentOperator("Tf", new SetTextFont());
        this.registerContentOperator("Tr", new SetTextRenderMode());
        this.registerContentOperator("Ts", new SetTextRise());
        this.registerContentOperator("BT", new BeginText());
        this.registerContentOperator("ET", new EndText());
        this.registerContentOperator("BMC", new BeginMarkedContent());
        this.registerContentOperator("BDC", new BeginMarkedContentDictionary());
        this.registerContentOperator("EMC", new EndMarkedContent());
        TextMoveStartNextLine tdOperator = new TextMoveStartNextLine();
        this.registerContentOperator("Td", tdOperator);
        this.registerContentOperator("TD", new TextMoveStartNextLineWithLeading(tdOperator, tlOperator));
        this.registerContentOperator("Tm", new TextSetTextMatrix());
        TextMoveNextLine tstarOperator = new TextMoveNextLine(tdOperator);
        this.registerContentOperator("T*", tstarOperator);
        ShowText tjOperator = new ShowText();
        this.registerContentOperator("Tj", new ShowText());
        MoveNextLineAndShowText tickOperator = new MoveNextLineAndShowText(tstarOperator, tjOperator);
        this.registerContentOperator("'", tickOperator);
        this.registerContentOperator("\"", new MoveNextLineAndShowTextWithSpacing(twOperator, tcOperator, tickOperator));
        this.registerContentOperator("TJ", new ShowTextArray());
        this.registerContentOperator("Do", new Do());
    }

    public ContentOperator registerContentOperator(String operatorString, ContentOperator operator) {
        return this.operators.put(operatorString, operator);
    }

    public void reset() {
        this.gsStack.removeAllElements();
        this.gsStack.add(new GraphicsState());
        this.textMatrix = null;
        this.textLineMatrix = null;
        this.resources = new ResourceDictionary();
    }

    private GraphicsState gs() {
        return this.gsStack.peek();
    }

    private void invokeOperator(PdfLiteral operator, ArrayList<PdfObject> operands) throws Exception {
        ContentOperator op = this.operators.get(operator.toString());
        if (op == null) {
            op = this.operators.get(DEFAULTOPERATOR);
        }
        op.invoke(this, operator, operands);
    }

    private void beginMarkedContent(PdfName tag, PdfDictionary dict) {
        this.markedContentStack.push(new MarkedContentInfo(tag, dict));
    }

    private void endMarkedContent() {
        this.markedContentStack.pop();
    }

    private String decode(PdfString in) {
        byte[] bytes = in.getBytes();
        return this.gs().font.decode(bytes, 0, bytes.length);
    }

    private void beginText() {
        this.renderListener.beginTextBlock();
    }

    private void endText() {
        this.renderListener.endTextBlock();
    }

    private void displayPdfString(PdfString string) {
        String unicode = this.decode(string);
        TextRenderInfo renderInfo = new TextRenderInfo(unicode, this.gs(), this.textMatrix, this.markedContentStack);
        this.renderListener.renderText(renderInfo);
        this.textMatrix = new Matrix(renderInfo.getUnscaledWidth(), 0.0f).multiply(this.textMatrix);
    }

    private void displayXObject(PdfName xobjectName) throws IOException {
        XObjectDoHandler handler;
        PdfDictionary xobjects = this.resources.getAsDict(PdfName.XOBJECT);
        PdfObject xobject = xobjects.getDirectObject(xobjectName);
        PdfStream xobjectStream = (PdfStream)xobject;
        PdfName subType = xobjectStream.getAsName(PdfName.SUBTYPE);
        if (xobject.isStream()) {
            handler = this.xobjectDoHandlers.get(subType);
            if (handler == null) {
                handler = this.xobjectDoHandlers.get(PdfName.DEFAULT);
            }
        } else {
            throw new IllegalStateException(MessageLocalization.getComposedMessage("XObject.1.is.not.a.stream", xobjectName));
        }
        handler.handleXObject(this, xobjectStream, xobjects.getAsIndirectObject(xobjectName));
    }

    private void applyTextAdjust(float tj) {
        float adjustBy = -tj / 1000.0f * this.gs().fontSize * this.gs().horizontalScaling;
        this.textMatrix = new Matrix(adjustBy, 0.0f).multiply(this.textMatrix);
    }

    public void processContent(byte[] contentBytes, PdfDictionary resources) {
        this.resources.push(resources);
        try {
            PRTokeniser tokeniser = new PRTokeniser(new RandomAccessFileOrArray(new RandomAccessSourceFactory().createSource(contentBytes)));
            PdfContentParser ps = new PdfContentParser(tokeniser);
            ArrayList<PdfObject> operands = new ArrayList<PdfObject>();
            while (ps.parse(operands).size() > 0) {
                PdfLiteral operator = (PdfLiteral)operands.get(operands.size() - 1);
                if ("BI".equals(operator.toString())) {
                    PdfDictionary colorSpaceDic = resources != null ? resources.getAsDict(PdfName.COLORSPACE) : null;
                    ImageRenderInfo renderInfo = ImageRenderInfo.createForEmbeddedImage(this.gs().ctm, InlineImageUtils.parseInlineImage(ps, colorSpaceDic), colorSpaceDic);
                    this.renderListener.renderImage(renderInfo);
                    continue;
                }
                this.invokeOperator(operator, operands);
            }
        }
        catch (Exception e2) {
            throw new ExceptionConverter(e2);
        }
        this.resources.pop();
    }

    private static class IgnoreXObjectDoHandler
    implements XObjectDoHandler {
        private IgnoreXObjectDoHandler() {
        }

        public void handleXObject(PdfContentStreamProcessor processor, PdfStream xobjectStream, PdfIndirectReference ref) {
        }
    }

    private static class ImageXObjectDoHandler
    implements XObjectDoHandler {
        private ImageXObjectDoHandler() {
        }

        public void handleXObject(PdfContentStreamProcessor processor, PdfStream xobjectStream, PdfIndirectReference ref) {
            PdfDictionary colorSpaceDic = processor.resources.getAsDict(PdfName.COLORSPACE);
            ImageRenderInfo renderInfo = ImageRenderInfo.createForXObject(((PdfContentStreamProcessor)processor).gs().ctm, ref, colorSpaceDic);
            processor.renderListener.renderImage(renderInfo);
        }
    }

    private static class FormXObjectDoHandler
    implements XObjectDoHandler {
        private FormXObjectDoHandler() {
        }

        public void handleXObject(PdfContentStreamProcessor processor, PdfStream stream, PdfIndirectReference ref) {
            byte[] contentBytes;
            PdfDictionary resources = stream.getAsDict(PdfName.RESOURCES);
            try {
                contentBytes = ContentByteUtils.getContentBytesFromContentObject(stream);
            }
            catch (IOException e1) {
                throw new ExceptionConverter(e1);
            }
            PdfArray matrix = stream.getAsArray(PdfName.MATRIX);
            new PushGraphicsState().invoke(processor, null, null);
            if (matrix != null) {
                float a2 = matrix.getAsNumber(0).floatValue();
                float b2 = matrix.getAsNumber(1).floatValue();
                float c2 = matrix.getAsNumber(2).floatValue();
                float d2 = matrix.getAsNumber(3).floatValue();
                float e2 = matrix.getAsNumber(4).floatValue();
                float f2 = matrix.getAsNumber(5).floatValue();
                Matrix formMatrix = new Matrix(a2, b2, c2, d2, e2, f2);
                ((PdfContentStreamProcessor)processor).gs().ctm = formMatrix.multiply(((PdfContentStreamProcessor)processor).gs().ctm);
            }
            processor.processContent(contentBytes, resources);
            new PopGraphicsState().invoke(processor, null, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Do
    implements ContentOperator {
        private Do() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) throws IOException {
            PdfName xobjectName = (PdfName)operands.get(0);
            processor.displayXObject(xobjectName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EndMarkedContent
    implements ContentOperator {
        private EndMarkedContent() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) throws Exception {
            processor.endMarkedContent();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeginMarkedContentDictionary
    implements ContentOperator {
        private BeginMarkedContentDictionary() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) throws Exception {
            PdfObject properties = operands.get(1);
            processor.beginMarkedContent((PdfName)operands.get(0), this.getPropertiesDictionary(properties, processor.resources));
        }

        private PdfDictionary getPropertiesDictionary(PdfObject operand1, ResourceDictionary resources) {
            if (operand1.isDictionary()) {
                return (PdfDictionary)operand1;
            }
            PdfName dictionaryName = (PdfName)operand1;
            return resources.getAsDict(dictionaryName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeginMarkedContent
    implements ContentOperator {
        private BeginMarkedContent() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) throws Exception {
            processor.beginMarkedContent((PdfName)operands.get(0), new PdfDictionary());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EndText
    implements ContentOperator {
        private EndText() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            processor.textMatrix = null;
            processor.textLineMatrix = null;
            processor.endText();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BeginText
    implements ContentOperator {
        private BeginText() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            processor.textMatrix = new Matrix();
            processor.textLineMatrix = processor.textMatrix;
            processor.beginText();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PopGraphicsState
    implements ContentOperator {
        private PopGraphicsState() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            processor.gsStack.pop();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModifyCurrentTransformationMatrix
    implements ContentOperator {
        private ModifyCurrentTransformationMatrix() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            float a2 = ((PdfNumber)operands.get(0)).floatValue();
            float b2 = ((PdfNumber)operands.get(1)).floatValue();
            float c2 = ((PdfNumber)operands.get(2)).floatValue();
            float d2 = ((PdfNumber)operands.get(3)).floatValue();
            float e2 = ((PdfNumber)operands.get(4)).floatValue();
            float f2 = ((PdfNumber)operands.get(5)).floatValue();
            Matrix matrix = new Matrix(a2, b2, c2, d2, e2, f2);
            GraphicsState gs = (GraphicsState)processor.gsStack.peek();
            gs.ctm = matrix.multiply(gs.ctm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PushGraphicsState
    implements ContentOperator {
        private PushGraphicsState() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            GraphicsState gs = (GraphicsState)processor.gsStack.peek();
            GraphicsState copy = new GraphicsState(gs);
            processor.gsStack.push(copy);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProcessGraphicsStateResource
    implements ContentOperator {
        private ProcessGraphicsStateResource() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            PdfName dictionaryName = (PdfName)operands.get(0);
            PdfDictionary extGState = processor.resources.getAsDict(PdfName.EXTGSTATE);
            if (extGState == null) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("resources.do.not.contain.extgstate.entry.unable.to.process.operator.1", operator));
            }
            PdfDictionary gsDic = extGState.getAsDict(dictionaryName);
            if (gsDic == null) {
                throw new IllegalArgumentException(MessageLocalization.getComposedMessage("1.is.an.unknown.graphics.state.dictionary", dictionaryName));
            }
            PdfArray fontParameter = gsDic.getAsArray(PdfName.FONT);
            if (fontParameter != null) {
                CMapAwareDocumentFont font = processor.getFont((PRIndirectReference)fontParameter.getPdfObject(0));
                float size = fontParameter.getAsNumber(1).floatValue();
                ((PdfContentStreamProcessor)processor).gs().font = font;
                ((PdfContentStreamProcessor)processor).gs().fontSize = size;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetTextWordSpacing
    implements ContentOperator {
        private SetTextWordSpacing() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            PdfNumber wordSpace = (PdfNumber)operands.get(0);
            ((PdfContentStreamProcessor)processor).gs().wordSpacing = wordSpace.floatValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetTextCharacterSpacing
    implements ContentOperator {
        private SetTextCharacterSpacing() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            PdfNumber charSpace = (PdfNumber)operands.get(0);
            ((PdfContentStreamProcessor)processor).gs().characterSpacing = charSpace.floatValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetTextHorizontalScaling
    implements ContentOperator {
        private SetTextHorizontalScaling() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            PdfNumber scale = (PdfNumber)operands.get(0);
            ((PdfContentStreamProcessor)processor).gs().horizontalScaling = scale.floatValue() / 100.0f;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetTextLeading
    implements ContentOperator {
        private SetTextLeading() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            PdfNumber leading = (PdfNumber)operands.get(0);
            ((PdfContentStreamProcessor)processor).gs().leading = leading.floatValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetTextRise
    implements ContentOperator {
        private SetTextRise() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            PdfNumber rise = (PdfNumber)operands.get(0);
            ((PdfContentStreamProcessor)processor).gs().rise = rise.floatValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetTextRenderMode
    implements ContentOperator {
        private SetTextRenderMode() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            PdfNumber render = (PdfNumber)operands.get(0);
            ((PdfContentStreamProcessor)processor).gs().renderMode = render.intValue();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SetTextFont
    implements ContentOperator {
        private SetTextFont() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            PdfName fontResourceName = (PdfName)operands.get(0);
            float size = ((PdfNumber)operands.get(1)).floatValue();
            PdfDictionary fontsDictionary = processor.resources.getAsDict(PdfName.FONT);
            PdfObject fontObject = fontsDictionary.get(fontResourceName);
            CMapAwareDocumentFont font = fontObject instanceof PdfDictionary ? processor.getFont((PdfDictionary)fontObject) : processor.getFont((PRIndirectReference)fontObject);
            ((PdfContentStreamProcessor)processor).gs().font = font;
            ((PdfContentStreamProcessor)processor).gs().fontSize = size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TextMoveStartNextLine
    implements ContentOperator {
        private TextMoveStartNextLine() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            float tx = ((PdfNumber)operands.get(0)).floatValue();
            float ty = ((PdfNumber)operands.get(1)).floatValue();
            Matrix translationMatrix = new Matrix(tx, ty);
            processor.textMatrix = translationMatrix.multiply(processor.textLineMatrix);
            processor.textLineMatrix = processor.textMatrix;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TextMoveStartNextLineWithLeading
    implements ContentOperator {
        private final TextMoveStartNextLine moveStartNextLine;
        private final SetTextLeading setTextLeading;

        public TextMoveStartNextLineWithLeading(TextMoveStartNextLine moveStartNextLine, SetTextLeading setTextLeading) {
            this.moveStartNextLine = moveStartNextLine;
            this.setTextLeading = setTextLeading;
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            float ty = ((PdfNumber)operands.get(1)).floatValue();
            ArrayList<PdfObject> tlOperands = new ArrayList<PdfObject>(1);
            tlOperands.add(0, new PdfNumber(-ty));
            this.setTextLeading.invoke(processor, null, tlOperands);
            this.moveStartNextLine.invoke(processor, null, operands);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TextSetTextMatrix
    implements ContentOperator {
        private TextSetTextMatrix() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            float a2 = ((PdfNumber)operands.get(0)).floatValue();
            float b2 = ((PdfNumber)operands.get(1)).floatValue();
            float c2 = ((PdfNumber)operands.get(2)).floatValue();
            float d2 = ((PdfNumber)operands.get(3)).floatValue();
            float e2 = ((PdfNumber)operands.get(4)).floatValue();
            float f2 = ((PdfNumber)operands.get(5)).floatValue();
            processor.textLineMatrix = new Matrix(a2, b2, c2, d2, e2, f2);
            processor.textMatrix = processor.textLineMatrix;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TextMoveNextLine
    implements ContentOperator {
        private final TextMoveStartNextLine moveStartNextLine;

        public TextMoveNextLine(TextMoveStartNextLine moveStartNextLine) {
            this.moveStartNextLine = moveStartNextLine;
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            ArrayList<PdfObject> tdoperands = new ArrayList<PdfObject>(2);
            tdoperands.add(0, new PdfNumber(0));
            tdoperands.add(1, new PdfNumber(-((PdfContentStreamProcessor)processor).gs().leading));
            this.moveStartNextLine.invoke(processor, null, tdoperands);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShowText
    implements ContentOperator {
        private ShowText() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            PdfString string = (PdfString)operands.get(0);
            processor.displayPdfString(string);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MoveNextLineAndShowText
    implements ContentOperator {
        private final TextMoveNextLine textMoveNextLine;
        private final ShowText showText;

        public MoveNextLineAndShowText(TextMoveNextLine textMoveNextLine, ShowText showText) {
            this.textMoveNextLine = textMoveNextLine;
            this.showText = showText;
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            this.textMoveNextLine.invoke(processor, null, new ArrayList<PdfObject>(0));
            this.showText.invoke(processor, null, operands);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MoveNextLineAndShowTextWithSpacing
    implements ContentOperator {
        private final SetTextWordSpacing setTextWordSpacing;
        private final SetTextCharacterSpacing setTextCharacterSpacing;
        private final MoveNextLineAndShowText moveNextLineAndShowText;

        public MoveNextLineAndShowTextWithSpacing(SetTextWordSpacing setTextWordSpacing, SetTextCharacterSpacing setTextCharacterSpacing, MoveNextLineAndShowText moveNextLineAndShowText) {
            this.setTextWordSpacing = setTextWordSpacing;
            this.setTextCharacterSpacing = setTextCharacterSpacing;
            this.moveNextLineAndShowText = moveNextLineAndShowText;
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            PdfNumber aw = (PdfNumber)operands.get(0);
            PdfNumber ac = (PdfNumber)operands.get(1);
            PdfString string = (PdfString)operands.get(2);
            ArrayList<PdfObject> twOperands = new ArrayList<PdfObject>(1);
            twOperands.add(0, aw);
            this.setTextWordSpacing.invoke(processor, null, twOperands);
            ArrayList<PdfObject> tcOperands = new ArrayList<PdfObject>(1);
            tcOperands.add(0, ac);
            this.setTextCharacterSpacing.invoke(processor, null, tcOperands);
            ArrayList<PdfObject> tickOperands = new ArrayList<PdfObject>(1);
            tickOperands.add(0, string);
            this.moveNextLineAndShowText.invoke(processor, null, tickOperands);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShowTextArray
    implements ContentOperator {
        private ShowTextArray() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
            PdfArray array = (PdfArray)operands.get(0);
            float tj = 0.0f;
            ListIterator<PdfObject> i2 = array.listIterator();
            while (i2.hasNext()) {
                PdfObject entryObj = (PdfObject)i2.next();
                if (entryObj instanceof PdfString) {
                    processor.displayPdfString((PdfString)entryObj);
                    tj = 0.0f;
                    continue;
                }
                tj = ((PdfNumber)entryObj).floatValue();
                processor.applyTextAdjust(tj);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IgnoreOperatorContentOperator
    implements ContentOperator {
        private IgnoreOperatorContentOperator() {
        }

        @Override
        public void invoke(PdfContentStreamProcessor processor, PdfLiteral operator, ArrayList<PdfObject> operands) {
        }
    }

    private static class ResourceDictionary
    extends PdfDictionary {
        private final List<PdfDictionary> resourcesStack = new ArrayList<PdfDictionary>();

        public void push(PdfDictionary resources) {
            this.resourcesStack.add(resources);
        }

        public void pop() {
            this.resourcesStack.remove(this.resourcesStack.size() - 1);
        }

        public PdfObject getDirectObject(PdfName key) {
            for (int i2 = this.resourcesStack.size() - 1; i2 >= 0; --i2) {
                PdfObject obj;
                PdfDictionary subResource = this.resourcesStack.get(i2);
                if (subResource == null || (obj = subResource.getDirectObject(key)) == null) continue;
                return obj;
            }
            return super.getDirectObject(key);
        }
    }
}

