/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.WholeImageFilter;
import java.awt.Rectangle;

public class MedianFilter
extends WholeImageFilter {
    private int median(int[] array) {
        int max;
        int i2;
        for (i2 = 0; i2 < 4; ++i2) {
            max = 0;
            int maxIndex = 0;
            for (int j2 = 0; j2 < 9; ++j2) {
                if (array[j2] <= max) continue;
                max = array[j2];
                maxIndex = j2;
            }
            array[maxIndex] = 0;
        }
        max = 0;
        for (i2 = 0; i2 < 9; ++i2) {
            if (array[i2] <= max) continue;
            max = array[i2];
        }
        return max;
    }

    private int rgbMedian(int[] r, int[] g2, int[] b2) {
        int index = 0;
        int min = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < 9; ++i2) {
            int sum = 0;
            for (int j2 = 0; j2 < 9; ++j2) {
                sum += Math.abs(r[i2] - r[j2]);
                sum += Math.abs(g2[i2] - g2[j2]);
                sum += Math.abs(b2[i2] - b2[j2]);
            }
            if (sum >= min) continue;
            min = sum;
            index = i2;
        }
        return index;
    }

    protected int[] filterPixels(int width, int height, int[] inPixels, Rectangle transformedSpace) {
        int index = 0;
        int[] argb = new int[9];
        int[] r = new int[9];
        int[] g2 = new int[9];
        int[] b2 = new int[9];
        int[] outPixels = new int[width * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int k2 = 0;
                for (int dy = -1; dy <= 1; ++dy) {
                    int iy = y + dy;
                    if (0 > iy || iy >= height) continue;
                    int ioffset = iy * width;
                    for (int dx = -1; dx <= 1; ++dx) {
                        int rgb;
                        int ix = x + dx;
                        if (0 > ix || ix >= width) continue;
                        argb[k2] = rgb = inPixels[ioffset + ix];
                        r[k2] = rgb >> 16 & 0xFF;
                        g2[k2] = rgb >> 8 & 0xFF;
                        b2[k2] = rgb & 0xFF;
                        ++k2;
                    }
                }
                while (k2 < 9) {
                    argb[k2] = -16777216;
                    b2[k2] = 0;
                    g2[k2] = 0;
                    r[k2] = 0;
                    ++k2;
                }
                outPixels[index++] = argb[this.rgbMedian(r, g2, b2)];
            }
        }
        return outPixels;
    }

    public String toString() {
        return "Blur/Median";
    }
}

