/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.plaf.metal.MetalFileChooserUI;

public class BaseFileChooserUI
extends MetalFileChooserUI {
    private FileView fileView = new BaseFileView();
    private static final int PREF_WIDTH = 580;
    private static final int PREF_HEIGHT = 340;
    private static final Dimension PREF_SIZE = new Dimension(580, 340);
    private AncestorListener ancestorListener = null;

    public BaseFileChooserUI(JFileChooser fileChooser) {
        super(fileChooser);
    }

    public static ComponentUI createUI(JComponent c2) {
        return new BaseFileChooserUI((JFileChooser)c2);
    }

    protected void installListeners(JFileChooser fc) {
        super.installListeners(fc);
        this.ancestorListener = new AncestorListener(){

            public void ancestorAdded(AncestorEvent event) {
                Window w = SwingUtilities.getWindowAncestor(BaseFileChooserUI.this.getFileChooser());
                if (w != null) {
                    w.setMinimumSize(BaseFileChooserUI.this.getPreferredSize(BaseFileChooserUI.this.getFileChooser()));
                }
            }

            public void ancestorRemoved(AncestorEvent event) {
            }

            public void ancestorMoved(AncestorEvent event) {
            }
        };
        fc.addAncestorListener(this.ancestorListener);
    }

    protected void uninstallListeners(JFileChooser fc) {
        super.uninstallListeners(fc);
        fc.removeAncestorListener(this.ancestorListener);
    }

    public Dimension getPreferredSize(JComponent c2) {
        int prefWidth = BaseFileChooserUI.PREF_SIZE.width;
        Dimension d2 = c2.getLayout().preferredLayoutSize(c2);
        if (d2 != null) {
            return new Dimension(d2.width < prefWidth ? prefWidth : d2.width, d2.height < BaseFileChooserUI.PREF_SIZE.height ? BaseFileChooserUI.PREF_SIZE.height : d2.height);
        }
        return new Dimension(prefWidth, BaseFileChooserUI.PREF_SIZE.height);
    }

    public FileView getFileView(JFileChooser fc) {
        if (JTattooUtilities.getJavaVersion() < 1.4) {
            return super.getFileView(fc);
        }
        return this.fileView;
    }

    protected class BaseFileView
    extends BasicFileChooserUI.BasicFileView {
        protected BaseFileView() {
            super(BaseFileChooserUI.this);
        }

        public Icon getIcon(File f2) {
            Icon icon = this.getCachedIcon(f2);
            if (icon != null) {
                return icon;
            }
            if (f2 != null) {
                icon = BaseFileChooserUI.this.getFileChooser().getFileSystemView().getSystemIcon(f2);
            }
            if (icon == null) {
                icon = super.getIcon(f2);
            }
            this.cacheIcon(f2, icon);
            return icon;
        }
    }
}

