/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.lang.reflect.Field;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPanelUI;

public class BasePanelUI
extends BasicPanelUI {
    private static BasePanelUI panelUI = null;

    public static ComponentUI createUI(JComponent c2) {
        if (panelUI == null) {
            panelUI = new BasePanelUI();
        }
        return panelUI;
    }

    protected void installDefaults(JPanel p) {
        super.installDefaults(p);
        p.setFont(AbstractLookAndFeel.getTheme().getControlTextFont());
        try {
            Field field;
            if (JTattooUtilities.getJavaVersion() < 1.7) {
                Class<?> clazz = Class.forName("javax.swing.PopupFactory");
                field = clazz.getDeclaredField("forceHeavyWeightPopupKey");
            } else {
                Class<?> clazz = Class.forName("javax.swing.ClientPropertyKey");
                field = clazz.getDeclaredField("PopupFactory_FORCE_HEAVYWEIGHT_POPUP");
            }
            field.setAccessible(true);
            p.putClientProperty(field.get(null), Boolean.TRUE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void update(Graphics g2, JComponent c2) {
        if (c2.isOpaque()) {
            Object backgroundTexture = c2.getClientProperty("backgroundTexture");
            if (backgroundTexture instanceof Icon) {
                JTattooUtilities.fillComponent(g2, c2, (Icon)backgroundTexture);
            } else {
                g2.setColor(c2.getBackground());
                g2.fillRect(0, 0, c2.getWidth(), c2.getHeight());
            }
        }
    }

    public void paint(Graphics g2, JComponent c2) {
        Graphics2D g2D = (Graphics2D)g2;
        Object savedRenderingHint = null;
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
        }
        super.paint(g2, c2);
        if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
            g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedRenderingHint);
        }
    }
}

