/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseRootPaneUI;
import com.jtattoo.plaf.BaseTitleButton;
import com.jtattoo.plaf.DecorationHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.TitlePane;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class BaseTitlePane
extends JComponent
implements TitlePane {
    public static final String PAINT_ACTIVE = "paintActive";
    public static final String ICONIFY = "Iconify";
    public static final String MAXIMIZE = "Maximize";
    public static final String CLOSE = "Close";
    protected PropertyChangeListener propertyChangeListener;
    protected Action closeAction;
    protected Action iconifyAction;
    protected Action restoreAction;
    protected Action maximizeAction;
    protected JMenuBar menuBar;
    protected JPanel customTitlePanel;
    protected JButton iconifyButton;
    protected JButton maxButton;
    protected JButton closeButton;
    protected Icon iconifyIcon;
    protected Icon maximizeIcon;
    protected Icon minimizeIcon;
    protected Icon closeIcon;
    protected WindowListener windowListener;
    protected Window window;
    protected JRootPane rootPane;
    protected BaseRootPaneUI rootPaneUI;
    protected int buttonsWidth;
    protected int state;
    protected boolean wasMaximized;
    protected boolean wasMaximizeError = false;
    protected BufferedImage backgroundImage = null;
    protected float alphaValue = 0.85f;

    public BaseTitlePane(JRootPane root, BaseRootPaneUI ui) {
        this.rootPane = root;
        this.rootPaneUI = ui;
        this.state = -1;
        this.wasMaximized = false;
        this.iconifyIcon = UIManager.getIcon("InternalFrame.iconifyIcon");
        this.maximizeIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
        this.minimizeIcon = UIManager.getIcon("InternalFrame.minimizeIcon");
        this.closeIcon = UIManager.getIcon("InternalFrame.closeIcon");
        this.installSubcomponents();
        this.installDefaults();
        this.setLayout(this.createLayout());
    }

    protected void installListeners() {
        if (this.window != null) {
            this.windowListener = this.createWindowListener();
            this.window.addWindowListener(this.windowListener);
            this.propertyChangeListener = this.createWindowPropertyChangeListener();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.window.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    protected WindowListener createWindowListener() {
        return new WindowHandler();
    }

    protected PropertyChangeListener createWindowPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    protected Frame getFrame() {
        if (this.window instanceof Frame) {
            return (Frame)this.window;
        }
        return null;
    }

    protected Window getWindow() {
        return this.window;
    }

    protected int getWindowDecorationStyle() {
        return DecorationHelper.getWindowDecorationStyle(this.rootPane);
    }

    protected boolean isMacStyleWindowDecoration() {
        return AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn();
    }

    protected Image getFrameIconImage() {
        if (this.getFrame() == null && JTattooUtilities.getJavaVersion() >= 1.6) {
            List<Image> icons = this.getWindow().getIconImages();
            if (icons == null || icons.isEmpty()) {
                for (Window owner = this.getWindow().getOwner(); owner != null; owner = owner.getOwner()) {
                    icons = owner.getIconImages();
                    if (icons == null || icons.isEmpty()) continue;
                    return icons.get(0);
                }
            } else {
                return icons.get(0);
            }
            if ((icons == null || icons.isEmpty()) && Frame.getFrames() != null && Frame.getFrames().length > 0) {
                return Frame.getFrames()[0].getIconImage();
            }
            return null;
        }
        if (this.getFrame() != null) {
            return this.getFrame().getIconImage();
        }
        return null;
    }

    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            if (this.window instanceof Frame) {
                this.setState(DecorationHelper.getExtendedState((Frame)this.window));
            } else {
                this.setState(0);
            }
            this.setActive(JTattooUtilities.isWindowActive(this.window));
            this.installListeners();
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
        this.window = null;
    }

    protected void installSubcomponents() {
        this.createActions();
        this.createButtons();
        if (this.getWindowDecorationStyle() == 1) {
            if (!this.isMacStyleWindowDecoration()) {
                this.createMenuBar();
                this.add(this.menuBar);
            }
            this.add(this.iconifyButton);
            this.add(this.maxButton);
        }
        this.add(this.closeButton);
    }

    protected void installDefaults() {
        this.setFont(UIManager.getFont("InternalFrame.titleFont"));
        if (this.rootPane.getClientProperty("customTitlePanel") instanceof JPanel) {
            this.setCustomizedTitlePanel((JPanel)this.rootPane.getClientProperty("customTitlePanel"));
        }
    }

    protected void uninstallDefaults() {
    }

    protected void createMenuBar() {
        this.menuBar = new SystemMenuBar();
        if (this.getWindowDecorationStyle() == 1) {
            JMenu menu = new JMenu("   ");
            JMenuItem mi = menu.add(this.restoreAction);
            int mnemonic = BaseTitlePane.getInt("MetalTitlePane.restoreMnemonic", -1);
            if (mnemonic != -1) {
                mi.setMnemonic(mnemonic);
            }
            mi = menu.add(this.iconifyAction);
            mnemonic = BaseTitlePane.getInt("MetalTitlePane.iconifyMnemonic", -1);
            if (mnemonic != -1) {
                mi.setMnemonic(mnemonic);
            }
            if (DecorationHelper.isFrameStateSupported(Toolkit.getDefaultToolkit(), 6)) {
                mi = menu.add(this.maximizeAction);
                mnemonic = BaseTitlePane.getInt("MetalTitlePane.maximizeMnemonic", -1);
                if (mnemonic != -1) {
                    mi.setMnemonic(mnemonic);
                }
            }
            menu.addSeparator();
            mi = menu.add(this.closeAction);
            mnemonic = BaseTitlePane.getInt("MetalTitlePane.closeMnemonic", -1);
            if (mnemonic != -1) {
                mi.setMnemonic(mnemonic);
            }
            this.menuBar.add(menu);
        }
    }

    public void setCustomizedTitlePanel(JPanel panel) {
        if (this.customTitlePanel != null) {
            this.remove(this.customTitlePanel);
            this.customTitlePanel = null;
        }
        if (panel != null) {
            this.customTitlePanel = panel;
            this.add(this.customTitlePanel);
        }
        this.rootPane.putClientProperty("customTitlePanel", this.customTitlePanel);
        this.revalidate();
        this.repaint();
    }

    public void createButtons() {
        this.iconifyButton = new BaseTitleButton(this.iconifyAction, ICONIFY, this.iconifyIcon, 1.0f);
        this.maxButton = new BaseTitleButton(this.restoreAction, MAXIMIZE, this.maximizeIcon, 1.0f);
        this.closeButton = new BaseTitleButton(this.closeAction, CLOSE, this.closeIcon, 1.0f);
    }

    public LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    public void iconify() {
        Frame frame = this.getFrame();
        if (frame != null) {
            if (JTattooUtilities.isMac() && JTattooUtilities.getJavaVersion() >= 1.7) {
                DecorationHelper.setExtendedState(frame, this.state & 0xFFFFFFF9 | 1);
            } else {
                DecorationHelper.setExtendedState(frame, this.state | 1);
            }
        }
    }

    public void maximize() {
        Frame frame = this.getFrame();
        if (frame != null) {
            int i2;
            this.validateMaximizedBounds();
            PropertyChangeListener[] pcl = frame.getPropertyChangeListeners();
            for (i2 = 0; i2 < pcl.length; ++i2) {
                pcl[i2].propertyChange(new PropertyChangeEvent(this, "windowMaximize", Boolean.FALSE, Boolean.FALSE));
            }
            DecorationHelper.setExtendedState(frame, this.state | 6);
            for (i2 = 0; i2 < pcl.length; ++i2) {
                pcl[i2].propertyChange(new PropertyChangeEvent(this, "windowMaximized", Boolean.FALSE, Boolean.FALSE));
            }
        }
    }

    public void restore() {
        Frame frame = this.getFrame();
        if (frame != null) {
            int i2;
            this.wasMaximizeError = false;
            PropertyChangeListener[] pcl = frame.getPropertyChangeListeners();
            for (i2 = 0; i2 < pcl.length; ++i2) {
                pcl[i2].propertyChange(new PropertyChangeEvent(this, "windowRestore", Boolean.FALSE, Boolean.FALSE));
            }
            if ((this.state & 1) != 0) {
                DecorationHelper.setExtendedState(frame, this.state & 0xFFFFFFFE);
            } else {
                DecorationHelper.setExtendedState(frame, this.state & 0xFFFFFFF9);
            }
            for (i2 = 0; i2 < pcl.length; ++i2) {
                pcl[i2].propertyChange(new PropertyChangeEvent(this, "windowRestored", Boolean.FALSE, Boolean.FALSE));
            }
        }
    }

    public void close() {
        if (this.window != null) {
            this.window.dispatchEvent(new WindowEvent(this.window, 201));
        }
    }

    protected void validateMaximizedBounds() {
        Frame frame = this.getFrame();
        if (frame != null && !this.wasMaximizeError) {
            GraphicsConfiguration gc = frame.getGraphicsConfiguration();
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
            Rectangle maxBounds = gc.getBounds();
            maxBounds.x = Math.max(0, screenInsets.left);
            maxBounds.y = Math.max(0, screenInsets.top);
            maxBounds.width -= screenInsets.left + screenInsets.right;
            maxBounds.height -= screenInsets.top + screenInsets.bottom;
            frame.setMaximizedBounds(maxBounds);
        }
    }

    protected void createActions() {
        this.closeAction = new CloseAction();
        this.iconifyAction = new IconifyAction();
        this.restoreAction = new RestoreAction();
        this.maximizeAction = new MaximizeAction();
    }

    static int getInt(Object key, int defaultValue) {
        Object value = UIManager.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    protected void setActive(boolean flag) {
        if (this.getWindowDecorationStyle() == 1) {
            Boolean active = flag ? Boolean.TRUE : Boolean.FALSE;
            this.iconifyButton.putClientProperty(PAINT_ACTIVE, active);
            this.closeButton.putClientProperty(PAINT_ACTIVE, active);
            this.maxButton.putClientProperty(PAINT_ACTIVE, active);
        }
        this.getRootPane().repaint();
    }

    protected boolean isActive() {
        return this.window == null ? true : JTattooUtilities.isWindowActive(this.window);
    }

    protected boolean isLeftToRight() {
        return this.window == null ? this.getRootPane().getComponentOrientation().isLeftToRight() : this.window.getComponentOrientation().isLeftToRight();
    }

    public void setBackgroundImage(BufferedImage bgImage) {
        this.backgroundImage = bgImage;
    }

    public void setAlphaTransparency(float alpha) {
        this.alphaValue = alpha;
    }

    protected void setState(int state) {
        this.setState(state, false);
    }

    protected void setState(int state, boolean updateRegardless) {
        if (this.window != null && this.getWindowDecorationStyle() == 1) {
            if (this.state == state && !updateRegardless) {
                return;
            }
            final Frame frame = this.getFrame();
            if (frame != null) {
                if ((state & 6) != 0 && (this.rootPane.getBorder() == null || this.rootPane.getBorder() instanceof UIResource) && frame.isShowing()) {
                    this.rootPane.setBorder(null);
                } else if ((state & 6) == 0) {
                    this.rootPaneUI.installBorder(this.rootPane);
                }
                if (frame.isResizable()) {
                    if ((state & 6) != 0) {
                        this.updateMaxButton(this.restoreAction, this.minimizeIcon);
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        this.updateMaxButton(this.maximizeAction, this.maximizeIcon);
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                    if (this.maxButton.getParent() == null || this.iconifyButton.getParent() == null) {
                        this.add(this.maxButton);
                        this.add(this.iconifyButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.maxButton.setText(null);
                } else {
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                    if (this.maxButton.getParent() != null) {
                        this.remove(this.maxButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
                if ((state & 6) != 0) {
                    this.validateMaximizedBounds();
                    this.rootPane.setBorder(null);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            GraphicsConfiguration gc = frame.getGraphicsConfiguration();
                            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
                            Rectangle maxBounds = gc.getBounds();
                            maxBounds.width -= screenInsets.left + screenInsets.right;
                            maxBounds.height -= screenInsets.top + screenInsets.bottom;
                            if (frame.getWidth() != maxBounds.width || frame.getHeight() != maxBounds.height) {
                                BaseTitlePane.this.restore();
                                BaseTitlePane.this.wasMaximizeError = true;
                                frame.setMaximizedBounds(null);
                                BaseTitlePane.this.maximize();
                            }
                        }
                    });
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.iconifyAction.setEnabled(false);
                this.remove(this.maxButton);
                this.remove(this.iconifyButton);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = state;
        }
    }

    protected void updateMaxButton(Action action, Icon icon) {
        this.maxButton.setAction(action);
        this.maxButton.setIcon(icon);
    }

    protected int getHorSpacing() {
        return 3;
    }

    protected int getVerSpacing() {
        return 3;
    }

    protected boolean centerButtons() {
        return true;
    }

    protected String getTitle() {
        if (this.window instanceof Frame) {
            return ((Frame)this.window).getTitle();
        }
        if (this.window instanceof Dialog) {
            return ((Dialog)this.window).getTitle();
        }
        return null;
    }

    public void paintBackground(Graphics g2) {
        if (this.isActive()) {
            Graphics2D g2D = (Graphics2D)g2;
            Composite savedComposite = g2D.getComposite();
            if (this.backgroundImage != null) {
                g2.drawImage(this.backgroundImage, 0, 0, null);
                AlphaComposite alpha = AlphaComposite.getInstance(3, this.alphaValue);
                g2D.setComposite(alpha);
            }
            JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 0, 0, this.getWidth(), this.getHeight());
            g2D.setComposite(savedComposite);
        } else {
            JTattooUtilities.fillHorGradient(g2, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 0, 0, this.getWidth(), this.getHeight());
        }
    }

    protected int getIconWidth() {
        Image image = this.getFrameIconImage();
        if (image != null) {
            int h2 = this.getHeight();
            int ih = image.getHeight(null);
            int iw = image.getWidth(null);
            if (ih > h2) {
                double fac = (double)iw / (double)ih;
                ih = h2;
                iw = (int)(fac * (double)ih);
            }
            return iw;
        }
        return 0;
    }

    protected int paintIcon(Graphics g2, int x) {
        Image image = this.getFrameIconImage();
        if (image != null) {
            Graphics2D g2D = (Graphics2D)g2;
            Object savedHint = g2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            if (JTattooUtilities.getJavaVersion() >= 1.6) {
                g2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            }
            int h2 = this.getHeight() - 2;
            int ih = image.getHeight(null);
            int iw = image.getWidth(null);
            if (ih <= h2) {
                g2D.drawImage(image, x, (h2 - ih) / 2, iw, ih, null);
            } else {
                double fac = (double)iw / (double)ih;
                ih = h2;
                iw = (int)(fac * (double)ih);
                g2D.drawImage(image, x, 0, iw, ih, null);
            }
            if (savedHint != null) {
                g2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, savedHint);
            }
            return iw;
        }
        return 0;
    }

    public void paintText(Graphics g2, int x, int y, String title) {
        if (this.isActive()) {
            g2.setColor(AbstractLookAndFeel.getWindowTitleForegroundColor());
        } else {
            g2.setColor(AbstractLookAndFeel.getWindowInactiveTitleForegroundColor());
        }
        JTattooUtilities.drawString(this.rootPane, g2, title, x, y);
    }

    public void paintComponent(Graphics g2) {
        if (this.getFrame() != null) {
            this.setState(DecorationHelper.getExtendedState(this.getFrame()));
        }
        this.paintBackground(g2);
        g2.setFont(this.getFont());
        FontMetrics fm = JTattooUtilities.getFontMetrics(this, g2, this.getFont());
        int width = this.getWidth();
        int height = this.getHeight();
        int x = 0;
        int y = (height - fm.getHeight()) / 2 + fm.getAscent();
        int titleWidth = width - this.buttonsWidth - 4;
        String frameTitle = this.getTitle();
        if (this.isLeftToRight()) {
            if (this.isMacStyleWindowDecoration()) {
                int iconWidth = this.getIconWidth();
                frameTitle = JTattooUtilities.getClippedText(frameTitle, fm, titleWidth -= iconWidth + 4);
                int titleLength = fm.stringWidth(frameTitle);
                this.paintIcon(g2, x += this.buttonsWidth + (titleWidth - titleLength) / 2);
                x += iconWidth + 4;
            } else if (this.getWindow() instanceof JDialog) {
                int iconWidth = this.paintIcon(g2, x);
                frameTitle = JTattooUtilities.getClippedText(frameTitle, fm, titleWidth -= iconWidth + 4);
                if (AbstractLookAndFeel.getTheme().isCenterWindowTitleOn()) {
                    int titleLength = fm.stringWidth(frameTitle);
                    x += iconWidth + 4;
                    x += (titleWidth - titleLength) / 2;
                } else {
                    x += iconWidth + 4;
                }
            } else {
                int menuBarWidth = this.menuBar == null ? 0 : this.menuBar.getWidth();
                frameTitle = JTattooUtilities.getClippedText(frameTitle, fm, titleWidth -= menuBarWidth + 4);
                if (AbstractLookAndFeel.getTheme().isCenterWindowTitleOn()) {
                    int titleLength = fm.stringWidth(frameTitle);
                    x += menuBarWidth + 4;
                    x += (titleWidth - titleLength) / 2;
                } else {
                    x += menuBarWidth + 4;
                }
            }
        } else {
            int iconWidth = this.getIconWidth();
            if (this.isMacStyleWindowDecoration()) {
                frameTitle = JTattooUtilities.getClippedText(frameTitle, fm, titleWidth -= iconWidth + 4);
                int titleLength = fm.stringWidth(frameTitle);
                x = this.buttonsWidth + 4 + (titleWidth - titleLength) / 2;
                this.paintIcon(g2, x + titleLength + 4);
            } else if (this.getWindow() instanceof JDialog) {
                x = width - iconWidth;
                this.paintIcon(g2, x);
                frameTitle = JTattooUtilities.getClippedText(frameTitle, fm, titleWidth -= iconWidth + 4);
                int titleLength = fm.stringWidth(frameTitle);
                x = AbstractLookAndFeel.getTheme().isCenterWindowTitleOn() ? this.buttonsWidth + 4 + (titleWidth - titleLength) / 2 : width - iconWidth - 4 - titleLength;
            } else {
                int menuBarWidth = this.menuBar == null ? 0 : this.menuBar.getWidth();
                frameTitle = JTattooUtilities.getClippedText(frameTitle, fm, titleWidth -= menuBarWidth + 4);
                int titleLength = fm.stringWidth(frameTitle);
                x = AbstractLookAndFeel.getTheme().isCenterWindowTitleOn() ? this.buttonsWidth + 4 + (titleWidth - titleLength) / 2 : width - menuBarWidth - 4 - titleLength;
            }
        }
        this.paintText(g2, x, y, frameTitle);
    }

    protected class WindowHandler
    extends WindowAdapter {
        protected WindowHandler() {
        }

        public void windowDeiconified(WindowEvent e2) {
            if (JTattooUtilities.isMac() && JTattooUtilities.getJavaVersion() >= 1.7 && BaseTitlePane.this.wasMaximized) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BaseTitlePane.this.maximize();
                    }
                });
            }
        }

        public void windowActivated(WindowEvent ev) {
            BaseTitlePane.this.setActive(true);
        }

        public void windowDeactivated(WindowEvent ev) {
            BaseTitlePane.this.setActive(false);
        }
    }

    protected class PropertyChangeHandler
    implements PropertyChangeListener {
        protected PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent pce) {
            String name = pce.getPropertyName();
            if ("resizable".equals(name) || "state".equals(name)) {
                Frame frame = BaseTitlePane.this.getFrame();
                if (frame != null) {
                    BaseTitlePane.this.setState(DecorationHelper.getExtendedState(frame), true);
                }
                if ("resizable".equals(name)) {
                    BaseTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(name)) {
                BaseTitlePane.this.repaint();
            } else if ("componentOrientation".equals(name)) {
                BaseTitlePane.this.revalidate();
                BaseTitlePane.this.repaint();
            }
            if ("windowRestored".equals(name)) {
                BaseTitlePane.this.wasMaximized = false;
            } else if ("windowMaximized".equals(name)) {
                BaseTitlePane.this.wasMaximized = true;
            }
        }
    }

    protected class TitlePaneLayout
    implements LayoutManager {
        protected TitlePaneLayout() {
        }

        public void addLayoutComponent(String name, Component c2) {
        }

        public void removeLayoutComponent(Component c2) {
        }

        public Dimension preferredLayoutSize(Container c2) {
            int height = this.computeHeight();
            return new Dimension(height, height);
        }

        public Dimension minimumLayoutSize(Container c2) {
            return this.preferredLayoutSize(c2);
        }

        protected int computeHeight() {
            FontMetrics fm = JTattooUtilities.getFontMetrics(BaseTitlePane.this, null, BaseTitlePane.this.getFont());
            return fm.getHeight() + 6;
        }

        public void layoutContainer(Container c2) {
            if (AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn()) {
                this.layoutMacStyle(c2);
            } else {
                this.layoutDefault(c2);
            }
        }

        public void layoutDefault(Container c2) {
            int btnHeight;
            boolean leftToRight = BaseTitlePane.this.isLeftToRight();
            int spacing = BaseTitlePane.this.getHorSpacing();
            int w = BaseTitlePane.this.getWidth();
            int h2 = BaseTitlePane.this.getHeight();
            int btnWidth = btnHeight = h2 - BaseTitlePane.this.getVerSpacing();
            if (BaseTitlePane.this.menuBar != null) {
                int mw = BaseTitlePane.this.menuBar.getPreferredSize().width;
                int mh = BaseTitlePane.this.menuBar.getPreferredSize().height;
                if (leftToRight) {
                    BaseTitlePane.this.menuBar.setBounds(2, (h2 - mh) / 2, mw, mh);
                } else {
                    BaseTitlePane.this.menuBar.setBounds(BaseTitlePane.this.getWidth() - mw, (h2 - mh) / 2, mw, mh);
                }
            }
            int x = leftToRight ? w - spacing : 0;
            int y = Math.max(0, (h2 - btnHeight) / 2 - 1);
            if (BaseTitlePane.this.closeButton != null) {
                BaseTitlePane.this.closeButton.setBounds(x += leftToRight ? -btnWidth : spacing, y, btnWidth, btnHeight);
                if (!leftToRight) {
                    x += btnWidth;
                }
            }
            if (BaseTitlePane.this.maxButton != null && BaseTitlePane.this.maxButton.getParent() != null && DecorationHelper.isFrameStateSupported(Toolkit.getDefaultToolkit(), 6)) {
                BaseTitlePane.this.maxButton.setBounds(x += leftToRight ? -spacing - btnWidth : spacing, y, btnWidth, btnHeight);
                if (!leftToRight) {
                    x += btnWidth;
                }
            }
            if (BaseTitlePane.this.iconifyButton != null && BaseTitlePane.this.iconifyButton.getParent() != null) {
                BaseTitlePane.this.iconifyButton.setBounds(x += leftToRight ? -spacing - btnWidth : spacing, y, btnWidth, btnHeight);
                if (!leftToRight) {
                    x += btnWidth;
                }
            }
            int n2 = BaseTitlePane.this.buttonsWidth = leftToRight ? w - x : x;
            if (BaseTitlePane.this.customTitlePanel != null) {
                int maxWidth = w - BaseTitlePane.this.buttonsWidth - spacing - 20;
                if (BaseTitlePane.this.menuBar != null) {
                    maxWidth -= BaseTitlePane.this.menuBar.getPreferredSize().width;
                    maxWidth -= spacing;
                }
                int cpw = Math.min(maxWidth, BaseTitlePane.this.customTitlePanel.getPreferredSize().width);
                int cph = h2;
                int cpx = leftToRight ? w - BaseTitlePane.this.buttonsWidth - cpw : BaseTitlePane.this.buttonsWidth;
                int cpy = 0;
                BaseTitlePane.this.customTitlePanel.setBounds(cpx, cpy, cpw, cph);
                BaseTitlePane.this.buttonsWidth += BaseTitlePane.this.customTitlePanel.getPreferredSize().width;
            }
        }

        public void layoutMacStyle(Container c2) {
            int y;
            int btnHeight;
            int spacing = BaseTitlePane.this.getHorSpacing();
            int w = BaseTitlePane.this.getWidth();
            int h2 = BaseTitlePane.this.getHeight();
            int btnWidth = btnHeight = h2 - BaseTitlePane.this.getVerSpacing() - 1;
            int x = 2;
            int n2 = y = BaseTitlePane.this.centerButtons() ? Math.max(0, (h2 - btnHeight) / 2 - 1) : 0;
            if (BaseTitlePane.this.closeButton != null) {
                BaseTitlePane.this.closeButton.setBounds(x, y, btnWidth, btnHeight);
                x += btnWidth + spacing;
            }
            if (BaseTitlePane.this.iconifyButton != null && BaseTitlePane.this.iconifyButton.getParent() != null) {
                BaseTitlePane.this.iconifyButton.setBounds(x, y, btnWidth, btnHeight);
                x += btnWidth + spacing;
            }
            if (BaseTitlePane.this.maxButton != null && BaseTitlePane.this.maxButton.getParent() != null && DecorationHelper.isFrameStateSupported(Toolkit.getDefaultToolkit(), 6)) {
                BaseTitlePane.this.maxButton.setBounds(x, y, btnWidth, btnHeight);
                x += btnWidth + spacing;
            }
            BaseTitlePane.this.buttonsWidth = x;
            if (BaseTitlePane.this.customTitlePanel != null) {
                int cpx = BaseTitlePane.this.buttonsWidth + 5;
                int cpy = 0;
                int cpw = BaseTitlePane.this.customTitlePanel.getPreferredSize().width;
                int cph = h2;
                BaseTitlePane.this.customTitlePanel.setBounds(cpx, cpy, cpw, cph);
                BaseTitlePane.this.buttonsWidth += cpw + 5;
            }
        }
    }

    protected class SystemMenuBar
    extends JMenuBar {
        public SystemMenuBar() {
            this.setOpaque(false);
        }

        public void paint(Graphics g2) {
            Image image = BaseTitlePane.this.getFrameIconImage();
            if (image != null) {
                Graphics2D g2D = (Graphics2D)g2;
                Object savedHint = g2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
                g2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                int x = 0;
                int y = 0;
                int iw = image.getWidth(null);
                int ih = image.getHeight(null);
                if (ih > this.getHeight()) {
                    double scale = (double)(this.getHeight() - 2) / (double)ih;
                    iw = (int)(scale * (double)iw);
                    ih = (int)(scale * (double)ih);
                } else {
                    y = (this.getHeight() - ih) / 2;
                }
                g2D.drawImage(image, x, y, iw, ih, null);
                if (savedHint != null) {
                    g2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, savedHint);
                }
            } else {
                Icon icon = UIManager.getIcon("InternalFrame.icon");
                if (icon != null) {
                    icon.paintIcon(this, g2, 2, 2);
                }
            }
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        protected int computeHeight() {
            FontMetrics fm = JTattooUtilities.getFontMetrics(this, null, this.getFont());
            return fm.getHeight() + 6;
        }

        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            Image image = BaseTitlePane.this.getFrameIconImage();
            if (image != null) {
                int th;
                int iw = image.getWidth(null);
                int ih = image.getHeight(null);
                if (ih > (th = this.computeHeight())) {
                    double scale = (double)th / (double)ih;
                    iw = (int)(scale * (double)iw);
                    ih = (int)(scale * (double)ih);
                }
                return new Dimension(Math.max(iw, size.width), Math.max(ih, size.height));
            }
            return size;
        }
    }

    protected class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(UIManager.getString("MetalTitlePane.maximizeTitle"));
        }

        public void actionPerformed(ActionEvent e2) {
            BaseTitlePane.this.maximize();
        }
    }

    protected class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(UIManager.getString("MetalTitlePane.restoreTitle"));
        }

        public void actionPerformed(ActionEvent e2) {
            BaseTitlePane.this.restore();
        }
    }

    protected class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super(UIManager.getString("MetalTitlePane.iconifyTitle"));
        }

        public void actionPerformed(ActionEvent e2) {
            BaseTitlePane.this.iconify();
        }
    }

    protected class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(UIManager.getString("MetalTitlePane.closeTitle"));
        }

        public void actionPerformed(ActionEvent e2) {
            BaseTitlePane.this.close();
        }
    }
}

