/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseButtonListener;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import javax.swing.text.View;

public class BaseToggleButtonUI
extends BasicToggleButtonUI {
    private static final Rectangle viewRect = new Rectangle();
    private static final Rectangle textRect = new Rectangle();
    private static final Rectangle iconRect = new Rectangle();

    public static ComponentUI createUI(JComponent b2) {
        return new BaseToggleButtonUI();
    }

    public void installDefaults(AbstractButton b2) {
        super.installDefaults(b2);
        b2.setOpaque(false);
        b2.setRolloverEnabled(true);
    }

    public void uninstallDefaults(AbstractButton b2) {
        super.uninstallDefaults(b2);
        b2.setOpaque(true);
        b2.setRolloverEnabled(false);
    }

    protected BasicButtonListener createButtonListener(AbstractButton b2) {
        return new BaseButtonListener(b2);
    }

    protected void paintBackground(Graphics g2, AbstractButton b2) {
        Color background;
        if (!b2.isContentAreaFilled() || b2.getParent() instanceof JMenuBar) {
            return;
        }
        int width = b2.getWidth();
        int height = b2.getHeight();
        ButtonModel model = b2.getModel();
        Color[] colors = b2.isEnabled() ? ((background = b2.getBackground()) instanceof ColorUIResource ? (b2.isRolloverEnabled() && model.isRollover() ? AbstractLookAndFeel.getTheme().getRolloverColors() : (model.isPressed() && model.isArmed() || model.isSelected() ? AbstractLookAndFeel.getTheme().getPressedColors() : (AbstractLookAndFeel.getTheme().doShowFocusFrame() && b2.hasFocus() ? AbstractLookAndFeel.getTheme().getFocusColors() : AbstractLookAndFeel.getTheme().getButtonColors()))) : (model.isPressed() && model.isArmed() ? ColorHelper.createColorArr(ColorHelper.darker(background, 30.0), ColorHelper.darker(background, 10.0), 20) : (b2.isRolloverEnabled() && model.isRollover() ? (model.isSelected() ? ColorHelper.createColorArr(ColorHelper.darker(background, 20.0), background, 20) : ColorHelper.createColorArr(ColorHelper.brighter(background, 50.0), ColorHelper.brighter(background, 10.0), 20)) : (model.isSelected() ? ColorHelper.createColorArr(ColorHelper.darker(background, 40.0), ColorHelper.darker(background, 20.0), 20) : ColorHelper.createColorArr(ColorHelper.brighter(background, 30.0), ColorHelper.darker(background, 10.0), 20))))) : AbstractLookAndFeel.getTheme().getDisabledColors();
        JTattooUtilities.fillHorGradient(g2, colors, 1, 1, width - 2, height - 2);
    }

    protected void paintText(Graphics g2, AbstractButton b2, Rectangle textRect, String text) {
        int mnemIndex;
        ButtonModel model = b2.getModel();
        FontMetrics fm = JTattooUtilities.getFontMetrics(b2, g2, b2.getFont());
        int n2 = mnemIndex = JTattooUtilities.getJavaVersion() >= 1.4 ? b2.getDisplayedMnemonicIndex() : JTattooUtilities.findDisplayedMnemonicIndex(b2.getText(), model.getMnemonic());
        if (model.isEnabled()) {
            Object sc;
            Color foreground = b2.getForeground();
            Color background = b2.getBackground();
            int offs = 0;
            if (model.isArmed() && model.isPressed() || model.isSelected()) {
                offs = 1;
                if (foreground instanceof ColorUIResource && background instanceof ColorUIResource) {
                    foreground = AbstractLookAndFeel.getTheme().getPressedForegroundColor();
                }
            }
            if (model.isRollover() && foreground instanceof ColorUIResource && background instanceof ColorUIResource) {
                foreground = AbstractLookAndFeel.getTheme().getRolloverForegroundColor();
            }
            if ((sc = b2.getClientProperty("shadowColor")) instanceof Color) {
                g2.setColor((Color)sc);
                JTattooUtilities.drawStringUnderlineCharAt(b2, g2, text, mnemIndex, textRect.x + offs, textRect.y + fm.getAscent() * offs + 1);
            }
            g2.setColor(foreground);
            JTattooUtilities.drawStringUnderlineCharAt(b2, g2, text, mnemIndex, textRect.x + offs, textRect.y + fm.getAscent() + offs);
        } else {
            g2.setColor(Color.white);
            JTattooUtilities.drawStringUnderlineCharAt(b2, g2, text, mnemIndex, textRect.x + 1, textRect.y + fm.getAscent() + 1);
            g2.setColor(AbstractLookAndFeel.getDisabledForegroundColor());
            JTattooUtilities.drawStringUnderlineCharAt(b2, g2, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    protected void paintFocus(Graphics g2, AbstractButton b2, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        g2.setColor(AbstractLookAndFeel.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(g2, 4, 3, b2.getWidth() - 8, b2.getHeight() - 6);
    }

    public void paint(Graphics g2, JComponent c2) {
        Graphics2D g2D = (Graphics2D)g2;
        AbstractButton b2 = (AbstractButton)c2;
        g2.setFont(b2.getFont());
        FontMetrics fm = JTattooUtilities.getFontMetrics(b2, g2, b2.getFont());
        Insets insets = c2.getInsets();
        BaseToggleButtonUI.viewRect.x = insets.left;
        BaseToggleButtonUI.viewRect.y = insets.top;
        BaseToggleButtonUI.viewRect.width = b2.getWidth() - (insets.right + BaseToggleButtonUI.viewRect.x);
        BaseToggleButtonUI.viewRect.height = b2.getHeight() - (insets.bottom + BaseToggleButtonUI.viewRect.y);
        BaseToggleButtonUI.textRect.height = 0;
        BaseToggleButtonUI.textRect.width = 0;
        BaseToggleButtonUI.textRect.y = 0;
        BaseToggleButtonUI.textRect.x = 0;
        BaseToggleButtonUI.iconRect.height = 0;
        BaseToggleButtonUI.iconRect.width = 0;
        BaseToggleButtonUI.iconRect.y = 0;
        BaseToggleButtonUI.iconRect.x = 0;
        int iconTextGap = this.defaultTextIconGap;
        if (JTattooUtilities.getJavaVersion() >= 1.4) {
            iconTextGap = b2.getIconTextGap();
        }
        String text = SwingUtilities.layoutCompoundLabel(c2, fm, b2.getText(), b2.getIcon(), b2.getVerticalAlignment(), b2.getHorizontalAlignment(), b2.getVerticalTextPosition(), b2.getHorizontalTextPosition(), viewRect, iconRect, textRect, b2.getText() == null ? 0 : iconTextGap);
        this.paintBackground(g2, b2);
        if (b2.getIcon() != null) {
            if (!b2.isEnabled()) {
                Composite savedComposite = g2D.getComposite();
                AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
                g2D.setComposite(alpha);
                this.paintIcon(g2, c2, iconRect);
                g2D.setComposite(savedComposite);
            } else {
                this.paintIcon(g2, c2, iconRect);
            }
        }
        if (text != null && !text.equals("") && textRect != null) {
            View v = (View)c2.getClientProperty("html");
            if (v != null) {
                Object savedRenderingHint = null;
                if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                    savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                    g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
                }
                v.paint(g2, textRect);
                if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                    g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedRenderingHint);
                }
            } else {
                this.paintText(g2, b2, textRect, text);
            }
        }
        if (b2.isFocusPainted() && b2.hasFocus()) {
            this.paintFocus(g2, b2, viewRect, textRect, iconRect);
        }
    }
}

