/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseScrollBarUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class XPScrollBarUI
extends BaseScrollBarUI {
    protected static Color[] rolloverColors = null;
    protected static Color[] dragColors = null;

    public static ComponentUI createUI(JComponent c2) {
        return new XPScrollBarUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        Color[] colors = AbstractLookAndFeel.getTheme().getThumbColors();
        rolloverColors = new Color[colors.length];
        dragColors = new Color[colors.length];
        for (int i2 = 0; i2 < colors.length; ++i2) {
            XPScrollBarUI.rolloverColors[i2] = ColorHelper.brighter(colors[i2], 16.0);
            XPScrollBarUI.dragColors[i2] = ColorHelper.darker(colors[i2], 8.0);
        }
    }

    protected Color getFrameColor() {
        return Color.white;
    }

    protected Color[] getThumbColors() {
        if (this.isDragging) {
            return dragColors;
        }
        if (this.isRollover) {
            return rolloverColors;
        }
        return AbstractLookAndFeel.getTheme().getThumbColors();
    }

    protected void paintThumb(Graphics g2, JComponent c2, Rectangle thumbBounds) {
        int dy;
        int dx;
        if (!c2.isEnabled()) {
            return;
        }
        Graphics2D g2D = (Graphics2D)g2;
        Composite savedComposite = g2D.getComposite();
        int x = thumbBounds.x;
        int y = thumbBounds.y;
        int width = thumbBounds.width;
        int height = thumbBounds.height;
        g2.translate(x, y);
        Color[] colors = this.getThumbColors();
        if (this.scrollbar.getOrientation() == 1) {
            JTattooUtilities.fillVerGradient(g2, colors, 0, 0, width, height);
            if (!AbstractLookAndFeel.getTheme().isMacStyleScrollBarOn()) {
                dx = 6;
                dy = height / 2 - 3;
                int dw = width - 13;
                Color c1 = ColorHelper.brighter(colors[0], 60.0);
                Color c22 = ColorHelper.darker(colors[0], 30.0);
                AlphaComposite alpha = AlphaComposite.getInstance(3, 0.6f);
                g2D.setComposite(alpha);
                for (int i2 = 0; i2 < 4; ++i2) {
                    g2.setColor(c1);
                    g2.drawLine(dx, dy, dx + dw, dy);
                    g2.setColor(c22);
                    g2.drawLine(dx, ++dy, dx + dw, dy);
                    ++dy;
                }
            }
        } else {
            JTattooUtilities.fillHorGradient(g2, colors, 0, 0, width, height);
            if (!AbstractLookAndFeel.getTheme().isMacStyleScrollBarOn()) {
                dx = width / 2 - 3;
                dy = 6;
                int dh = height - 13;
                Color c1 = ColorHelper.brighter(colors[0], 60.0);
                Color c23 = ColorHelper.darker(colors[0], 30.0);
                AlphaComposite alpha = AlphaComposite.getInstance(3, 0.8f);
                g2D.setComposite(alpha);
                for (int i3 = 0; i3 < 4; ++i3) {
                    g2.setColor(c1);
                    g2.drawLine(dx, dy, dx, dy + dh);
                    g2.setColor(c23);
                    g2.drawLine(++dx, dy, dx, dy + dh);
                    ++dx;
                }
            }
        }
        g2.setColor(this.getFrameColor());
        g2.drawLine(1, 1, width - 2, 1);
        g2.drawLine(1, 2, 1, height - 3);
        g2.drawLine(width - 2, 2, width - 2, height - 3);
        g2.drawLine(2, height - 2, width - 3, height - 2);
        AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
        g2D.setComposite(alpha);
        Color fc = colors[colors.length - 1];
        g2D.setColor(fc);
        g2.drawLine(2, 2, width - 3, 2);
        g2.drawLine(2, 3, 2, height - 3);
        g2.setColor(ColorHelper.darker(fc, 40.0));
        g2.drawLine(width - 1, 2, width - 1, height - 3);
        g2.drawLine(3, height - 1, width - 3, height - 1);
        alpha = AlphaComposite.getInstance(3, 0.2f);
        g2D.setComposite(alpha);
        g2.drawLine(1, height - 2, 2, height - 1);
        g2.drawLine(width - 1, height - 2, width - 2, height - 1);
        g2.translate(-x, -y);
        g2D.setComposite(savedComposite);
    }
}

