/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.acryl;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseInternalFrameTitlePane;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class AcrylInternalFrameTitlePane
extends BaseInternalFrameTitlePane {
    public AcrylInternalFrameTitlePane(JInternalFrame f2) {
        super(f2);
    }

    protected LayoutManager createLayout() {
        return new BaseTitlePaneLayout();
    }

    protected int getHorSpacing() {
        return 1;
    }

    protected int getVerSpacing() {
        return 3;
    }

    public void paintBorder(Graphics g2) {
        if (this.isActive()) {
            g2.setColor(AbstractLookAndFeel.getWindowBorderColor());
        } else {
            g2.setColor(AbstractLookAndFeel.getWindowInactiveBorderColor());
        }
        g2.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
    }

    public void paintText(Graphics g2, int x, int y, String title) {
        Color shadowColor = AbstractLookAndFeel.getWindowTitleColorDark();
        if (this.isActive()) {
            shadowColor = ColorHelper.darker(shadowColor, 30.0);
        }
        g2.setColor(shadowColor);
        JTattooUtilities.drawString(this.frame, g2, title, x - 1, y - 2);
        JTattooUtilities.drawString(this.frame, g2, title, x - 1, y);
        JTattooUtilities.drawString(this.frame, g2, title, x + 1, y - 2);
        JTattooUtilities.drawString(this.frame, g2, title, x + 1, y);
        if (this.isActive()) {
            g2.setColor(AbstractLookAndFeel.getWindowTitleForegroundColor());
        } else {
            g2.setColor(AbstractLookAndFeel.getWindowInactiveTitleForegroundColor());
        }
        JTattooUtilities.drawString(this.frame, g2, title, x, y - 1);
    }

    class BaseTitlePaneLayout
    extends BasicInternalFrameTitlePane.TitlePaneLayout {
        BaseTitlePaneLayout() {
            super(AcrylInternalFrameTitlePane.this);
        }

        public void addLayoutComponent(String name, Component c2) {
        }

        public void removeLayoutComponent(Component c2) {
        }

        public Dimension preferredLayoutSize(Container c2) {
            return this.minimumLayoutSize(c2);
        }

        public Dimension minimumLayoutSize(Container c2) {
            int subtitle_w;
            int title_length;
            int width = 30;
            if (AcrylInternalFrameTitlePane.this.frame.isClosable()) {
                width += 21;
            }
            if (AcrylInternalFrameTitlePane.this.frame.isMaximizable()) {
                width += 16 + (AcrylInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4);
            }
            if (AcrylInternalFrameTitlePane.this.frame.isIconifiable()) {
                width += 16 + (AcrylInternalFrameTitlePane.this.frame.isMaximizable() ? 2 : (AcrylInternalFrameTitlePane.this.frame.isClosable() ? 10 : 4));
            }
            FontMetrics fm = JTattooUtilities.getFontMetrics(AcrylInternalFrameTitlePane.this, null, AcrylInternalFrameTitlePane.this.getFont());
            String frameTitle = AcrylInternalFrameTitlePane.this.frame.getTitle();
            int title_w = frameTitle != null ? fm.stringWidth(frameTitle) : 0;
            int n2 = title_length = frameTitle != null ? frameTitle.length() : 0;
            width = title_length > 2 ? (width += title_w < (subtitle_w = fm.stringWidth(AcrylInternalFrameTitlePane.this.frame.getTitle().substring(0, 2) + "...")) ? title_w : subtitle_w) : (width += title_w);
            int height = AcrylInternalFrameTitlePane.this.paletteTitleHeight;
            if (!AcrylInternalFrameTitlePane.this.isPalette) {
                int fontHeight = fm.getHeight() + 5;
                Icon icon = AcrylInternalFrameTitlePane.this.isMacStyleWindowDecoration() ? null : AcrylInternalFrameTitlePane.this.frame.getFrameIcon();
                int iconHeight = 0;
                if (icon != null) {
                    iconHeight = Math.min(icon.getIconHeight(), 18);
                }
                height = Math.max(fontHeight, iconHeight += 5);
            }
            return new Dimension(width, height);
        }

        public void layoutContainer(Container c2) {
            if (AbstractLookAndFeel.getTheme().isMacStyleWindowDecorationOn()) {
                this.layoutMacStyle(c2);
            } else {
                this.layoutDefault(c2);
            }
        }

        public void layoutDefault(Container c2) {
            boolean leftToRight = JTattooUtilities.isLeftToRight(AcrylInternalFrameTitlePane.this.frame);
            int spacing = AcrylInternalFrameTitlePane.this.getHorSpacing();
            int w = AcrylInternalFrameTitlePane.this.getWidth();
            int h2 = AcrylInternalFrameTitlePane.this.getHeight();
            int btnHeight = h2 - AcrylInternalFrameTitlePane.this.getVerSpacing();
            int btnWidth = btnHeight + 10;
            int x = leftToRight ? w - spacing : 0;
            int y = Math.max(0, (h2 - btnHeight) / 2 - 1);
            if (AcrylInternalFrameTitlePane.this.frame.isClosable()) {
                AcrylInternalFrameTitlePane.this.closeButton.setBounds(x += leftToRight ? -btnWidth : spacing, y, btnWidth, btnHeight);
                if (!leftToRight) {
                    x += btnWidth;
                }
            }
            if (AcrylInternalFrameTitlePane.this.frame.isMaximizable() && !AcrylInternalFrameTitlePane.this.isPalette) {
                AcrylInternalFrameTitlePane.this.maxButton.setBounds(x += leftToRight ? -spacing - btnWidth : spacing, y, btnWidth, btnHeight);
                if (!leftToRight) {
                    x += btnWidth;
                }
            }
            if (AcrylInternalFrameTitlePane.this.frame.isIconifiable() && !AcrylInternalFrameTitlePane.this.isPalette) {
                AcrylInternalFrameTitlePane.this.iconButton.setBounds(x += leftToRight ? -spacing - btnWidth : spacing, y, btnWidth, btnHeight);
                if (!leftToRight) {
                    x += btnWidth;
                }
            }
            AcrylInternalFrameTitlePane.this.buttonsWidth = leftToRight ? w - x : x;
            if (AcrylInternalFrameTitlePane.this.customTitlePanel != null) {
                int maxWidth = w - AcrylInternalFrameTitlePane.this.buttonsWidth - spacing - 20;
                Icon icon = AcrylInternalFrameTitlePane.this.frame.getFrameIcon();
                if (icon != null) {
                    maxWidth -= icon.getIconWidth();
                    maxWidth -= spacing;
                }
                int cpw = Math.min(maxWidth, ((AcrylInternalFrameTitlePane)AcrylInternalFrameTitlePane.this).customTitlePanel.getPreferredSize().width);
                int cph = h2;
                int cpx = leftToRight ? w - AcrylInternalFrameTitlePane.this.buttonsWidth - cpw : AcrylInternalFrameTitlePane.this.buttonsWidth;
                int cpy = 0;
                AcrylInternalFrameTitlePane.this.customTitlePanel.setBounds(cpx, cpy, cpw, cph);
                AcrylInternalFrameTitlePane.this.buttonsWidth += ((AcrylInternalFrameTitlePane)AcrylInternalFrameTitlePane.this).customTitlePanel.getPreferredSize().width;
            }
        }

        private void layoutMacStyle(Container c2) {
            int btnHeight;
            int spacing = AcrylInternalFrameTitlePane.this.getHorSpacing();
            int h2 = AcrylInternalFrameTitlePane.this.getHeight();
            int btnWidth = btnHeight = h2 - AcrylInternalFrameTitlePane.this.getVerSpacing();
            int x = 0;
            int y = 0;
            if (AcrylInternalFrameTitlePane.this.frame.isClosable()) {
                AcrylInternalFrameTitlePane.this.closeButton.setBounds(x, y, btnWidth, btnHeight);
                x += btnWidth + spacing;
            }
            if (AcrylInternalFrameTitlePane.this.frame.isIconifiable() && !AcrylInternalFrameTitlePane.this.isPalette) {
                AcrylInternalFrameTitlePane.this.iconButton.setBounds(x, y, btnWidth, btnHeight);
                x += btnWidth + spacing;
            }
            if (AcrylInternalFrameTitlePane.this.frame.isMaximizable() && !AcrylInternalFrameTitlePane.this.isPalette) {
                AcrylInternalFrameTitlePane.this.maxButton.setBounds(x, y, btnWidth, btnHeight);
                x += btnWidth + spacing;
            }
            AcrylInternalFrameTitlePane.this.buttonsWidth = x;
            if (AcrylInternalFrameTitlePane.this.customTitlePanel != null) {
                int cpx = AcrylInternalFrameTitlePane.this.buttonsWidth + 5;
                int cpy = 0;
                int cpw = ((AcrylInternalFrameTitlePane)AcrylInternalFrameTitlePane.this).customTitlePanel.getPreferredSize().width;
                int cph = h2;
                AcrylInternalFrameTitlePane.this.customTitlePanel.setBounds(cpx, cpy, cpw, cph);
                AcrylInternalFrameTitlePane.this.buttonsWidth += cpw + 5;
            }
        }
    }
}

