/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.aero;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseTabbedPaneUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.View;

public class AeroTabbedPaneUI
extends BaseTabbedPaneUI {
    private Color[] sepColors = null;

    public static ComponentUI createUI(JComponent c2) {
        return new AeroTabbedPaneUI();
    }

    protected void installComponents() {
        this.simpleButtonBorder = true;
        super.installComponents();
    }

    protected Color[] getContentBorderColors(int tabPlacement) {
        if (this.sepColors == null) {
            this.sepColors = new Color[5];
            this.sepColors[0] = ColorHelper.brighter(AbstractLookAndFeel.getControlColorDark(), 40.0);
            this.sepColors[1] = ColorHelper.brighter(AbstractLookAndFeel.getControlColorLight(), 40.0);
            this.sepColors[2] = ColorHelper.brighter(AbstractLookAndFeel.getControlColorLight(), 60.0);
            this.sepColors[3] = ColorHelper.brighter(AbstractLookAndFeel.getControlColorLight(), 20.0);
            this.sepColors[4] = ColorHelper.brighter(AbstractLookAndFeel.getControlColorDark(), 30.0);
        }
        return this.sepColors;
    }

    protected Font getTabFont(boolean isSelected) {
        if (isSelected) {
            return super.getTabFont(isSelected).deriveFont(1);
        }
        return super.getTabFont(isSelected);
    }

    protected void paintText(Graphics g2, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        Color backColor = this.tabPane.getBackgroundAt(tabIndex);
        if (!(backColor instanceof UIResource)) {
            super.paintText(g2, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
            return;
        }
        g2.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            Graphics2D g2D = (Graphics2D)g2;
            Object savedRenderingHint = null;
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AbstractLookAndFeel.getTheme().getTextAntiAliasingHint());
            }
            v.paint(g2, textRect);
            if (AbstractLookAndFeel.getTheme().isTextAntiAliasingOn()) {
                g2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, savedRenderingHint);
            }
        } else {
            int mnemIndex = -1;
            if (JTattooUtilities.getJavaVersion() >= 1.4) {
                mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            }
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                if (isSelected) {
                    ColorUIResource titleColor = AbstractLookAndFeel.getTabSelectionForegroundColor();
                    if (ColorHelper.getGrayValue(titleColor) > 164) {
                        g2.setColor(Color.black);
                    } else {
                        g2.setColor(Color.white);
                    }
                    JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g2, title, mnemIndex, textRect.x + 1, textRect.y + 1 + metrics.getAscent());
                    g2.setColor(titleColor);
                } else {
                    g2.setColor(this.tabPane.getForegroundAt(tabIndex));
                }
                JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g2, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
            } else {
                g2.setColor(this.tabPane.getBackgroundAt(tabIndex).brighter());
                JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g2, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
                g2.setColor(this.tabPane.getBackgroundAt(tabIndex).darker());
                JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g2, title, mnemIndex, textRect.x - 1, textRect.y + metrics.getAscent() - 1);
            }
        }
    }
}

