/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.aluminium;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseToggleButtonUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class AluminiumToggleButtonUI
extends BaseToggleButtonUI {
    public static ComponentUI createUI(JComponent c2) {
        return new AluminiumToggleButtonUI();
    }

    protected void paintBackground(Graphics g2, AbstractButton b2) {
        Color background;
        if (!b2.isContentAreaFilled() || b2.getParent() instanceof JMenuBar) {
            return;
        }
        if (!b2.isBorderPainted() || !(b2.getBorder() instanceof UIResource)) {
            super.paintBackground(g2, b2);
            return;
        }
        int width = b2.getWidth();
        int height = b2.getHeight();
        ButtonModel model = b2.getModel();
        Graphics2D g2D = (Graphics2D)g2;
        Composite composite = g2D.getComposite();
        Object savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color[] colors = b2.isEnabled() ? ((background = b2.getBackground()) instanceof ColorUIResource ? (b2.isRolloverEnabled() && model.isRollover() ? AbstractLookAndFeel.getTheme().getRolloverColors() : (model.isPressed() && model.isArmed() || model.isSelected() ? AbstractLookAndFeel.getTheme().getPressedColors() : (AbstractLookAndFeel.getTheme().doShowFocusFrame() && b2.hasFocus() ? AbstractLookAndFeel.getTheme().getFocusColors() : AbstractLookAndFeel.getTheme().getButtonColors()))) : (model.isPressed() && model.isArmed() ? ColorHelper.createColorArr(ColorHelper.darker(background, 30.0), ColorHelper.darker(background, 10.0), 20) : (b2.isRolloverEnabled() && model.isRollover() ? (model.isSelected() ? ColorHelper.createColorArr(ColorHelper.darker(background, 20.0), background, 20) : ColorHelper.createColorArr(ColorHelper.brighter(background, 50.0), ColorHelper.brighter(background, 10.0), 20)) : (model.isSelected() ? ColorHelper.createColorArr(ColorHelper.darker(background, 40.0), ColorHelper.darker(background, 20.0), 20) : ColorHelper.createColorArr(ColorHelper.brighter(background, 30.0), ColorHelper.darker(background, 10.0), 20))))) : AbstractLookAndFeel.getTheme().getDisabledColors();
        if (AbstractLookAndFeel.getTheme().doDrawSquareButtons() || (width < 64 || height < 16) && (b2.getText() == null || b2.getText().length() == 0)) {
            JTattooUtilities.fillHorGradient(g2, colors, 0, 0, width - 1, height - 1);
            if (model.isEnabled()) {
                g2D.setColor(AbstractLookAndFeel.getFrameColor());
            } else {
                g2D.setColor(ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 20.0));
            }
            g2D.drawRect(0, 0, width - 1, height - 1);
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.6f);
            g2D.setComposite(alpha);
            g2D.setColor(Color.white);
            g2D.drawRect(1, 1, width - 3, height - 3);
        } else {
            int d2 = height - 2;
            Shape savedClip = g2.getClip();
            Area clipArea = new Area(new RoundRectangle2D.Double(0.0, 0.0, width - 1, height - 1, d2, d2));
            if (savedClip != null) {
                clipArea.intersect(new Area(savedClip));
            }
            g2D.setClip(clipArea);
            JTattooUtilities.fillHorGradient(g2, colors, 0, 0, width - 1, height - 1);
            g2D.setClip(savedClip);
            if (model.isEnabled()) {
                g2D.setColor(AbstractLookAndFeel.getFrameColor());
            } else {
                g2D.setColor(ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 20.0));
            }
            g2D.drawRoundRect(0, 0, width - 1, height - 1, d2, d2);
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.6f);
            g2D.setComposite(alpha);
            g2D.setColor(Color.white);
            g2D.drawRoundRect(1, 1, width - 3, height - 3, d2 - 2, d2 - 2);
        }
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRenderingHint);
        g2D.setComposite(composite);
    }

    protected void paintFocus(Graphics g2, AbstractButton b2, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        Graphics2D g2D = (Graphics2D)g2;
        int width = b2.getWidth();
        int height = b2.getHeight();
        if (!(!AbstractLookAndFeel.getTheme().doDrawSquareButtons() && b2.isContentAreaFilled() && b2.getBorder() instanceof UIResource && (width >= 64 && height >= 16 || b2.getText() != null && b2.getText().length() != 0))) {
            g2.setColor(AbstractLookAndFeel.getFocusColor());
            BasicGraphicsUtils.drawDashedRect(g2, 4, 3, width - 8, height - 6);
        } else {
            Object savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.setColor(AbstractLookAndFeel.getFocusColor());
            int d2 = b2.getHeight() - 4;
            g2D.drawRoundRect(2, 2, b2.getWidth() - 5, b2.getHeight() - 5, d2, d2);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRenderingHint);
        }
    }
}

