/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.bernstein;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseBorders;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class BernsteinBorders
extends BaseBorders {
    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        return BernsteinBorders.getButtonBorder();
    }

    public static Border getRolloverToolButtonBorder() {
        if (rolloverToolButtonBorder == null) {
            rolloverToolButtonBorder = new RolloverToolButtonBorder();
        }
        return rolloverToolButtonBorder;
    }

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new InternalFrameBorder();
        }
        return internalFrameBorder;
    }

    public static class InternalFrameBorder
    extends BaseBorders.BaseInternalFrameBorder {
        private static final Color borderColor = new Color(255, 244, 128);
        private static final Color[] FRAME_COLORS = new Color[]{new Color(229, 187, 0), new Color(251, 232, 0), new Color(247, 225, 0), new Color(243, 216, 0), new Color(229, 187, 0)};

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w, int h2) {
            if (!this.isResizable(c2)) {
                Color cHi = ColorHelper.brighter(borderColor, 40.0);
                Color cLo = ColorHelper.darker(borderColor, 20.0);
                JTattooUtilities.draw3DBorder(g2, cHi, cLo, x, y, w, h2);
                cHi = ColorHelper.darker(cHi, 20.0);
                cLo = ColorHelper.brighter(cLo, 20.0);
                JTattooUtilities.draw3DBorder(g2, cHi, cLo, x + 1, y + 1, w - 2, h2 - 2);
                g2.setColor(borderColor);
                for (int i2 = 2; i2 < 5; ++i2) {
                    g2.drawRect(i2, i2, w - 2 * i2 - 1, h2 - 2 * i2 - 1);
                }
                return;
            }
            int dt = w / 3;
            int db = w * 2 / 3;
            --w;
            Color cr = borderColor;
            g2.setColor(FRAME_COLORS[0]);
            g2.drawLine(x, y, x, y + --h2);
            g2.setColor(FRAME_COLORS[1]);
            g2.drawLine(x + 1, y + 1, x + 1, y + h2 - 1);
            g2.setColor(FRAME_COLORS[2]);
            g2.drawLine(x + 2, y + 2, x + 2, y + h2 - 2);
            g2.setColor(FRAME_COLORS[3]);
            g2.drawLine(x + 3, y + 3, x + 3, y + h2 - 3);
            g2.setColor(FRAME_COLORS[4]);
            g2.drawLine(x + 4, y + 4, x + 4, y + h2 - 4);
            g2.setColor(cr);
            g2.drawLine(x + w, y, x + w, y + h2);
            g2.setColor(ColorHelper.brighter(cr, 30.0));
            g2.drawLine(x + w - 1, y + 1, x + w - 1, y + h2 - 1);
            g2.setColor(ColorHelper.brighter(cr, 60.0));
            g2.drawLine(x + w - 2, y + 2, x + w - 2, y + h2 - 2);
            g2.setColor(ColorHelper.brighter(cr, 90.0));
            g2.drawLine(x + w - 3, y + 3, x + w - 3, y + h2 - 3);
            g2.setColor(cr);
            g2.drawLine(x + w - 4, y + 4, x + w - 4, y + h2 - 4);
            g2.setColor(FRAME_COLORS[0]);
            g2.drawLine(x + w, y, x + w, y + 22);
            g2.setColor(FRAME_COLORS[1]);
            g2.drawLine(x + w - 1, y + 1, x + w - 1, y + 22);
            g2.setColor(FRAME_COLORS[2]);
            g2.drawLine(x + w - 2, y + 2, x + w - 2, y + 22);
            g2.setColor(FRAME_COLORS[3]);
            g2.drawLine(x + w - 3, y + 3, x + w - 3, y + 22);
            g2.setColor(FRAME_COLORS[4]);
            g2.drawLine(x + w - 4, y + 4, x + w - 4, y + 22);
            g2.setColor(FRAME_COLORS[0]);
            g2.drawLine(x + w, y + h2 - 22, x + w, y + h2);
            g2.setColor(FRAME_COLORS[1]);
            g2.drawLine(x + w - 1, y + h2 - 22, x + w - 1, y + h2 - 1);
            g2.setColor(FRAME_COLORS[2]);
            g2.drawLine(x + w - 2, y + h2 - 22, x + w - 2, y + h2 - 2);
            g2.setColor(FRAME_COLORS[3]);
            g2.drawLine(x + w - 3, y + h2 - 22, x + w - 3, y + h2 - 3);
            g2.setColor(FRAME_COLORS[4]);
            g2.drawLine(x + w - 4, y + h2 - 22, x + w - 4, y + h2 - 4);
            g2.setColor(FRAME_COLORS[0]);
            g2.drawLine(x, y, x + dt, y);
            g2.setColor(FRAME_COLORS[1]);
            g2.drawLine(x + 1, y + 1, x + dt, y + 1);
            g2.setColor(FRAME_COLORS[2]);
            g2.drawLine(x + 2, y + 2, x + dt, y + 2);
            g2.setColor(FRAME_COLORS[3]);
            g2.drawLine(x + 3, y + 3, x + dt, y + 3);
            g2.setColor(FRAME_COLORS[4]);
            g2.drawLine(x + 4, y + 4, x + dt, y + 4);
            g2.setColor(cr);
            g2.drawLine(x + dt, y, x + w, y);
            g2.setColor(ColorHelper.brighter(cr, 90.0));
            g2.drawLine(x + dt, y + 1, x + w - 1, y + 1);
            g2.setColor(ColorHelper.brighter(cr, 60.0));
            g2.drawLine(x + dt, y + 2, x + w - 2, y + 2);
            g2.setColor(ColorHelper.brighter(cr, 30.0));
            g2.drawLine(x + dt, y + 3, x + w - 3, y + 3);
            g2.setColor(cr);
            g2.drawLine(x + dt, y + 4, x + w - 4, y + 4);
            g2.setColor(FRAME_COLORS[0]);
            g2.drawLine(x + w - 22, y, x + w, y);
            g2.setColor(FRAME_COLORS[1]);
            g2.drawLine(x + w - 22, y + 1, x + w - 1, y + 1);
            g2.setColor(FRAME_COLORS[2]);
            g2.drawLine(x + w - 22, y + 2, x + w - 2, y + 2);
            g2.setColor(FRAME_COLORS[3]);
            g2.drawLine(x + w - 22, y + 3, x + w - 3, y + 3);
            g2.setColor(FRAME_COLORS[4]);
            g2.drawLine(x + w - 22, y + 4, x + w - 4, y + 4);
            g2.setColor(FRAME_COLORS[0]);
            g2.drawLine(x, y + h2, x + db, y + h2);
            g2.setColor(FRAME_COLORS[1]);
            g2.drawLine(x + 1, y + h2 - 1, x + db, y + h2 - 1);
            g2.setColor(FRAME_COLORS[2]);
            g2.drawLine(x + 2, y + h2 - 2, x + db, y + h2 - 2);
            g2.setColor(FRAME_COLORS[3]);
            g2.drawLine(x + 3, y + h2 - 3, x + db, y + h2 - 3);
            g2.setColor(FRAME_COLORS[4]);
            g2.drawLine(x + 4, y + h2 - 4, x + db, y + h2 - 4);
            g2.setColor(cr);
            g2.drawLine(x + db, y + h2, x + w, y + h2);
            g2.setColor(ColorHelper.brighter(cr, 30.0));
            g2.drawLine(x + db, y + h2 - 1, x + w - 1, y + h2 - 1);
            g2.setColor(ColorHelper.brighter(cr, 60.0));
            g2.drawLine(x + db, y + h2 - 2, x + w - 2, y + h2 - 2);
            g2.setColor(ColorHelper.brighter(cr, 90.0));
            g2.drawLine(x + db, y + h2 - 3, x + w - 3, y + h2 - 3);
            g2.setColor(cr);
            g2.drawLine(x + db, y + h2 - 4, x + w - 4, y + h2 - 4);
            g2.setColor(FRAME_COLORS[0]);
            g2.drawLine(x + w - 22, y + h2, x + w, y + h2);
            g2.setColor(FRAME_COLORS[1]);
            g2.drawLine(x + w - 22, y + h2 - 1, x + w - 1, y + h2 - 1);
            g2.setColor(FRAME_COLORS[2]);
            g2.drawLine(x + w - 22, y + h2 - 2, x + w - 2, y + h2 - 2);
            g2.setColor(FRAME_COLORS[3]);
            g2.drawLine(x + w - 22, y + h2 - 3, x + w - 3, y + h2 - 3);
            g2.setColor(FRAME_COLORS[4]);
            g2.drawLine(x + w - 22, y + h2 - 4, x + w - 4, y + h2 - 4);
        }
    }

    public static class RolloverToolButtonBorder
    implements Border,
    UIResource {
        private static final Color frameHiColor = ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 60.0);
        private static final Color frameLoColor = AbstractLookAndFeel.getFrameColor();
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w, int h2) {
            AbstractButton button = (AbstractButton)c2;
            ButtonModel model = button.getModel();
            if (model.isEnabled()) {
                if (model.isRollover()) {
                    JTattooUtilities.draw3DBorder(g2, frameHiColor, frameLoColor, x, y, w - 1, h2);
                    JTattooUtilities.draw3DBorder(g2, Color.white, frameHiColor, x + 1, y + 1, w - 2, h2 - 2);
                } else if (model.isPressed() && model.isArmed() || model.isSelected()) {
                    g2.setColor(frameHiColor);
                    g2.drawRect(x, y, w - 2, h2 - 1);
                } else {
                    g2.setColor(AbstractLookAndFeel.getFrameColor());
                    g2.drawRect(x, y, w - 2, h2 - 1);
                }
            } else {
                g2.setColor(frameHiColor);
                g2.drawRect(x, y, w - 2, h2 - 1);
            }
            g2.setColor(Color.white);
            g2.drawLine(w - 1, 0, w - 1, h2 - 1);
        }

        public Insets getBorderInsets(Component c2) {
            return new Insets(RolloverToolButtonBorder.insets.top, RolloverToolButtonBorder.insets.left, RolloverToolButtonBorder.insets.bottom, RolloverToolButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            borderInsets.left = RolloverToolButtonBorder.insets.left;
            borderInsets.top = RolloverToolButtonBorder.insets.top;
            borderInsets.right = RolloverToolButtonBorder.insets.right;
            borderInsets.bottom = RolloverToolButtonBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(4, 8, 4, 8);

        public void paintBorder(Component c2, Graphics g2, int x, int y, int w, int h2) {
            ColorUIResource cHi = AbstractLookAndFeel.getControlDarkShadow();
            Color cLo = ColorHelper.darker(cHi, 8.0);
            JTattooUtilities.draw3DBorder(g2, cHi, cLo, x, y, w, h2);
        }

        public Insets getBorderInsets(Component c2) {
            return insets;
        }

        public Insets getBorderInsets(Component c2, Insets borderInsets) {
            borderInsets.left = ButtonBorder.insets.left;
            borderInsets.top = ButtonBorder.insets.top;
            borderInsets.right = ButtonBorder.insets.right;
            borderInsets.bottom = ButtonBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

