/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.graphite;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseTabbedPaneUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class GraphiteTabbedPaneUI
extends BaseTabbedPaneUI {
    private Color[] sepColors = null;

    public static ComponentUI createUI(JComponent c2) {
        return new GraphiteTabbedPaneUI();
    }

    protected void installComponents() {
        this.simpleButtonBorder = true;
        super.installComponents();
    }

    protected Color getLoBorderColor(int tabIndex) {
        if (tabIndex == this.tabPane.getSelectedIndex() && this.tabPane.getBackgroundAt(tabIndex) instanceof ColorUIResource) {
            return AbstractLookAndFeel.getControlColorDark();
        }
        return AbstractLookAndFeel.getControlShadow();
    }

    protected Color[] getContentBorderColors(int tabPlacement) {
        if (this.sepColors == null) {
            this.sepColors = new Color[5];
            this.sepColors[0] = this.getLoBorderColor(0);
            this.sepColors[1] = AbstractLookAndFeel.getControlColorDark();
            this.sepColors[2] = ColorHelper.darker(AbstractLookAndFeel.getControlColorDark(), 4.0);
            this.sepColors[3] = ColorHelper.darker(AbstractLookAndFeel.getControlColorDark(), 8.0);
            this.sepColors[4] = ColorHelper.darker(AbstractLookAndFeel.getControlColorDark(), 12.0);
        }
        return this.sepColors;
    }

    protected Font getTabFont(boolean isSelected) {
        if (isSelected) {
            return super.getTabFont(isSelected).deriveFont(1);
        }
        return super.getTabFont(isSelected);
    }

    protected void paintText(Graphics g2, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        if (isSelected && this.tabPane.isEnabledAt(tabIndex) && this.tabPane.getBackgroundAt(tabIndex) instanceof ColorUIResource && this.getTextViewForTab(tabIndex) == null) {
            g2.setFont(font);
            ColorUIResource selColor = AbstractLookAndFeel.getTabSelectionForegroundColor();
            if (ColorHelper.getGrayValue(selColor) > 164) {
                g2.setColor(Color.black);
            } else {
                g2.setColor(Color.white);
            }
            int mnemIndex = -1;
            if (JTattooUtilities.getJavaVersion() >= 1.4) {
                mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            }
            JTattooUtilities.drawStringUnderlineCharAt(this.tabPane, g2, title, mnemIndex, textRect.x, textRect.y + 1 + metrics.getAscent());
        }
        super.paintText(g2, tabPlacement, font, metrics, tabIndex, title, textRect, isSelected);
    }

    protected void paintFocusIndicator(Graphics g2, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
        if (this.tabPane.isRequestFocusEnabled() && this.tabPane.hasFocus() && isSelected && tabIndex >= 0 && textRect.width > 8) {
            g2.setColor(AbstractLookAndFeel.getTheme().getFocusColor());
            BasicGraphicsUtils.drawDashedRect(g2, textRect.x - 4, textRect.y, textRect.width + 8, textRect.height);
            BasicGraphicsUtils.drawDashedRect(g2, textRect.x - 3, textRect.y + 1, textRect.width + 6, textRect.height - 2);
        }
    }
}

