/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.texture;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseButtonUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class TextureButtonUI
extends BaseButtonUI {
    public static ComponentUI createUI(JComponent c2) {
        return new TextureButtonUI();
    }

    protected void paintBackground(Graphics g2, AbstractButton b2) {
        if (AbstractLookAndFeel.getTheme().doDrawSquareButtons()) {
            super.paintBackground(g2, b2);
        } else {
            Graphics2D g2D = (Graphics2D)g2;
            Shape savedClip = g2.getClip();
            if (b2.getBorder() != null && b2.isBorderPainted() && b2.getBorder() instanceof UIResource) {
                int w = b2.getWidth();
                int h2 = b2.getHeight();
                Area clipArea = new Area(new RoundRectangle2D.Double(0.0, 0.0, w - 1, h2 - 1, 6.0, 6.0));
                clipArea.intersect(new Area(savedClip));
                g2D.setClip(clipArea);
            }
            super.paintBackground(g2, b2);
            g2D.setClip(savedClip);
        }
    }

    protected void paintIcon(Graphics g2, JComponent c2, Rectangle iconRect) {
        AbstractButton b2 = (AbstractButton)c2;
        Graphics2D g2D = (Graphics2D)g2;
        Composite savedComposite = g2D.getComposite();
        if (!b2.isContentAreaFilled()) {
            if (!b2.isEnabled()) {
                AlphaComposite alpha = AlphaComposite.getInstance(3, 0.6f);
                g2D.setComposite(alpha);
            } else {
                AlphaComposite alpha = AlphaComposite.getInstance(3, 0.9f);
                g2D.setComposite(alpha);
            }
        }
        super.paintIcon(g2, c2, iconRect);
        g2D.setComposite(savedComposite);
    }

    protected void paintText(Graphics g2, AbstractButton b2, Rectangle textRect, String text) {
        Graphics2D g2D = (Graphics2D)g2;
        Composite savedComposite = g2D.getComposite();
        ButtonModel model = b2.getModel();
        FontMetrics fm = JTattooUtilities.getFontMetrics(b2, g2, b2.getFont());
        int mnemIndex = JTattooUtilities.getJavaVersion() >= 1.4 ? b2.getDisplayedMnemonicIndex() : JTattooUtilities.findDisplayedMnemonicIndex(b2.getText(), model.getMnemonic());
        if (model.isEnabled()) {
            Object sc;
            int offs = 0;
            if (model.isArmed() && model.isPressed()) {
                offs = 1;
            }
            Color foreground = b2.getForeground();
            Color background = b2.getBackground();
            if (background instanceof ColorUIResource) {
                if (model.isPressed() && model.isArmed()) {
                    foreground = AbstractLookAndFeel.getTheme().getPressedForegroundColor();
                } else if (model.isRollover()) {
                    foreground = AbstractLookAndFeel.getTheme().getRolloverForegroundColor();
                }
            }
            if (AbstractLookAndFeel.getTheme().isTextShadowOn() && ColorHelper.getGrayValue(foreground) > 164) {
                AlphaComposite alpha = AlphaComposite.getInstance(3, 0.4f);
                g2D.setComposite(alpha);
                g2.setColor(Color.black);
                JTattooUtilities.drawStringUnderlineCharAt(b2, g2, text, mnemIndex, textRect.x + offs, textRect.y + offs + fm.getAscent() + 1);
                g2D.setComposite(savedComposite);
            } else if (!(model.isPressed() && model.isArmed() || !((sc = b2.getClientProperty("shadowColor")) instanceof Color))) {
                g2.setColor((Color)sc);
                JTattooUtilities.drawStringUnderlineCharAt(b2, g2, text, mnemIndex, textRect.x + 1, textRect.y + 1 + fm.getAscent());
            }
            g2.setColor(foreground);
            JTattooUtilities.drawStringUnderlineCharAt(b2, g2, text, mnemIndex, textRect.x + offs, textRect.y + offs + fm.getAscent());
        } else {
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.8f);
            g2D.setComposite(alpha);
            Color fc = b2.getForeground();
            if (ColorHelper.getGrayValue(fc) > 164) {
                fc = ColorHelper.brighter(AbstractLookAndFeel.getDisabledForegroundColor(), 40.0);
                g2.setColor(Color.black);
            } else {
                fc = AbstractLookAndFeel.getDisabledForegroundColor();
                g2.setColor(Color.white);
            }
            JTattooUtilities.drawStringUnderlineCharAt(b2, g2, text, mnemIndex, textRect.x, textRect.y + 1 + fm.getAscent());
            g2D.setComposite(savedComposite);
            g2.setColor(fc);
            JTattooUtilities.drawStringUnderlineCharAt(b2, g2, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
        }
    }

    protected void paintFocus(Graphics g2, AbstractButton b2, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (!AbstractLookAndFeel.getTheme().doShowFocusFrame()) {
            g2.setColor(AbstractLookAndFeel.getFocusColor());
            BasicGraphicsUtils.drawDashedRect(g2, 3, 2, b2.getWidth() - 6, b2.getHeight() - 5);
            BasicGraphicsUtils.drawDashedRect(g2, 4, 3, b2.getWidth() - 8, b2.getHeight() - 7);
        }
    }
}

