/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.texture;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseCheckBoxMenuItemUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import com.jtattoo.plaf.texture.TextureUtils;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class TextureCheckBoxMenuItemUI
extends BaseCheckBoxMenuItemUI {
    public static ComponentUI createUI(JComponent c2) {
        return new TextureCheckBoxMenuItemUI();
    }

    protected void paintBackground(Graphics g2, JComponent c2, int x, int y, int w, int h2) {
        JMenuItem mi = (JMenuItem)c2;
        ButtonModel model = mi.getModel();
        if (model.isArmed() || c2 instanceof JMenu && model.isSelected()) {
            TextureUtils.fillComponent(g2, c2, 4);
        } else if (!(mi.getBackground() instanceof ColorUIResource)) {
            super.paintBackground(g2, c2, x, y, w, h2);
        } else {
            TextureUtils.fillComponent(g2, c2, 7);
        }
    }

    protected void paintText(Graphics g2, JMenuItem menuItem, Rectangle textRect, String text) {
        if (!AbstractLookAndFeel.getTheme().isDarkTexture()) {
            super.paintText(g2, menuItem, textRect, text);
            return;
        }
        ButtonModel model = menuItem.getModel();
        FontMetrics fm = JTattooUtilities.getFontMetrics(menuItem, g2, menuItem.getFont());
        int mnemIndex = menuItem.getDisplayedMnemonicIndex();
        if (!menuItem.isArmed()) {
            g2.setColor(Color.black);
            JTattooUtilities.drawStringUnderlineCharAt(menuItem, g2, text, mnemIndex, textRect.x, textRect.y + fm.getAscent() - 1);
        }
        if (!model.isEnabled()) {
            g2.setColor(ColorHelper.brighter(AbstractLookAndFeel.getDisabledForegroundColor(), 40.0));
        } else if (menuItem.isArmed()) {
            g2.setColor(AbstractLookAndFeel.getMenuSelectionForegroundColor());
        } else {
            Color foreColor = menuItem.getForeground();
            if (foreColor instanceof UIResource) {
                foreColor = AbstractLookAndFeel.getMenuForegroundColor();
            }
            g2.setColor(foreColor);
        }
        JTattooUtilities.drawStringUnderlineCharAt(menuItem, g2, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
    }
}

