/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.texture;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.texture.TextureUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;

public class TexturePopupMenuSeparatorUI
extends BasicSeparatorUI {
    private static final Dimension size = new Dimension(8, 8);
    private static final Color[] colors = new Color[]{Color.black, new Color(164, 164, 164), new Color(48, 48, 48), new Color(128, 128, 128)};

    public static ComponentUI createUI(JComponent c2) {
        return new TexturePopupMenuSeparatorUI();
    }

    public void paint(Graphics g2, JComponent c2) {
        TextureUtils.fillComponent(g2, c2, 7);
        if (AbstractLookAndFeel.getTheme().getTextureSet().equals("Default")) {
            Graphics2D g2D = (Graphics2D)g2;
            Composite savedComposite = g2D.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.6f);
            g2D.setComposite(alpha);
            int w = c2.getWidth();
            this.drawLine(g2, 2, w, colors[0]);
            this.drawLine(g2, 3, w, colors[1]);
            this.drawLine(g2, 4, w, colors[2]);
            this.drawLine(g2, 5, w, colors[3]);
            g2D.setComposite(savedComposite);
        } else {
            Graphics2D g2D = (Graphics2D)g2;
            Composite savedComposite = g2D.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.6f);
            g2D.setComposite(alpha);
            if (AbstractLookAndFeel.getTheme().isDarkTexture()) {
                g2.setColor(Color.black);
            } else {
                g2.setColor(Color.gray);
            }
            g2.drawLine(1, 3, c2.getWidth() - 2, 3);
            alpha = AlphaComposite.getInstance(3, 0.3f);
            g2D.setComposite(alpha);
            g2.setColor(Color.white);
            g2.drawLine(1, 4, c2.getWidth() - 2, 4);
            g2D.setComposite(savedComposite);
        }
    }

    private void drawLine(Graphics g2, int y, int w, Color color) {
        int dx;
        g2.setColor(color);
        int dw = 3;
        for (int x = dx = 2; x < w; x += dx + dw) {
            g2.drawLine(x, y, x + dw - 1, y);
        }
    }

    public Dimension getPreferredSize(JComponent c2) {
        return size;
    }
}

