/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODBorders;
import com.nilo.plaf.nimrod.NimRODUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.LookAndFeel;
import javax.swing.Popup;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class NimRODPopupMenuUI
extends BasicPopupMenuUI {
    private static Robot robot = null;
    private static Kernel kernel = null;
    private BufferedImage fondo = null;
    private BufferedImage blurFondo = null;
    private MiPL mipl;
    private static final int MATRIX = 3;

    public static ComponentUI createUI(JComponent jComponent) {
        if (robot == null) {
            try {
                robot = new Robot();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (kernel == null) {
            int n2;
            float[] fArray = new float[9];
            for (n2 = 0; n2 < fArray.length; ++n2) {
                fArray[n2] = 0.1f;
            }
            n2 = 2;
            fArray[n2 * n2] = 0.2f;
            kernel = new Kernel(3, 3, fArray);
        }
        return new NimRODPopupMenuUI();
    }

    @Override
    public void installDefaults() {
        super.installDefaults();
        this.popupMenu.setBorder(NimRODBorders.getPopupMenuBorder());
        this.popupMenu.setOpaque(false);
    }

    @Override
    public void uninstallDefaults() {
        super.uninstallDefaults();
        LookAndFeel.installBorder(this.popupMenu, "PopupMenu.border");
        this.popupMenu.setOpaque(true);
    }

    @Override
    public void installListeners() {
        super.installListeners();
        this.mipl = new MiPL(this.popupMenu);
        this.popupMenu.addPopupMenuListener(this.mipl);
    }

    @Override
    public void uninstallListeners() {
        super.uninstallListeners();
        this.popupMenu.removePopupMenuListener(this.mipl);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        if (this.blurFondo != null) {
            graphics.drawImage(this.blurFondo, 0, 0, null);
        }
        if (NimRODUtils.getMenuOpacity() > 5) {
            Color color = new Color(jComponent.getBackground().getRed(), jComponent.getBackground().getGreen(), jComponent.getBackground().getBlue(), NimRODUtils.getMenuOpacity());
            graphics.setColor(color);
            graphics.fillRect(0, 0, jComponent.getWidth() - 4, jComponent.getHeight() - 4);
        }
    }

    protected BufferedImage pillaFondo(JPopupMenu jPopupMenu, Rectangle rectangle, int n2) {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = robot.createScreenCapture(rectangle);
        }
        catch (Throwable throwable) {
            bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 2);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.setColor(NimRODUtils.getColorAlfa(jPopupMenu.getBackground(), n2));
            graphics.fillRect(0, 0, rectangle.width, rectangle.height);
            graphics.dispose();
        }
        return bufferedImage;
    }

    @Override
    public Popup getPopup(JPopupMenu jPopupMenu, int n2, int n3) {
        Dimension dimension = jPopupMenu.getPreferredSize();
        Rectangle rectangle = new Rectangle(n2, n3, dimension.width, dimension.height);
        this.fondo = this.pillaFondo(jPopupMenu, rectangle, 0);
        if (NimRODUtils.getMenuOpacity() > 250) {
            this.blurFondo = this.fondo;
        } else {
            Rectangle rectangle2 = new Rectangle(n2 - 3, n3 - 3, dimension.width + 6, dimension.height + 6);
            BufferedImage bufferedImage = this.pillaFondo(jPopupMenu, rectangle2, NimRODUtils.getMenuOpacity());
            this.blurFondo = new BufferedImage(dimension.width, dimension.height, 2);
            BufferedImage bufferedImage2 = bufferedImage.getSubimage(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            ConvolveOp convolveOp = new ConvolveOp(kernel, 1, null);
            convolveOp.filter(bufferedImage, bufferedImage2);
            convolveOp.filter(bufferedImage2, bufferedImage);
            convolveOp.filter(bufferedImage, bufferedImage2);
            Graphics graphics = this.blurFondo.getGraphics();
            graphics.drawImage(this.fondo, 0, 0, null);
            graphics.drawImage(bufferedImage2.getSubimage(3, 3, dimension.width - 5, dimension.height - 5), 0, 0, null);
        }
        return super.getPopup(jPopupMenu, n2, n3);
    }

    private class MiPL
    implements PopupMenuListener {
        JPopupMenu papi;

        public MiPL(JPopupMenu jPopupMenu) {
            this.papi = jPopupMenu;
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            if (NimRODPopupMenuUI.this.fondo == null) {
                return;
            }
            Graphics graphics = this.papi.getRootPane().getGraphics();
            Point point = this.papi.getLocationOnScreen();
            Point point2 = this.papi.getRootPane().getLocationOnScreen();
            graphics.drawImage(NimRODPopupMenuUI.this.fondo, point.x - point2.x, point.y - point2.y, null);
            NimRODPopupMenuUI.this.fondo = null;
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }
    }
}

