/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import com.nilo.plaf.nimrod.NimRODUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class NimRODTabbedPaneUI
extends BasicTabbedPaneUI {
    private Color selectColor;
    private int inclTab = 12;
    private int anchoFocoH = 0;
    private int anchoCarpetas = 18;
    private int rollover = -1;
    private int antRollover = -1;
    private MiML miml;
    private Polygon shape;

    public static ComponentUI createUI(JComponent jComponent) {
        return new NimRODTabbedPaneUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.rollover = -1;
        this.selectColor = NimRODLookAndFeel.getFocusColor();
        this.tabAreaInsets.right = this.anchoCarpetas;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.miml = new MiML();
        this.tabPane.addMouseMotionListener(this.miml);
        this.tabPane.addMouseListener(this.miml);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.tabPane.removeMouseMotionListener(this.miml);
        this.tabPane.removeMouseListener(this.miml);
    }

    @Override
    protected void layoutLabel(int n2, FontMetrics fontMetrics, int n3, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl) {
        Rectangle rectangle4 = new Rectangle(rectangle);
        rectangle4.width -= this.inclTab;
        super.layoutLabel(n2, fontMetrics, n3, string, icon, rectangle4, rectangle2, rectangle3, bl);
    }

    @Override
    protected void paintTabArea(Graphics graphics, int n2, int n3) {
        if (this.runCount > 1) {
            int[] nArray = new int[this.runCount];
            for (int i2 = 0; i2 < this.runCount; ++i2) {
                nArray[i2] = this.rects[this.tabRuns[i2]].y + (n2 == 1 ? this.maxTabHeight : 0);
            }
            Arrays.sort(nArray);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (n2 == 1) {
                int n4 = this.runCount;
                int n5 = 0;
                while (n5 < nArray.length - 1) {
                    Polygon polygon = new Polygon();
                    polygon.addPoint(0, nArray[n5]);
                    polygon.addPoint(this.tabPane.getWidth() - 2 * n4 - 2, nArray[n5]);
                    polygon.addPoint(this.tabPane.getWidth() - 2 * n4, nArray[n5] + 3);
                    if (n5 < nArray.length - 2) {
                        polygon.addPoint(this.tabPane.getWidth() - 2 * n4, nArray[n5 + 1]);
                        polygon.addPoint(0, nArray[n5 + 1]);
                    } else {
                        polygon.addPoint(this.tabPane.getWidth() - 2 * n4, nArray[n5] + this.rects[n3].height);
                        polygon.addPoint(0, nArray[n5] + this.rects[n3].height);
                    }
                    polygon.addPoint(0, nArray[n5]);
                    graphics2D.setColor(this.hazAlfa(n4));
                    graphics2D.fillPolygon(polygon);
                    graphics2D.setColor(this.darkShadow.darker());
                    graphics2D.drawPolygon(polygon);
                    ++n5;
                    --n4;
                }
            } else {
                int n6 = 0;
                int n7 = 0;
                while (n7 < nArray.length - 1) {
                    Polygon polygon = new Polygon();
                    polygon.addPoint(0, nArray[n7]);
                    polygon.addPoint(this.tabPane.getWidth() - 2 * n6 - 1, nArray[n7]);
                    polygon.addPoint(this.tabPane.getWidth() - 2 * n6 - 1, nArray[n7 + 1] - 3);
                    polygon.addPoint(this.tabPane.getWidth() - 2 * n6 - 3, nArray[n7 + 1]);
                    polygon.addPoint(0, nArray[n7 + 1]);
                    polygon.addPoint(0, nArray[n7]);
                    graphics2D.setColor(this.hazAlfa(n6 + 2));
                    graphics2D.fillPolygon(polygon);
                    graphics2D.setColor(this.darkShadow.darker());
                    graphics2D.drawPolygon(polygon);
                    ++n7;
                    ++n6;
                }
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }
        super.paintTabArea(graphics, n2, n3);
    }

    @Override
    protected void paintTabBackground(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        GradientPaint gradientPaint;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int[] nArray = null;
        int[] nArray2 = null;
        switch (n2) {
            case 2: {
                nArray = new int[]{n4, n4, n4 + n6, n4 + n6, n4};
                nArray2 = new int[]{n5, n5 + n7 - 3, n5 + n7 - 3, n5, n5};
                gradientPaint = new GradientPaint(n4, n5, NimRODUtils.getBrillo(), n4, n5 + n7, NimRODUtils.getSombra());
                break;
            }
            case 4: {
                nArray = new int[]{n4, n4, n4 + n6 - 2, n4 + n6 - 2, n4};
                nArray2 = new int[]{n5, n5 + n7 - 3, n5 + n7 - 3, n5, n5};
                gradientPaint = new GradientPaint(n4, n5, NimRODUtils.getBrillo(), n4, n5 + n7, NimRODUtils.getSombra());
                break;
            }
            case 3: {
                nArray = new int[]{n4, n4, n4 + 3, n4 + n6 - this.inclTab - 6, n4 + n6 - this.inclTab - 2, n4 + n6 - this.inclTab, n4 + n6 - 3, n4};
                nArray2 = new int[]{n5, n5 + n7 - 3, n5 + n7, n5 + n7, n5 + n7 - 1, n5 + n7 - 3, n5, n5};
                gradientPaint = new GradientPaint(n4, n5, NimRODUtils.getBrillo(), n4, n5 + n7, NimRODUtils.getSombra());
                break;
            }
            default: {
                nArray = new int[]{n4, n4, n4 + 3, n4 + n6 - this.inclTab - 6, n4 + n6 - this.inclTab - 2, n4 + n6 - this.inclTab, n4 + n6, n4};
                nArray2 = new int[]{n5 + n7, n5 + 3, n5, n5, n5 + 1, n5 + 3, n5 + n7, n5 + n7};
                gradientPaint = new GradientPaint(n4, n5, NimRODUtils.getBrillo(), n4, n5 + n7, NimRODUtils.getSombra());
            }
        }
        this.shape = new Polygon(nArray, nArray2, nArray.length);
        if (bl) {
            graphics2D.setColor(this.selectColor);
        } else {
            graphics2D.setColor(this.tabPane.getBackgroundAt(n3));
        }
        graphics2D.fill(this.shape);
        if (this.runCount > 1) {
            graphics2D.setColor(this.hazAlfa(this.getRunForTab(this.tabPane.getTabCount(), n3) - 1));
            graphics2D.fill(this.shape);
        }
        if (n3 == this.rollover) {
            graphics2D.setColor(NimRODUtils.getRolloverColor());
            graphics2D.fill(this.shape);
        }
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(this.shape);
        graphics2D.setColor(NimRODUtils.getSombra());
        graphics2D.draw(this.shape);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    @Override
    protected int calculateTabWidth(int n2, int n3, FontMetrics fontMetrics) {
        return 8 + this.inclTab + super.calculateTabWidth(n2, n3, fontMetrics);
    }

    @Override
    protected int calculateTabHeight(int n2, int n3, int n4) {
        if (n2 == 2 || n2 == 4) {
            return super.calculateTabHeight(n2, n3, n4);
        }
        return this.anchoFocoH + super.calculateTabHeight(n2, n3, n4);
    }

    @Override
    protected void paintTabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
    }

    @Override
    protected void paintFocusIndicator(Graphics graphics, int n2, Rectangle[] rectangleArray, int n3, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        if (this.tabPane.hasFocus() && bl) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.setColor(UIManager.getColor("ScrollBar.thumbShadow"));
            graphics2D.drawPolygon(this.shape);
            graphics2D.setStroke(stroke);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        }
    }

    protected Color hazAlfa(int n2) {
        int n3 = 0;
        if (n2 >= 0) {
            n3 = 50 + (n2 > 7 ? 70 : 8 * n2);
        }
        return new Color(0, 0, 0, n3);
    }

    public class MiML
    extends MouseAdapter
    implements MouseMotionListener {
        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            NimRODTabbedPaneUI.this.rollover = -1;
            NimRODTabbedPaneUI.this.tabPane.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            NimRODTabbedPaneUI.this.rollover = NimRODTabbedPaneUI.this.tabForCoordinate(NimRODTabbedPaneUI.this.tabPane, mouseEvent.getX(), mouseEvent.getY());
            if (NimRODTabbedPaneUI.this.rollover == -1 && NimRODTabbedPaneUI.this.antRollover == NimRODTabbedPaneUI.this.rollover) {
                return;
            }
            NimRODTabbedPaneUI.this.tabPane.repaint();
            NimRODTabbedPaneUI.this.antRollover = NimRODTabbedPaneUI.this.rollover;
        }
    }
}

