/*
 * Decompiled with CFR 0.152.
 */
package com.pagosoft.plaf;

import com.pagosoft.plaf.PgsComboBoxButtonUI;
import com.pagosoft.plaf.PgsLookAndFeel;
import com.pagosoft.plaf.PgsUtils;
import com.pagosoft.plaf.RolloverButtonListener;
import com.pagosoft.plaf.ToolBarButtonUI;
import com.pagosoft.swing.ColorUtils;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.metal.MetalButtonUI;

public class PgsButtonUI
extends MetalButtonUI
implements ActionListener {
    private static PgsButtonUI INSTANCE = new PgsButtonUI();
    private Timer defaultButtonTimer = new Timer(50, this);
    private WeakReference defaultButtonRef;
    private int defaultButtonAlpha;
    private boolean defaultButtonAlphaDir;

    public static ComponentUI createUI(JComponent jComponent) {
        if (jComponent.getParent() instanceof JToolBar) {
            return ToolBarButtonUI.createUI(jComponent);
        }
        return INSTANCE;
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        abstractButton.putClientProperty("rolloverBackground", UIManager.getColor("Button.rolloverBackground"));
        abstractButton.putClientProperty("pgs.isFlat", UIManager.get("Button.isFlat"));
        abstractButton.putClientProperty("gradientStart", UIManager.get("Button.gradientStart"));
        abstractButton.putClientProperty("gradientEnd", UIManager.get("Button.gradientEnd"));
        abstractButton.putClientProperty("rollover.gradientStart", UIManager.get("Button.rolloverGradientStart"));
        abstractButton.putClientProperty("rollover.gradientEnd", UIManager.get("Button.rolloverGradientEnd"));
        abstractButton.putClientProperty("selected.gradientStart", UIManager.get("Button.selectedGradientStart"));
        abstractButton.putClientProperty("selected.gradientEnd", UIManager.get("Button.selectedGradientEnd"));
    }

    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return new RolloverButtonListener(abstractButton);
    }

    protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        if (abstractButton.isFocusPainted() && !(abstractButton instanceof PgsComboBoxButtonUI)) {
            int n2 = 3;
            int n3 = abstractButton.getWidth() - n2 * 2;
            int n4 = abstractButton.getHeight() - n2 * 2;
            graphics.setColor(this.getFocusColor());
            PgsUtils.drawRoundRect(graphics, n2, n2, n3 - 1, n4 - 1, 3, 3);
        }
    }

    public void update(Graphics graphics, JComponent jComponent) {
        JButton jButton = (JButton)jComponent;
        if (jComponent.isOpaque() && jButton.isContentAreaFilled()) {
            if (Boolean.TRUE.equals(jComponent.getClientProperty("pgs.isFlat")) || !jButton.isEnabled()) {
                graphics.setColor(jComponent.isEnabled() && jButton.getModel().isRollover() ? (Color)jComponent.getClientProperty("rolloverBackground") : jComponent.getBackground());
                graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
            } else {
                graphics.setColor(jComponent.isEnabled() && jButton.getModel().isRollover() ? (Color)jComponent.getClientProperty("rolloverBackground") : jComponent.getBackground());
                graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
                if (jComponent.isEnabled() && jButton.getModel().isRollover()) {
                    PgsUtils.drawGradient(graphics, jComponent, "rollover");
                } else {
                    PgsUtils.drawGradient(graphics, jComponent);
                }
            }
            if (jButton.isDefaultButton() && PgsUtils.hasFocus(jButton.getTopLevelAncestor())) {
                JButton jButton2 = this.defaultButtonRef == null ? null : (JButton)this.defaultButtonRef.get();
                if (jButton != jButton2) {
                    if (jButton2 == null) {
                        jButton2 = jButton;
                        this.defaultButtonRef = new WeakReference<JButton>(jButton);
                        this.defaultButtonTimer.start();
                    } else {
                        JButton jButton3 = jButton2;
                        jButton2 = jButton;
                        this.defaultButtonRef = new WeakReference<JButton>(jButton);
                        jButton3.repaint();
                    }
                    this.defaultButtonAlpha = 10;
                    this.defaultButtonAlphaDir = true;
                }
                PgsUtils.drawButtonBorder(graphics, 1, 1, jButton.getWidth() - 3, jButton.getHeight() - 3, PgsUtils.rolloverBorderStroke, ColorUtils.getTranslucentColor(PgsLookAndFeel.getPrimaryControlShadow(), this.defaultButtonAlpha));
            }
        }
        super.paint(graphics, jComponent);
    }

    protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
        if (abstractButton.isOpaque() && abstractButton.isContentAreaFilled()) {
            if (Boolean.TRUE.equals(abstractButton.getClientProperty("pgs.isFlat"))) {
                graphics.setColor(this.getSelectColor());
                graphics.fillRect(0, 0, abstractButton.getWidth(), abstractButton.getHeight());
            } else {
                PgsUtils.drawGradient(graphics, abstractButton, "selected");
            }
        }
    }

    protected void paintText(Graphics graphics, JComponent jComponent, Rectangle rectangle, String string) {
        PgsUtils.installAntialiasing(graphics);
        super.paintText(graphics, jComponent, rectangle, string);
        PgsUtils.uninstallAntialiasing(graphics);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JButton jButton = (JButton)this.defaultButtonRef.get();
        if (jButton == null && this.defaultButtonTimer.isRunning()) {
            this.defaultButtonTimer.stop();
            this.defaultButtonRef = null;
            return;
        }
        this.defaultButtonAlpha += this.defaultButtonAlphaDir ? 10 : -10;
        if (this.defaultButtonAlpha == 200 || this.defaultButtonAlpha == 10) {
            this.defaultButtonAlphaDir = !this.defaultButtonAlphaDir;
        }
        jButton.repaint();
    }
}

