/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines.javasound;

import com.sun.j3d.audioengines.javasound.JSChannel;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;

class JSClip
extends JSChannel {
    Clip line;
    Clip otherChannel = null;
    Clip reverbChannel = null;

    JSClip() {
    }

    DataLine initDataLine(AudioInputStream audioInputStream) {
        try {
            Object object;
            this.audioFormat = audioInputStream.getFormat();
            if (this.audioFormat.getEncoding() == AudioFormat.Encoding.ULAW || this.audioFormat.getEncoding() == AudioFormat.Encoding.ALAW) {
                object = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.audioFormat.getSampleRate(), this.audioFormat.getSampleSizeInBits() * 2, this.audioFormat.getChannels(), this.audioFormat.getFrameSize() * 2, this.audioFormat.getFrameRate(), true);
                audioInputStream = AudioSystem.getAudioInputStream((AudioFormat)object, audioInputStream);
                this.audioFormat = object;
            }
            object = new DataLine.Info(Clip.class, this.audioFormat);
            this.line = (Clip)AudioSystem.getLine((Line.Info)object);
            this.line.open(audioInputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return this.line;
    }

    boolean startSamples(int n2, float f2, float f3, int n3, int n4) {
        if (this.otherChannel == null || this.reverbChannel == null) {
            this.startSample(n2, f2, n3);
        }
        if (this.ais == null) {
            return false;
        }
        Clip clip = this.line;
        Clip clip2 = this.otherChannel;
        double d2 = 0.0039;
        double d3 = f2;
        double d4 = f3;
        this.startTime = System.currentTimeMillis();
        try {
            this.line.setLoopPoints(0, -1);
            this.line.loop(n2);
            this.line.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.startTime = 0L;
            return false;
        }
        return true;
    }

    boolean startSample(int n2, float f2, int n3) {
        this.line.setFramePosition(0);
        this.line.setLoopPoints(0, -1);
        this.line.loop(n2);
        this.line.start();
        return true;
    }

    int stopSample() {
        this.line.stop();
        this.startTime = 0L;
        return 0;
    }

    int stopSamples() {
        this.line.stop();
        this.startTime = 0L;
        return 0;
    }

    public void update(LineEvent lineEvent) {
        if (lineEvent.getType().equals(LineEvent.Type.STOP)) {
            this.line.close();
        } else if (lineEvent.getType().equals(LineEvent.Type.CLOSE)) {
            // empty if block
        }
    }
}

