/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.audioengines.javasound;

import com.sun.j3d.audioengines.AuralParameters;
import com.sun.j3d.audioengines.javasound.JSPositionalSample;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

class JSDirectionalSample
extends JSPositionalSample {
    Vector3f xformDirection = new Vector3f(0.0f, 0.0f, 1.0f);

    void setXformedDirection() {
        if (!this.getVWrldXfrmFlag()) {
            this.xformDirection.set(this.direction);
        } else {
            this.vworldXfrm.transform(this.direction, this.xformDirection);
        }
    }

    double intersectEllipse(double d2, double d3) {
        Vector3f vector3f = this.direction;
        Vector3f vector3f2 = this.sourceToCenterEar;
        if (vector3f == null || vector3f2 == null) {
            return -1.0;
        }
        double d4 = vector3f2.dot(vector3f) / (vector3f2.length() * vector3f.length());
        double d5 = (float)Math.acos(d4);
        double d6 = d3 + d2;
        double d7 = Math.tan(d5);
        double d8 = 1.0 / (4.0 / (d6 * d6) + d7 * d7 / (d3 * d2));
        double d9 = Math.sqrt(d8);
        double d10 = d7 * d9;
        double d11 = d10 * d10;
        float f2 = (float)Math.sqrt(d8 + d11);
        return f2;
    }

    float findFactor(double d2, double[] dArray, float[] fArray, double[] dArray2, float[] fArray2) {
        int n2;
        if (dArray2 == null || fArray2 == null) {
            return this.findFactor(d2, dArray, fArray);
        }
        if (dArray == null || fArray == null) {
            return -1.0f;
        }
        int n3 = dArray.length;
        if (n3 < 2) {
            return -1.0f;
        }
        int n4 = n3 - 1;
        if (d2 >= dArray[n4]) {
            return fArray[n4];
        }
        if (d2 <= dArray2[0]) {
            return fArray2[0];
        }
        double[] dArray3 = new double[n3];
        float[] fArray3 = new float[n3];
        boolean[] blArray = new boolean[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            blArray[n2] = false;
        }
        n2 = 0;
        int n5 = -1;
        int n6 = 0;
        int n7 = n4;
        while (n6 < n7 - 1) {
            if (!blArray[n6]) {
                dArray3[n6] = this.intersectEllipse(dArray[n6], dArray2[n6]);
                if (dArray3[n6] >= 0.0) {
                    blArray[n6] = true;
                } else {
                    dArray3[n6] = (dArray2[n6] + dArray[n6]) * 0.5;
                    blArray[n6] = true;
                }
            }
            if (!blArray[n7]) {
                dArray3[n7] = this.intersectEllipse(dArray[n7], dArray2[n7]);
                if (dArray3[n7] >= 0.0) {
                    blArray[n7] = true;
                } else {
                    dArray3[n7] = (dArray2[n7] + dArray[n7]) * 0.5;
                    blArray[n7] = true;
                }
            }
            if (dArray3[n6] >= d2) {
                if (n6 == 0 || d2 < dArray3[n6]) {
                    // empty if block
                }
                n2 = 1;
                n5 = n6;
                break;
            }
            if (dArray3[n7] <= d2) {
                if (n7 == n4 || d2 > dArray3[n7]) {
                    // empty if block
                }
                n2 = 1;
                n5 = n7;
                break;
            }
            if (!(d2 > dArray3[n6]) || !(d2 < dArray3[n7])) continue;
            int n8 = n6 + (n7 - n6) / 2;
            if (d2 <= dArray3[n8]) {
                n7 = n8;
                continue;
            }
            n6 = n8;
        }
        if (n2 != 0 && n5 >= 0) {
            double d3 = (dArray3[n5] - dArray2[n5]) / (dArray[n5] - dArray2[n5]) * (double)(fArray[n5] - fArray2[n5]) + (double)fArray2[n5];
            return (float)d3;
        }
        double d4 = 1.0;
        double d5 = 0.0;
        d4 = (dArray3[n7] - dArray2[n7]) / (dArray[n7] - dArray2[n7]) * (double)(fArray[n7] - fArray2[n7]) + (double)fArray2[n7];
        d5 = (dArray3[n6] - dArray2[n6]) / (dArray[n6] - dArray2[n6]) * (double)(fArray[n6] - fArray2[n6]) + (double)fArray2[n6];
        double d6 = (d2 - dArray3[n6]) / (dArray3[n7] - dArray3[n6]) * (d4 - d5) + (double)fArray3[n6];
        return (float)d6;
    }

    float calculateDistanceAttenuation(float f2) {
        float f3 = this.findFactor(f2, this.attenuationDistance, this.attenuationGain, this.backAttenuationDistance, this.backAttenuationGain);
        if (f3 < 0.0f) {
            return 1.0f;
        }
        return f3;
    }

    float calculateAngularGain() {
        float f2 = this.findAngularOffset();
        float f3 = this.findFactor(f2, this.angularDistance, this.angularGain);
        if (f3 < 0.0f) {
            return 1.0f;
        }
        return f3;
    }

    float findAngularOffset() {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Point3f point3f = this.positions[this.currentIndex];
        Point3f point3f2 = this.centerEars[this.currentIndex];
        vector3f.x = point3f2.x - point3f.x;
        vector3f.y = point3f2.y - point3f.y;
        vector3f.z = point3f2.z - point3f.z;
        vector3f.normalize();
        vector3f2.normalize(this.direction);
        float f2 = vector3f.dot(vector3f2);
        float f3 = (float)Math.acos(f2);
        return f3;
    }

    void calculateFilter(float f2, AuralParameters auralParameters) {
        float f3 = 44100.0f;
        float f4 = 44100.0f;
        int n2 = auralParameters.getDistanceFilterLength();
        int n3 = auralParameters.getDistanceFilterType();
        boolean bl = false;
        boolean bl2 = false;
        if (n3 == -1 && n2 > 0) {
            double[] dArray = new double[n2];
            float[] fArray = new float[n2];
            auralParameters.getDistanceFilter(dArray, fArray);
            float f5 = this.findAngularOffset();
            f3 = this.findFactor(f5, this.angularDistance, this.angularFilterCutoff);
            bl = !(f3 < 0.0f);
        } else {
            bl = false;
            f3 = -1.0f;
        }
        n2 = this.angularDistance.length;
        n3 = this.angularFilterType;
        if (n3 != -1 && n2 > 0) {
            f4 = this.findFactor(f2, this.angularDistance, this.angularFilterCutoff);
            bl2 = !(f4 < 0.0f);
        } else {
            bl2 = false;
            f4 = -1.0f;
        }
        boolean bl3 = this.filterFlag = bl || bl2;
        this.filterFreq = f3 < 0.0f ? f4 : (f4 < 0.0f ? f3 : Math.min(f3, f4));
    }
}

