/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

class ImageScaler {
    int origW;
    int origH;
    Image origImage;

    ImageScaler(Image image, int n2, int n3) {
        this.origImage = image;
        this.origW = n2;
        this.origH = n3;
    }

    ImageScaler(BufferedImage bufferedImage) {
        this.origImage = bufferedImage;
        this.origW = bufferedImage.getWidth();
        this.origH = bufferedImage.getHeight();
    }

    int getClosestPowerOf2(int n2) {
        if (n2 < 1) {
            return n2;
        }
        int n3 = 1;
        for (int i2 = 1; i2 < 20; ++i2) {
            if (n2 >= (n3 *= 2)) continue;
            int n4 = n3 / 2;
            if (n3 - n2 > n2 - n4) {
                return n4;
            }
            return n3;
        }
        return 1;
    }

    Image getScaledImage() {
        int n2 = this.getClosestPowerOf2(this.origW);
        int n3 = this.getClosestPowerOf2(this.origH);
        if (n2 == this.origW && n3 == this.origH) {
            return this.origImage;
        }
        Image image = null;
        if (this.origImage instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)this.origImage;
            image = new BufferedImage(n2, n3, bufferedImage.getType());
            BufferedImage bufferedImage2 = (BufferedImage)image;
            float f2 = (float)this.origW / (float)n2;
            float f3 = (float)this.origH / (float)n3;
            int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            int[] nArray2 = ((DataBufferInt)bufferedImage2.getRaster().getDataBuffer()).getData();
            for (int i2 = 0; i2 < n3; ++i2) {
                for (int i3 = 0; i3 < n2; ++i3) {
                    int n4 = Math.min(this.origH - 1, (int)((float)i2 * f3 + 0.5f));
                    int n5 = Math.min(this.origW - 1, (int)((float)i3 * f2 + 0.5f));
                    nArray2[i2 * n2 + i3] = nArray[n4 * this.origW + n5];
                }
            }
        } else {
            image = this.origImage.getScaledInstance(n2, n3, 1);
        }
        return image;
    }
}

