/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.lw3d.LWOBFileReader;
import com.sun.j3d.loaders.lw3d.LwoSurface;
import com.sun.j3d.loaders.lw3d.ParserObject;
import com.sun.j3d.loaders.lw3d.ShapeHolder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

class LwoParser
extends ParserObject {
    LWOBFileReader theReader;
    int currLength;
    float[] coordsArray;
    float[] normalCoordsArray;
    int[] facetIndicesArray;
    int[] facetSizesArray;
    int[] normalIndicesArray;
    int red = 255;
    int green = 255;
    int blue = 255;
    float diffuse = 0.0f;
    float specular = 0.0f;
    float transparency = 0.0f;
    float luminosity = 0.0f;
    int gloss = 128;
    Vector surfNameList = null;
    Vector surfaceList = new Vector(200);
    Vector shapeList = new Vector(200);

    LwoParser(String string, int n2) throws FileNotFoundException {
        super(n2);
        this.debugOutputLn(1, "parser()");
        long l2 = System.currentTimeMillis();
        this.theReader = new LWOBFileReader(string);
        this.debugOutputLn(32, " file opened in " + (System.currentTimeMillis() - l2));
        this.parseFile();
    }

    LwoParser(URL uRL, int n2) throws FileNotFoundException {
        super(n2);
        this.debugOutputLn(1, "parser()");
        try {
            long l2 = System.currentTimeMillis();
            this.theReader = new LWOBFileReader(uRL);
            this.debugOutputLn(32, " file opened in " + (System.currentTimeMillis() - l2));
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(uRL.toString());
        }
        this.parseFile();
    }

    int skipDetailPolygons(int n2) throws ParsingErrorException {
        this.debugOutputLn(1, "skipDetailPolygons(), numPolys = " + n2);
        int n3 = 0;
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.debugOutputLn(2, "polyNum = " + i2);
                int n4 = this.theReader.getShortInt();
                this.theReader.skip(n4 * 2 + 2);
                n3 += n4 * 2 + 4;
            }
        }
        catch (IOException iOException) {
            this.debugOutputLn(16, "Exception in reading detail polys: " + iOException);
            throw new ParsingErrorException(iOException.getMessage());
        }
        return n3;
    }

    ShapeHolder getAppropriateShape(int n2, int n3) {
        Enumeration enumeration = this.shapeList.elements();
        while (enumeration.hasMoreElements()) {
            ShapeHolder shapeHolder = (ShapeHolder)enumeration.nextElement();
            if (shapeHolder.numSurf != n2 || shapeHolder.numVerts != n3 && (shapeHolder.numVerts <= 3 || n3 <= 3)) continue;
            return shapeHolder;
        }
        return null;
    }

    void getPols(int n2) {
        this.debugOutputLn(1, "getPols(len), len = " + n2);
        int n3 = 0;
        int n4 = -1;
        int n5 = 0;
        Vector<Integer> vector = new Vector<Integer>(n2 / 6);
        int[] nArray = new int[n2 / 2];
        ShapeHolder shapeHolder = new ShapeHolder(this.debugPrinter.getValidOutput());
        this.debugOutputLn(2, "new shape = " + shapeHolder);
        shapeHolder.coordsArray = this.coordsArray;
        shapeHolder.facetSizesList = vector;
        shapeHolder.facetIndicesArray = nArray;
        this.shapeList.addElement(shapeHolder);
        boolean bl = true;
        while (n3 < n2) {
            int n6;
            int n7 = this.theReader.getShortInt();
            n3 += 2;
            int[] nArray2 = new int[n7];
            for (n6 = 0; n6 < n7; ++n6) {
                nArray2[n6] = this.theReader.getShortInt();
                n3 += 2;
            }
            n6 = this.theReader.getShortInt();
            n3 += 2;
            long l2 = 0L;
            long l3 = 0L;
            if (!(bl || n6 == n5 && (n7 == n4 || n4 >= 3 && n7 >= 3))) {
                shapeHolder = this.getAppropriateShape(n6, n7);
                if (shapeHolder == null) {
                    vector = new Vector<Integer>(n2 / 6);
                    nArray = new int[n2 / 2];
                    shapeHolder = new ShapeHolder(this.debugPrinter.getValidOutput());
                    shapeHolder.coordsArray = this.coordsArray;
                    shapeHolder.facetSizesList = vector;
                    shapeHolder.facetIndicesArray = nArray;
                    shapeHolder.numSurf = n6;
                    shapeHolder.numVerts = n7;
                    this.shapeList.addElement(shapeHolder);
                } else {
                    vector = shapeHolder.facetSizesList;
                    nArray = shapeHolder.facetIndicesArray;
                }
            } else {
                shapeHolder.numSurf = n6;
                shapeHolder.numVerts = n7;
            }
            n4 = n7;
            n5 = n6;
            vector.addElement(new Integer(n7));
            boolean bl2 = false;
            System.arraycopy(nArray2, 0, nArray, shapeHolder.currentNumIndices, n7);
            shapeHolder.currentNumIndices += n7;
            if (n6 < 0) {
                int n8 = this.theReader.getShortInt();
                n3 += this.skipDetailPolygons(n8);
                shapeHolder.numSurf = ~shapeHolder.numSurf & 0xFFFF;
                if (shapeHolder.numSurf == 0) {
                    shapeHolder.numSurf = 1;
                }
            }
            bl = false;
        }
    }

    void getSrfs(int n2) {
        String string = new String();
        this.surfNameList = new Vector(n2 / 2);
        boolean bl = false;
        int n3 = this.theReader.getMarker() + n2;
        boolean bl2 = false;
        while (this.theReader.getMarker() < n3) {
            this.debugOutputLn(2, "marker, stop = " + this.theReader.getMarker() + ", " + n3);
            this.debugOutputLn(8, "About to call getString");
            string = this.theReader.getString();
            this.debugOutputLn(2, "Surfname = " + string);
            this.surfNameList.addElement(string);
        }
    }

    void getPnts(int n2) throws ParsingErrorException {
        int n3 = n2 / 12;
        this.coordsArray = new float[n3 * 3];
        this.theReader.getVerts(this.coordsArray, n3);
    }

    void getSurf(int n2) throws FileNotFoundException {
        this.debugOutputLn(1, "getSurf()");
        LwoSurface lwoSurface = new LwoSurface(this.theReader, n2, this.debugPrinter.getValidOutput());
        this.surfaceList.addElement(lwoSurface);
    }

    int parseFile() throws FileNotFoundException, IncorrectFormatException {
        this.debugOutputLn(1, "parseFile()");
        int n2 = 0;
        int n3 = 0;
        int n4 = 100000;
        long l2 = System.currentTimeMillis();
        String string = this.theReader.getToken();
        while (string != null && n3 < n4) {
            long l3 = System.currentTimeMillis();
            n2 = this.theReader.getInt();
            n3 += 4;
            if (string.equals("FORM")) {
                n4 = n2 + 4;
                n2 = 0;
                string = this.theReader.getToken();
                n3 += 4;
                if (!string.equals("LWOB")) {
                    throw new IncorrectFormatException("File not of FORM-length-LWOB format");
                }
            } else if (string.equals("PNTS")) {
                this.getPnts(n2);
                this.debugOutputLn(32, "done with " + string + " in " + (System.currentTimeMillis() - l3));
            } else if (string.equals("POLS")) {
                this.getPols(n2);
                this.debugOutputLn(32, "done with " + string + " in " + (System.currentTimeMillis() - l3));
            } else if (string.equals("SRFS")) {
                this.getSrfs(n2);
                this.debugOutputLn(32, "done with " + string + " in " + (System.currentTimeMillis() - l3));
            } else if (string.equals("CRVS")) {
                this.theReader.skipLength(n2);
            } else if (string.equals("PCHS")) {
                this.theReader.skipLength(n2);
            } else if (string.equals("SURF")) {
                this.getSurf(n2);
                this.debugOutputLn(32, "done with " + string + " in " + (System.currentTimeMillis() - l3));
            } else if (!string.equals("LWOB")) {
                this.theReader.skipLength(n2);
            }
            if ((n3 += n2) >= n4) continue;
            string = this.theReader.getToken();
            n3 += 4;
        }
        this.debugOutputLn(32, "done with parseFile in " + (System.currentTimeMillis() - l2));
        return 0;
    }

    static void main(String[] stringArray) {
        String string = stringArray.length == 0 ? "cube.obj" : stringArray[0];
        try {
            LwoParser lwoParser = new LwoParser(string, 0);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println(fileNotFoundException.getMessage());
            fileNotFoundException.printStackTrace();
            System.exit(1);
        }
    }
}

