/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.lw3d.SequenceLine;
import com.sun.j3d.loaders.lw3d.SwitchPathInterpolator;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.j3d.Alpha;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Node;
import javax.media.j3d.Switch;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;

class SequenceReader {
    Vector sequenceLines;
    float totalTime;
    int totalFrames;
    TransformGroup objectTransform;
    Vector behaviorVector;

    SequenceReader(String string, float f2, int n2) throws ParsingErrorException {
        this.totalTime = f2;
        this.totalFrames = n2;
        this.sequenceLines = new Vector();
        try {
            StreamTokenizer streamTokenizer = new StreamTokenizer(new BufferedReader(new FileReader(string)));
            streamTokenizer.wordChars(95, 95);
            streamTokenizer.wordChars(47, 47);
            int n3 = streamTokenizer.nextToken();
            while (streamTokenizer.ttype != -1) {
                this.sequenceLines.addElement(new SequenceLine(streamTokenizer, this.totalTime, this.totalFrames));
                streamTokenizer.nextToken();
            }
        }
        catch (IOException iOException) {
            throw new ParsingErrorException(iOException.getMessage());
        }
    }

    void createJava3dObjects(int n2, int n3) throws FileNotFoundException {
        Object object;
        Object object2;
        this.objectTransform = new TransformGroup();
        this.behaviorVector = new Vector();
        Enumeration enumeration = this.sequenceLines.elements();
        Switch switch_ = new Switch();
        switch_.setCapability(17);
        switch_.setCapability(18);
        this.objectTransform.addChild(switch_);
        while (enumeration.hasMoreElements()) {
            object2 = (SequenceLine)enumeration.nextElement();
            ((SequenceLine)object2).createJava3dObjects(n2, n3);
            if (((SequenceLine)object2).getGeometry() != null) {
                switch_.addChild(((SequenceLine)object2).getGeometry());
            }
            if (((SequenceLine)object2).getBehavior() == null) continue;
            this.behaviorVector.addElement(((SequenceLine)object2).getBehavior());
        }
        object2 = new float[this.sequenceLines.size() + 1];
        for (int i2 = 0; i2 < ((Object)object2).length - 1; ++i2) {
            object = (SequenceLine)this.sequenceLines.elementAt(i2);
            object2[i2] = (float)((SequenceLine)object).startFrame / (float)this.totalFrames;
        }
        object2[((Object)object2).length - 1] = 1.0f;
        Alpha alpha = new Alpha(-1, 1, 0L, 0L, (long)(1000.0f * this.totalTime), 0L, 0L, 0L, 0L, 0L);
        object = new SwitchPathInterpolator(alpha, (float[])object2, switch_);
        BoundingSphere boundingSphere = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 1000000.0);
        ((Behavior)object).setSchedulingBounds(boundingSphere);
        switch_.addChild((Node)object);
        this.behaviorVector.addElement(object);
    }

    TransformGroup getObjectNode() {
        return this.objectTransform;
    }

    Vector getObjectBehaviors() {
        return this.behaviorVector;
    }

    void printLines() {
        Enumeration enumeration = this.sequenceLines.elements();
        while (enumeration.hasMoreElements()) {
            SequenceLine sequenceLine = (SequenceLine)enumeration.nextElement();
        }
    }
}

