/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.objectfile;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.Loader;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.SceneBase;
import com.sun.j3d.loaders.objectfile.ObjectFileMaterials;
import com.sun.j3d.loaders.objectfile.ObjectFileParser;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Stripifier;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Shape3D;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3f;

public class ObjectFile
implements Loader {
    private static final int DEBUG = 0;
    public static final int RESIZE = 64;
    public static final int TRIANGULATE = 128;
    public static final int REVERSE = 256;
    public static final int STRIPIFY = 512;
    private static final char BACKSLASH = '\\';
    private int flags;
    private String basePath = null;
    private URL baseUrl = null;
    private boolean fromUrl = false;
    private float radians;
    private ArrayList coordList;
    private ArrayList texList;
    private ArrayList normList;
    private ArrayList coordIdxList;
    private ArrayList texIdxList;
    private ArrayList normIdxList;
    private ArrayList stripCounts;
    private HashMap groups;
    private String curGroup;
    private HashMap sGroups;
    private String curSgroup;
    private HashMap groupMaterials;
    private HashMap triGroups;
    private ArrayList curTriGroup;
    private HashMap triSgroups;
    private ArrayList curTriSgroup;
    private Point3f[] coordArray = null;
    private Vector3f[] normArray = null;
    private TexCoord2f[] texArray = null;
    private long time;
    private ObjectFileMaterials materials = null;

    void readVertex(ObjectFileParser objectFileParser) throws ParsingErrorException {
        Point3f point3f = new Point3f();
        objectFileParser.getNumber();
        point3f.x = (float)objectFileParser.nval;
        objectFileParser.getNumber();
        point3f.y = (float)objectFileParser.nval;
        objectFileParser.getNumber();
        point3f.z = (float)objectFileParser.nval;
        objectFileParser.skipToNextLine();
        this.coordList.add(point3f);
    }

    void readNormal(ObjectFileParser objectFileParser) throws ParsingErrorException {
        Vector3f vector3f = new Vector3f();
        objectFileParser.getNumber();
        vector3f.x = (float)objectFileParser.nval;
        objectFileParser.getNumber();
        vector3f.y = (float)objectFileParser.nval;
        objectFileParser.getNumber();
        vector3f.z = (float)objectFileParser.nval;
        objectFileParser.skipToNextLine();
        this.normList.add(vector3f);
    }

    void readTexture(ObjectFileParser objectFileParser) throws ParsingErrorException {
        TexCoord2f texCoord2f = new TexCoord2f();
        objectFileParser.getNumber();
        texCoord2f.x = (float)objectFileParser.nval;
        objectFileParser.getNumber();
        texCoord2f.y = (float)objectFileParser.nval;
        objectFileParser.skipToNextLine();
        this.texList.add(texCoord2f);
    }

    void readFace(ObjectFileParser objectFileParser) throws ParsingErrorException {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        objectFileParser.getToken();
        while (true) {
            if (objectFileParser.ttype == 10) break;
            objectFileParser.pushBack();
            objectFileParser.getNumber();
            int n5 = (int)objectFileParser.nval - 1;
            if (n5 < 0) {
                n5 += this.coordList.size() + 1;
            }
            this.coordIdxList.add(new Integer(n5));
            objectFileParser.getToken();
            if (objectFileParser.ttype == 47) {
                objectFileParser.getToken();
                if (objectFileParser.ttype == -3) {
                    objectFileParser.pushBack();
                    objectFileParser.getNumber();
                    n2 = (int)objectFileParser.nval - 1;
                    if (n2 < 0) {
                        n2 += this.texList.size() + 1;
                    }
                    this.texIdxList.add(new Integer(n2));
                    objectFileParser.getToken();
                }
                if (objectFileParser.ttype == 47) {
                    objectFileParser.getNumber();
                    n3 = (int)objectFileParser.nval - 1;
                    if (n3 < 0) {
                        n3 += this.normList.size() + 1;
                    }
                    this.normIdxList.add(new Integer(n3));
                    objectFileParser.getToken();
                }
            }
            ++n4;
        }
        Integer n6 = new Integer(this.stripCounts.size());
        this.stripCounts.add(new Integer(n4));
        this.groups.put(n6, this.curGroup);
        if (this.curSgroup != null) {
            this.sGroups.put(n6, this.curSgroup);
        }
        objectFileParser.skipToNextLine();
    }

    void readPartName(ObjectFileParser objectFileParser) {
        objectFileParser.getToken();
        String string = (String)this.groupMaterials.get(this.curGroup);
        this.curGroup = objectFileParser.ttype != -3 ? "default" : objectFileParser.sval;
        if (this.groupMaterials.get(this.curGroup) == null) {
            this.groupMaterials.put(this.curGroup, string);
        }
        objectFileParser.skipToNextLine();
    }

    void readMaterialName(ObjectFileParser objectFileParser) throws ParsingErrorException {
        objectFileParser.getToken();
        if (objectFileParser.ttype == -3) {
            this.groupMaterials.put(this.curGroup, new String(objectFileParser.sval));
        }
        objectFileParser.skipToNextLine();
    }

    void loadMaterialFile(ObjectFileParser objectFileParser) throws ParsingErrorException {
        String string = null;
        objectFileParser.lowerCaseMode(false);
        do {
            objectFileParser.getToken();
            if (objectFileParser.ttype != -3) continue;
            string = objectFileParser.sval;
        } while (objectFileParser.ttype != 10);
        this.materials.readMaterialFile(this.fromUrl, this.fromUrl ? this.baseUrl.toString() : this.basePath, string);
        objectFileParser.lowerCaseMode(true);
        objectFileParser.skipToNextLine();
    }

    void readSmoothingGroup(ObjectFileParser objectFileParser) throws ParsingErrorException {
        objectFileParser.getToken();
        if (objectFileParser.ttype != -3) {
            objectFileParser.skipToNextLine();
            return;
        }
        this.curSgroup = objectFileParser.sval.equals("off") ? "0" : objectFileParser.sval;
        objectFileParser.skipToNextLine();
    }

    void readFile(ObjectFileParser objectFileParser) throws ParsingErrorException {
        objectFileParser.getToken();
        while (objectFileParser.ttype != -1) {
            if (objectFileParser.ttype == -3) {
                if (objectFileParser.sval.equals("v")) {
                    this.readVertex(objectFileParser);
                } else if (objectFileParser.sval.equals("vn")) {
                    this.readNormal(objectFileParser);
                } else if (objectFileParser.sval.equals("vt")) {
                    this.readTexture(objectFileParser);
                } else if (objectFileParser.sval.equals("f")) {
                    this.readFace(objectFileParser);
                } else if (objectFileParser.sval.equals("fo")) {
                    this.readFace(objectFileParser);
                } else if (objectFileParser.sval.equals("g")) {
                    this.readPartName(objectFileParser);
                } else if (objectFileParser.sval.equals("s")) {
                    this.readSmoothingGroup(objectFileParser);
                } else if (objectFileParser.sval.equals("p")) {
                    objectFileParser.skipToNextLine();
                } else if (objectFileParser.sval.equals("l")) {
                    objectFileParser.skipToNextLine();
                } else if (objectFileParser.sval.equals("mtllib")) {
                    this.loadMaterialFile(objectFileParser);
                } else if (objectFileParser.sval.equals("usemtl")) {
                    this.readMaterialName(objectFileParser);
                } else if (objectFileParser.sval.equals("maplib")) {
                    objectFileParser.skipToNextLine();
                } else if (objectFileParser.sval.equals("usemap")) {
                    objectFileParser.skipToNextLine();
                } else {
                    throw new ParsingErrorException("Unrecognized token, line " + objectFileParser.lineno());
                }
            }
            objectFileParser.skipToNextLine();
            objectFileParser.getToken();
        }
    }

    public ObjectFile(int n2, float f2) {
        this.setFlags(n2);
        this.radians = f2;
    }

    public ObjectFile(int n2) {
        this(n2, -1.0f);
    }

    public ObjectFile() {
        this(0, -1.0f);
    }

    private void setBasePathFromFilename(String string) {
        if (string.lastIndexOf(File.separator) == -1) {
            this.setBasePath("." + File.separator);
        } else {
            this.setBasePath(string.substring(0, string.lastIndexOf(File.separator)));
        }
    }

    public Scene load(String string) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        this.setBasePathFromFilename(string);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        return this.load(bufferedReader);
    }

    private void setBaseUrlFromUrl(URL uRL) throws FileNotFoundException {
        String string = uRL.toString();
        String string2 = string.lastIndexOf(47) == -1 ? uRL.getProtocol() + ":" : string.substring(0, string.lastIndexOf(47) + 1);
        try {
            this.baseUrl = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            throw new FileNotFoundException(malformedURLException.getMessage());
        }
    }

    public Scene load(URL uRL) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        BufferedReader bufferedReader;
        if (this.baseUrl == null) {
            this.setBaseUrlFromUrl(uRL);
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(iOException.getMessage());
        }
        this.fromUrl = true;
        return this.load(bufferedReader);
    }

    private Point3f[] getLimits() {
        Point3f point3f = new Point3f();
        Point3f[] point3fArray = new Point3f[]{new Point3f(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE), new Point3f(Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE)};
        for (int i2 = 0; i2 < this.coordList.size(); ++i2) {
            point3f = (Point3f)this.coordList.get(i2);
            if (point3f.x < point3fArray[0].x) {
                point3fArray[0].x = point3f.x;
            }
            if (point3f.x > point3fArray[1].x) {
                point3fArray[1].x = point3f.x;
            }
            if (point3f.y < point3fArray[0].y) {
                point3fArray[0].y = point3f.y;
            }
            if (point3f.y > point3fArray[1].y) {
                point3fArray[1].y = point3f.y;
            }
            if (point3f.z < point3fArray[0].z) {
                point3fArray[0].z = point3f.z;
            }
            if (!(point3f.z > point3fArray[1].z)) continue;
            point3fArray[1].z = point3f.z;
        }
        return point3fArray;
    }

    private void resize() {
        Point3f point3f = new Point3f();
        Point3f[] point3fArray = this.getLimits();
        Vector3f vector3f = new Vector3f(-0.5f * (point3fArray[0].x + point3fArray[1].x), -0.5f * (point3fArray[0].y + point3fArray[1].y), -0.5f * (point3fArray[0].z + point3fArray[1].z));
        float f2 = point3fArray[1].x - point3fArray[0].x;
        if (f2 < point3fArray[1].y - point3fArray[0].y) {
            f2 = point3fArray[1].y - point3fArray[0].y;
        }
        if (f2 < point3fArray[1].z - point3fArray[0].z) {
            f2 = point3fArray[1].z - point3fArray[0].z;
        }
        f2 /= 2.0f;
        for (int i2 = 0; i2 < this.coordList.size(); ++i2) {
            point3f = (Point3f)this.coordList.get(i2);
            point3f.add(point3f, vector3f);
            point3f.x /= f2;
            point3f.y /= f2;
            point3f.z /= f2;
        }
    }

    private int[] objectToIntArray(ArrayList arrayList) {
        int[] nArray = new int[arrayList.size()];
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            nArray[i2] = (Integer)arrayList.get(i2);
        }
        return nArray;
    }

    private Point3f[] objectToPoint3Array(ArrayList arrayList) {
        Point3f[] point3fArray = new Point3f[arrayList.size()];
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            point3fArray[i2] = (Point3f)arrayList.get(i2);
        }
        return point3fArray;
    }

    private TexCoord2f[] objectToTexCoord2Array(ArrayList arrayList) {
        TexCoord2f[] texCoord2fArray = new TexCoord2f[arrayList.size()];
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            texCoord2fArray[i2] = (TexCoord2f)arrayList.get(i2);
        }
        return texCoord2fArray;
    }

    private Vector3f[] objectToVectorArray(ArrayList arrayList) {
        Vector3f[] vector3fArray = new Vector3f[arrayList.size()];
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            vector3fArray[i2] = (Vector3f)arrayList.get(i2);
        }
        return vector3fArray;
    }

    private int[] groupIndices(ArrayList arrayList, ArrayList arrayList2) {
        int[] nArray = new int[arrayList2.size() * 3];
        for (int i2 = 0; i2 < arrayList2.size(); ++i2) {
            int n2 = (Integer)arrayList2.get(i2);
            nArray[i2 * 3 + 0] = (Integer)arrayList.get(n2 + 0);
            nArray[i2 * 3 + 1] = (Integer)arrayList.get(n2 + 1);
            nArray[i2 * 3 + 2] = (Integer)arrayList.get(n2 + 2);
        }
        return nArray;
    }

    private void smoothingGroupNormals() {
        NormalGenerator normalGenerator = new NormalGenerator(this.radians == -1.0f ? Math.PI : (double)this.radians);
        NormalGenerator normalGenerator2 = new NormalGenerator(0.0);
        this.normList.clear();
        this.normIdxList = null;
        int[] nArray = new int[this.coordIdxList.size()];
        for (String string : this.triSgroups.keySet()) {
            ArrayList arrayList = (ArrayList)this.triSgroups.get(string);
            if (arrayList.size() <= 0) continue;
            GeometryInfo geometryInfo = new GeometryInfo(1);
            geometryInfo.setCoordinateIndices(this.groupIndices(this.coordIdxList, arrayList));
            geometryInfo.setCoordinates(this.coordArray);
            if (string.equals("0")) {
                normalGenerator2.generateNormals(geometryInfo);
            } else {
                normalGenerator.generateNormals(geometryInfo);
            }
            Vector3f[] vector3fArray = geometryInfo.getNormals();
            int[] nArray2 = geometryInfo.getNormalIndices();
            int n2 = 0;
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                int n3 = (Integer)arrayList.get(i2);
                for (int i3 = 0; i3 < 3; ++i3) {
                    nArray[n3 + i3] = this.normList.size();
                    this.normList.add(vector3fArray[nArray2[n2++]]);
                }
            }
        }
        this.normIdxList = new ArrayList(this.coordIdxList.size());
        for (int i4 = 0; i4 < this.coordIdxList.size(); ++i4) {
            this.normIdxList.add(new Integer(nArray[i4]));
        }
        this.normArray = this.objectToVectorArray(this.normList);
    }

    private void convertToTriangles() {
        int n2;
        boolean bl = (this.flags & 0x80) != 0;
        boolean bl2 = !this.texList.isEmpty() && !this.texIdxList.isEmpty() && this.texIdxList.size() == this.coordIdxList.size();
        boolean bl3 = !this.normList.isEmpty() && !this.normIdxList.isEmpty() && this.normIdxList.size() == this.coordIdxList.size();
        int n3 = this.stripCounts.size();
        boolean bl4 = this.curSgroup != null;
        this.triGroups = new HashMap(50);
        if (bl4) {
            this.triSgroups = new HashMap(50);
        }
        ArrayList arrayList = null;
        ArrayList arrayList2 = null;
        ArrayList arrayList3 = null;
        if (bl) {
            GeometryInfo geometryInfo = new GeometryInfo(5);
            geometryInfo.setStripCounts(this.objectToIntArray(this.stripCounts));
            geometryInfo.setCoordinates(this.coordArray);
            geometryInfo.setCoordinateIndices(this.objectToIntArray(this.coordIdxList));
            if (bl2) {
                geometryInfo.setTextureCoordinateParams(1, 2);
                geometryInfo.setTextureCoordinates(0, this.texArray);
                geometryInfo.setTextureCoordinateIndices(0, this.objectToIntArray(this.texIdxList));
            }
            if (bl3) {
                geometryInfo.setNormals(this.normArray);
                geometryInfo.setNormalIndices(this.objectToIntArray(this.normIdxList));
            }
            geometryInfo.convertToIndexedTriangles();
            int[] nArray = geometryInfo.getCoordinateIndices();
            n2 = 0;
            for (int i2 = 0; i2 < n3; ++i2) {
                n2 += (Integer)this.stripCounts.get(i2) - 2;
            }
            if (nArray.length != n2 * 3) {
                bl = false;
            } else {
                int[] nArray2 = geometryInfo.getTextureCoordinateIndices();
                int[] nArray3 = geometryInfo.getNormalIndices();
                this.coordIdxList.clear();
                this.texIdxList.clear();
                this.normIdxList.clear();
                for (int i3 = 0; i3 < nArray.length; ++i3) {
                    this.coordIdxList.add(new Integer(nArray[i3]));
                    if (bl2) {
                        this.texIdxList.add(new Integer(nArray2[i3]));
                    }
                    if (!bl3) continue;
                    this.normIdxList.add(new Integer(nArray3[i3]));
                }
            }
        }
        if (!bl) {
            arrayList = new ArrayList();
            if (bl2) {
                arrayList2 = new ArrayList();
            }
            if (bl3) {
                arrayList3 = new ArrayList();
            }
        }
        int n4 = 0;
        for (int i4 = 0; i4 < n3; ++i4) {
            int n5;
            n2 = (Integer)this.stripCounts.get(i4);
            Integer n6 = new Integer(i4);
            this.curGroup = (String)this.groups.get(n6);
            this.curTriGroup = (ArrayList)this.triGroups.get(this.curGroup);
            if (this.curTriGroup == null) {
                this.curTriGroup = new ArrayList();
                this.triGroups.put(this.curGroup, this.curTriGroup);
            }
            if (bl4) {
                this.curSgroup = (String)this.sGroups.get(n6);
                if (this.curSgroup == null) {
                    this.curSgroup = "0";
                }
                this.curTriSgroup = (ArrayList)this.triSgroups.get(this.curSgroup);
                if (this.curTriSgroup == null) {
                    this.curTriSgroup = new ArrayList();
                    this.triSgroups.put(this.curSgroup, this.curTriSgroup);
                }
            }
            if (bl) {
                for (n5 = 0; n5 < n2 - 2; ++n5) {
                    Integer n7 = new Integer(n4);
                    this.curTriGroup.add(n7);
                    if (bl4) {
                        this.curTriSgroup.add(n7);
                    }
                    n4 += 3;
                }
                continue;
            }
            for (n5 = 0; n5 < n2 - 2; ++n5) {
                Integer n8 = new Integer(arrayList.size());
                this.curTriGroup.add(n8);
                if (bl4) {
                    this.curTriSgroup.add(n8);
                }
                arrayList.add(this.coordIdxList.get(n4));
                arrayList.add(this.coordIdxList.get(n4 + n5 + 1));
                arrayList.add(this.coordIdxList.get(n4 + n5 + 2));
                if (bl2) {
                    arrayList2.add(this.texIdxList.get(n4));
                    arrayList2.add(this.texIdxList.get(n4 + n5 + 1));
                    arrayList2.add(this.texIdxList.get(n4 + n5 + 2));
                }
                if (!bl3) continue;
                arrayList3.add(this.normIdxList.get(n4));
                arrayList3.add(this.normIdxList.get(n4 + n5 + 1));
                arrayList3.add(this.normIdxList.get(n4 + n5 + 2));
            }
            n4 += n2;
        }
        this.stripCounts = null;
        this.groups = null;
        this.sGroups = null;
        if (!bl) {
            this.coordIdxList = arrayList;
            this.texIdxList = arrayList2;
            this.normIdxList = arrayList3;
        }
    }

    private SceneBase makeScene() {
        SceneBase sceneBase = new SceneBase();
        BranchGroup branchGroup = new BranchGroup();
        sceneBase.setSceneGroup(branchGroup);
        boolean bl = this.normList.isEmpty() || this.normIdxList.isEmpty() || this.normIdxList.size() != this.coordIdxList.size();
        boolean bl2 = !this.texList.isEmpty() && !this.texIdxList.isEmpty() && this.texIdxList.size() == this.coordIdxList.size();
        this.coordArray = this.objectToPoint3Array(this.coordList);
        if (!bl) {
            this.normArray = this.objectToVectorArray(this.normList);
        }
        if (bl2) {
            this.texArray = this.objectToTexCoord2Array(this.texList);
        }
        this.convertToTriangles();
        if (bl && this.curSgroup != null) {
            this.smoothingGroupNormals();
            bl = false;
        }
        NormalGenerator normalGenerator = null;
        if (bl) {
            normalGenerator = new NormalGenerator(this.radians);
        }
        Stripifier stripifier = null;
        if ((this.flags & 0x200) != 0) {
            stripifier = new Stripifier();
        }
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        for (String string : this.triGroups.keySet()) {
            ArrayList arrayList = (ArrayList)this.triGroups.get(string);
            if (arrayList.size() <= 0) continue;
            GeometryInfo geometryInfo = new GeometryInfo(1);
            geometryInfo.setCoordinateIndices(this.groupIndices(this.coordIdxList, arrayList));
            geometryInfo.setCoordinates(this.coordArray);
            if (bl2) {
                geometryInfo.setTextureCoordinateParams(1, 2);
                geometryInfo.setTextureCoordinates(0, this.texArray);
                geometryInfo.setTextureCoordinateIndices(0, this.groupIndices(this.texIdxList, arrayList));
            }
            if (bl) {
                if ((this.flags & 0x100) != 0) {
                    geometryInfo.reverse();
                }
                normalGenerator.generateNormals(geometryInfo);
            } else {
                geometryInfo.setNormalIndices(this.groupIndices(this.normIdxList, arrayList));
                geometryInfo.setNormals(this.normArray);
                if ((this.flags & 0x100) != 0) {
                    geometryInfo.reverse();
                }
            }
            if ((this.flags & 0x200) != 0) {
                stripifier.stripify(geometryInfo);
            }
            Shape3D shape3D = new Shape3D();
            shape3D.setGeometry(geometryInfo.getGeometryArray(true, true, false));
            String string2 = (String)this.groupMaterials.get(string);
            this.materials.assignMaterial(string2, shape3D);
            branchGroup.addChild(shape3D);
            sceneBase.addNamedObject(string, shape3D);
        }
        return sceneBase;
    }

    public Scene load(Reader reader) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        ObjectFileParser objectFileParser = new ObjectFileParser(reader);
        this.coordList = new ArrayList();
        this.texList = new ArrayList();
        this.normList = new ArrayList();
        this.coordIdxList = new ArrayList();
        this.texIdxList = new ArrayList();
        this.normIdxList = new ArrayList();
        this.groups = new HashMap(50);
        this.curGroup = "default";
        this.sGroups = new HashMap(50);
        this.curSgroup = null;
        this.stripCounts = new ArrayList();
        this.groupMaterials = new HashMap(50);
        this.groupMaterials.put(this.curGroup, "default");
        this.materials = new ObjectFileMaterials();
        this.time = 0L;
        this.readFile(objectFileParser);
        if ((this.flags & 0x40) != 0) {
            this.resize();
        }
        return this.makeScene();
    }

    public void setBaseUrl(URL uRL) {
        this.baseUrl = uRL;
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public void setBasePath(String string) {
        this.basePath = string;
        if (this.basePath == null || this.basePath == "") {
            this.basePath = "." + File.separator;
        }
        this.basePath = this.basePath.replace('/', File.separatorChar);
        this.basePath = this.basePath.replace('\\', File.separatorChar);
        if (!this.basePath.endsWith(File.separator)) {
            this.basePath = this.basePath + File.separator;
        }
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setFlags(int n2) {
        this.flags = n2;
    }

    public int getFlags() {
        return this.flags;
    }
}

