/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.interpolators;

import com.sun.j3d.utils.behaviors.interpolators.TCBKeyFrame;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;

public class CubicSplineSegment {
    static final double[] modRoot = new double[]{0.046910077, 0.230765345, 0.5, 0.769234655, 0.953089922};
    static final double[] modCoeff = new double[]{0.118463442, 0.239314335, 0.284444444, 0.239314335, 0.118463442};
    TCBKeyFrame[] keyFrame = new TCBKeyFrame[4];
    Point3f c0;
    Point3f c1;
    Point3f c2;
    Point3f c3;
    Point3f e0;
    Point3f e1;
    Point3f e2;
    Point3f e3;
    float one_minus_t_in;
    float one_minus_c_in;
    float one_minus_b_in;
    float one_plus_c_in;
    float one_plus_b_in;
    float ddb;
    float dda;
    float one_minus_t_out;
    float one_minus_c_out;
    float one_minus_b_out;
    float one_plus_c_out;
    float one_plus_b_out;
    float dsb;
    float dsa;
    float length;
    int linear;

    CubicSplineSegment() {
        this.length = 0.0f;
    }

    CubicSplineSegment(TCBKeyFrame tCBKeyFrame, TCBKeyFrame tCBKeyFrame2, TCBKeyFrame tCBKeyFrame3, TCBKeyFrame tCBKeyFrame4) {
        this.keyFrame[0] = new TCBKeyFrame(tCBKeyFrame);
        this.keyFrame[1] = new TCBKeyFrame(tCBKeyFrame2);
        this.keyFrame[2] = new TCBKeyFrame(tCBKeyFrame3);
        this.keyFrame[3] = new TCBKeyFrame(tCBKeyFrame4);
        if (tCBKeyFrame3.linear == 1) {
            this.linear = 1;
        } else {
            this.linear = 0;
            this.computeCommonCoefficients(tCBKeyFrame, tCBKeyFrame2, tCBKeyFrame3, tCBKeyFrame4);
            this.computeHermiteCoefficients(tCBKeyFrame, tCBKeyFrame2, tCBKeyFrame3, tCBKeyFrame4);
        }
        this.length = this.computeLength(1.0f);
    }

    private void computeCommonCoefficients(TCBKeyFrame tCBKeyFrame, TCBKeyFrame tCBKeyFrame2, TCBKeyFrame tCBKeyFrame3, TCBKeyFrame tCBKeyFrame4) {
        float f2 = 1.0f - tCBKeyFrame2.tension;
        float f3 = 1.0f - tCBKeyFrame2.continuity;
        float f4 = 1.0f - tCBKeyFrame2.bias;
        float f5 = 1.0f + tCBKeyFrame2.continuity;
        float f6 = 1.0f + tCBKeyFrame2.bias;
        this.ddb = f2 * f3 * f4;
        this.dda = f2 * f5 * f6;
        float f7 = 1.0f - tCBKeyFrame3.tension;
        float f8 = 1.0f - tCBKeyFrame3.continuity;
        float f9 = 1.0f - tCBKeyFrame3.bias;
        float f10 = 1.0f + tCBKeyFrame3.continuity;
        float f11 = 1.0f + tCBKeyFrame3.bias;
        this.dsb = f2 * f5 * f4;
        this.dsa = f2 * f3 * f6;
    }

    private void computeHermiteCoefficients(TCBKeyFrame tCBKeyFrame, TCBKeyFrame tCBKeyFrame2, TCBKeyFrame tCBKeyFrame3, TCBKeyFrame tCBKeyFrame4) {
        float f2;
        Point3f point3f = new Point3f();
        Point3f point3f2 = new Point3f();
        point3f.x = tCBKeyFrame3.position.x - tCBKeyFrame2.position.x;
        point3f.y = tCBKeyFrame3.position.y - tCBKeyFrame2.position.y;
        point3f.z = tCBKeyFrame3.position.z - tCBKeyFrame2.position.z;
        point3f2.x = tCBKeyFrame3.scale.x - tCBKeyFrame2.scale.x;
        point3f2.y = tCBKeyFrame3.scale.y - tCBKeyFrame2.scale.y;
        point3f2.z = tCBKeyFrame3.scale.z - tCBKeyFrame2.scale.z;
        Point3f point3f3 = new Point3f();
        Point3f point3f4 = new Point3f();
        if (tCBKeyFrame.knot == tCBKeyFrame2.knot) {
            f2 = 0.5f * (this.dda + this.ddb);
            point3f3.x = f2 * point3f.x;
            point3f3.y = f2 * point3f.y;
            point3f3.z = f2 * point3f.z;
            point3f4.x = f2 * point3f2.x;
            point3f4.y = f2 * point3f2.y;
            point3f4.z = f2 * point3f2.z;
        } else {
            f2 = (tCBKeyFrame2.knot - tCBKeyFrame.knot) / (tCBKeyFrame3.knot - tCBKeyFrame.knot);
            point3f3.x = f2 * (this.ddb * point3f.x + this.dda * (tCBKeyFrame2.position.x - tCBKeyFrame.position.x));
            point3f3.y = f2 * (this.ddb * point3f.y + this.dda * (tCBKeyFrame2.position.y - tCBKeyFrame.position.y));
            point3f3.z = f2 * (this.ddb * point3f.z + this.dda * (tCBKeyFrame2.position.z - tCBKeyFrame.position.z));
            point3f4.x = f2 * (this.ddb * point3f2.x + this.dda * (tCBKeyFrame2.scale.x - tCBKeyFrame.scale.x));
            point3f4.y = f2 * (this.ddb * point3f2.y + this.dda * (tCBKeyFrame2.scale.y - tCBKeyFrame.scale.y));
            point3f4.z = f2 * (this.ddb * point3f2.z + this.dda * (tCBKeyFrame2.scale.z - tCBKeyFrame.scale.z));
        }
        Point3f point3f5 = new Point3f();
        Point3f point3f6 = new Point3f();
        if (tCBKeyFrame3.knot == tCBKeyFrame4.knot) {
            float f3 = 0.5f * (this.dsa + this.dsb);
            point3f5.x = f3 * point3f.x;
            point3f5.y = f3 * point3f.y;
            point3f5.z = f3 * point3f.z;
            point3f6.x = f3 * point3f2.x;
            point3f6.y = f3 * point3f2.y;
            point3f6.z = f3 * point3f2.z;
        } else {
            float f4 = (tCBKeyFrame3.knot - tCBKeyFrame2.knot) / (tCBKeyFrame4.knot - tCBKeyFrame2.knot);
            point3f5.x = f4 * (this.dsb * (tCBKeyFrame4.position.x - tCBKeyFrame3.position.x) + this.dsa * point3f.x);
            point3f5.y = f4 * (this.dsb * (tCBKeyFrame4.position.y - tCBKeyFrame3.position.y) + this.dsa * point3f.y);
            point3f5.z = f4 * (this.dsb * (tCBKeyFrame4.position.z - tCBKeyFrame3.position.z) + this.dsa * point3f.z);
            point3f6.x = f4 * (this.dsb * (tCBKeyFrame4.scale.x - tCBKeyFrame3.scale.x) + this.dsa * point3f2.x);
            point3f6.y = f4 * (this.dsb * (tCBKeyFrame4.scale.y - tCBKeyFrame3.scale.y) + this.dsa * point3f2.y);
            point3f6.z = f4 * (this.dsb * (tCBKeyFrame4.scale.z - tCBKeyFrame3.scale.z) + this.dsa * point3f2.z);
        }
        this.c0 = new Point3f();
        this.c0.x = tCBKeyFrame2.position.x;
        this.c0.y = tCBKeyFrame2.position.y;
        this.c0.z = tCBKeyFrame2.position.z;
        this.c1 = new Point3f();
        this.c1.x = point3f3.x;
        this.c1.y = point3f3.y;
        this.c1.z = point3f3.z;
        this.c2 = new Point3f();
        this.c2.x = 3.0f * point3f.x - 2.0f * point3f3.x - point3f5.x;
        this.c2.y = 3.0f * point3f.y - 2.0f * point3f3.y - point3f5.y;
        this.c2.z = 3.0f * point3f.z - 2.0f * point3f3.z - point3f5.z;
        this.c3 = new Point3f();
        this.c3.x = -2.0f * point3f.x + point3f3.x + point3f5.x;
        this.c3.y = -2.0f * point3f.y + point3f3.y + point3f5.y;
        this.c3.z = -2.0f * point3f.z + point3f3.z + point3f5.z;
        this.e0 = new Point3f();
        this.e0.x = tCBKeyFrame2.scale.x;
        this.e0.y = tCBKeyFrame2.scale.y;
        this.e0.z = tCBKeyFrame2.scale.z;
        this.e1 = new Point3f();
        this.e1.x = point3f4.x;
        this.e1.y = point3f4.y;
        this.e1.z = point3f4.z;
        this.e2 = new Point3f();
        this.e2.x = 3.0f * point3f2.x - 2.0f * point3f4.x - point3f6.x;
        this.e2.y = 3.0f * point3f2.y - 2.0f * point3f4.y - point3f6.y;
        this.e2.z = 3.0f * point3f2.z - 2.0f * point3f4.z - point3f6.z;
        this.e3 = new Point3f();
        this.e3.x = -2.0f * point3f2.x + point3f4.x + point3f6.x;
        this.e3.y = -2.0f * point3f2.y + point3f4.y + point3f6.y;
        this.e3.z = -2.0f * point3f2.z + point3f4.z + point3f6.z;
    }

    public float computeLength(float f2) {
        float f3 = 0.0f;
        if (this.linear == 1) {
            f3 = f2 * this.keyFrame[2].position.distance(this.keyFrame[1].position);
        } else {
            int n2 = 5;
            for (int i2 = 0; i2 < n2; ++i2) {
                f3 += (float)modCoeff[i2] * this.computeSpeed(f2 * (float)modRoot[i2]);
            }
            f3 *= f2;
        }
        return f3;
    }

    private float computeSpeed(float f2) {
        Point3f point3f = new Point3f();
        point3f.x = this.c1.x + f2 * (2.0f * this.c2.x + 3.0f * f2 * this.c3.x);
        point3f.y = this.c1.y + f2 * (2.0f * this.c2.y + 3.0f * f2 * this.c3.y);
        point3f.z = this.c1.z + f2 * (2.0f * this.c2.z + 3.0f * f2 * this.c3.z);
        return (float)Math.sqrt(point3f.x * point3f.x + point3f.y * point3f.y + point3f.z * point3f.z);
    }

    public void getInterpolatedQuaternion(float f2, Quat4f quat4f) {
        if (this.linear == 1) {
            double d2 = this.keyFrame[1].quat.x * this.keyFrame[2].quat.x + this.keyFrame[1].quat.y * this.keyFrame[2].quat.y + this.keyFrame[1].quat.z * this.keyFrame[2].quat.z + this.keyFrame[1].quat.w * this.keyFrame[2].quat.w;
            if (d2 < 0.0) {
                quat4f.x = this.keyFrame[1].quat.x + (-this.keyFrame[2].quat.x - this.keyFrame[1].quat.x) * f2;
                quat4f.y = this.keyFrame[1].quat.y + (-this.keyFrame[2].quat.y - this.keyFrame[1].quat.y) * f2;
                quat4f.z = this.keyFrame[1].quat.z + (-this.keyFrame[2].quat.z - this.keyFrame[1].quat.z) * f2;
                quat4f.w = this.keyFrame[1].quat.w + (-this.keyFrame[2].quat.w - this.keyFrame[1].quat.w) * f2;
            } else {
                quat4f.x = this.keyFrame[1].quat.x + (this.keyFrame[2].quat.x - this.keyFrame[1].quat.x) * f2;
                quat4f.y = this.keyFrame[1].quat.y + (this.keyFrame[2].quat.y - this.keyFrame[1].quat.y) * f2;
                quat4f.z = this.keyFrame[1].quat.z + (this.keyFrame[2].quat.z - this.keyFrame[1].quat.z) * f2;
                quat4f.w = this.keyFrame[1].quat.w + (this.keyFrame[2].quat.w - this.keyFrame[1].quat.w) * f2;
            }
        } else {
            quat4f.interpolate(this.keyFrame[1].quat, this.keyFrame[2].quat, f2);
        }
    }

    public void getInterpolatedScale(float f2, Point3f point3f) {
        if (this.linear == 1) {
            point3f.x = this.keyFrame[1].scale.x + (this.keyFrame[2].scale.x - this.keyFrame[1].scale.x) * f2;
            point3f.y = this.keyFrame[1].scale.y + (this.keyFrame[2].scale.y - this.keyFrame[1].scale.y) * f2;
            point3f.z = this.keyFrame[1].scale.z + (this.keyFrame[2].scale.z - this.keyFrame[1].scale.z) * f2;
        } else {
            point3f.x = this.e0.x + f2 * (this.e1.x + f2 * (this.e2.x + f2 * this.e3.x));
            point3f.y = this.e0.y + f2 * (this.e1.y + f2 * (this.e2.y + f2 * this.e3.y));
            point3f.z = this.e0.z + f2 * (this.e1.z + f2 * (this.e2.z + f2 * this.e3.z));
        }
    }

    public void getInterpolatedPosition(float f2, Point3f point3f) {
        if (this.linear == 1) {
            point3f.x = this.keyFrame[1].position.x + (this.keyFrame[2].position.x - this.keyFrame[1].position.x) * f2;
            point3f.y = this.keyFrame[1].position.y + (this.keyFrame[2].position.y - this.keyFrame[1].position.y) * f2;
            point3f.z = this.keyFrame[1].position.z + (this.keyFrame[2].position.z - this.keyFrame[1].position.z) * f2;
        } else {
            point3f.x = this.c0.x + f2 * (this.c1.x + f2 * (this.c2.x + f2 * this.c3.x));
            point3f.y = this.c0.y + f2 * (this.c1.y + f2 * (this.c2.y + f2 * this.c3.y));
            point3f.z = this.c0.z + f2 * (this.c1.z + f2 * (this.c2.z + f2 * this.c3.z));
        }
    }

    public void getInterpolatedPositionVector(float f2, Vector3f vector3f) {
        if (this.linear == 1) {
            vector3f.x = this.keyFrame[1].position.x + (this.keyFrame[2].position.x - this.keyFrame[1].position.x) * f2;
            vector3f.y = this.keyFrame[1].position.y + (this.keyFrame[2].position.y - this.keyFrame[1].position.y) * f2;
            vector3f.z = this.keyFrame[1].position.z + (this.keyFrame[2].position.z - this.keyFrame[1].position.z) * f2;
        } else {
            vector3f.x = this.c0.x + f2 * (this.c1.x + f2 * (this.c2.x + f2 * this.c3.x));
            vector3f.y = this.c0.y + f2 * (this.c1.y + f2 * (this.c2.y + f2 * this.c3.y));
            vector3f.z = this.c0.z + f2 * (this.c1.z + f2 * (this.c2.z + f2 * this.c3.z));
        }
    }

    public float getInterpolatedValue(float f2) {
        return this.computeLength(f2) / this.length;
    }
}

