/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.picking;

import com.sun.j3d.internal.J3dUtilsI18N;
import javax.media.j3d.PickPoint;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickSegment;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;

public class Intersect {
    public static boolean rayAndQuad(PickRay pickRay, Point3d[] point3dArray, int n2, double[] dArray) {
        if (point3dArray.length - n2 < 4) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect0"));
        }
        Point3d[] point3dArray2 = new Point3d[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            point3dArray2[i2] = point3dArray[n2 + i2];
        }
        return Intersect.rayAndPoly(point3dArray2, pickRay, dArray);
    }

    public static boolean rayAndTriangle(PickRay pickRay, Point3d[] point3dArray, int n2, double[] dArray) {
        if (point3dArray.length - n2 < 3) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect1"));
        }
        Point3d[] point3dArray2 = new Point3d[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            point3dArray2[i2] = point3dArray[n2 + i2];
        }
        return Intersect.rayAndPoly(point3dArray2, pickRay, dArray);
    }

    public static boolean rayAndTriangle(PickRay pickRay, Point3f[] point3fArray, int n2, double[] dArray) {
        if (point3fArray.length - n2 < 3) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect1"));
        }
        Point3d[] point3dArray = new Point3d[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            point3dArray[i2] = new Point3d(point3fArray[n2 + i2]);
        }
        return Intersect.rayAndPoly(point3dArray, pickRay, dArray);
    }

    public static boolean segmentAndQuad(PickSegment pickSegment, Point3d[] point3dArray, int n2, double[] dArray) {
        if (point3dArray.length - n2 < 4) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect3"));
        }
        Point3d[] point3dArray2 = new Point3d[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            point3dArray2[i2] = point3dArray[n2 + i2];
        }
        return Intersect.segmentAndPoly(point3dArray2, pickSegment, dArray);
    }

    public static boolean segmentAndQuad(PickSegment pickSegment, Point3f[] point3fArray, int n2, double[] dArray) {
        if (point3fArray.length - n2 < 4) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect3"));
        }
        Point3d[] point3dArray = new Point3d[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            point3dArray[i2] = new Point3d(point3fArray[n2 + i2]);
        }
        return Intersect.segmentAndPoly(point3dArray, pickSegment, dArray);
    }

    public static boolean segmentAndTriangle(PickSegment pickSegment, Point3d[] point3dArray, int n2, double[] dArray) {
        if (point3dArray.length - n2 < 3) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect5"));
        }
        Point3d[] point3dArray2 = new Point3d[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            point3dArray2[i2] = point3dArray[n2 + i2];
        }
        return Intersect.segmentAndPoly(point3dArray2, pickSegment, dArray);
    }

    public static boolean segmentAndTriangle(PickSegment pickSegment, Point3f[] point3fArray, int n2, double[] dArray) {
        if (point3fArray.length - n2 < 3) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect6"));
        }
        Point3d[] point3dArray = new Point3d[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            point3dArray[i2] = new Point3d(point3fArray[n2 + i2]);
        }
        return Intersect.segmentAndPoly(point3dArray, pickSegment, dArray);
    }

    private static boolean pointAndQuad(PickPoint pickPoint, Point3d[] point3dArray, int n2) {
        if (point3dArray.length - n2 < 4) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect7"));
        }
        Point3d[] point3dArray2 = new Point3d[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            point3dArray2[i2] = point3dArray[n2 + i2];
        }
        return Intersect.pointAndPoly(point3dArray2, pickPoint);
    }

    private static boolean pointAndQuad(PickPoint pickPoint, Point3f[] point3fArray, int n2) {
        if (point3fArray.length - n2 < 4) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect7"));
        }
        Point3d[] point3dArray = new Point3d[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            point3dArray[i2] = new Point3d(point3fArray[n2 + i2]);
        }
        return Intersect.pointAndPoly(point3dArray, pickPoint);
    }

    private static boolean pointAndTriangle(PickPoint pickPoint, Point3d[] point3dArray, int n2) {
        if (point3dArray.length - n2 < 3) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect9"));
        }
        Point3d[] point3dArray2 = new Point3d[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            point3dArray2[i2] = point3dArray[n2 + i2];
        }
        return Intersect.pointAndPoly(point3dArray2, pickPoint);
    }

    private static boolean pointAndTriangle(PickPoint pickPoint, Point3f[] point3fArray, int n2) {
        if (point3fArray.length - n2 < 3) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect10"));
        }
        Point3d[] point3dArray = new Point3d[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            point3dArray[i2] = new Point3d(point3fArray[n2 + i2]);
        }
        return Intersect.pointAndPoly(point3dArray, pickPoint);
    }

    public static boolean rayAndPoint(PickRay pickRay, Point3d point3d, double[] dArray) {
        Point3d point3d2 = new Point3d();
        Vector3d vector3d = new Vector3d();
        pickRay.get(point3d2, vector3d);
        return Intersect.rayAndPoint(point3d, point3d2, vector3d, dArray);
    }

    public static boolean rayAndPoint(PickRay pickRay, Point3f point3f, double[] dArray) {
        Point3d point3d = new Point3d();
        Vector3d vector3d = new Vector3d();
        pickRay.get(point3d, vector3d);
        return Intersect.rayAndPoint(new Point3d(point3f), point3d, vector3d, dArray);
    }

    public static boolean segmentAndPoint(PickSegment pickSegment, Point3d point3d, double[] dArray) {
        Point3d point3d2 = new Point3d();
        Point3d point3d3 = new Point3d();
        Vector3d vector3d = new Vector3d();
        pickSegment.get(point3d2, point3d3);
        vector3d.x = point3d3.x - point3d2.x;
        vector3d.y = point3d3.y - point3d2.y;
        vector3d.z = point3d3.z - point3d2.z;
        return Intersect.rayAndPoint(point3d, point3d2, vector3d, dArray) && dArray[0] <= 1.0;
    }

    public static boolean segmentAndPoint(PickSegment pickSegment, Point3f point3f, double[] dArray) {
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Vector3d vector3d = new Vector3d();
        pickSegment.get(point3d, point3d2);
        vector3d.x = point3d2.x - point3d.x;
        vector3d.y = point3d2.y - point3d.y;
        vector3d.z = point3d2.z - point3d.z;
        return Intersect.rayAndPoint(new Point3d(point3f), point3d, vector3d, dArray) && dArray[0] <= 1.0;
    }

    public static boolean pointAndPoint(PickPoint pickPoint, Point3d point3d) {
        Point3d point3d2 = new Point3d();
        pickPoint.get(point3d2);
        return point3d2.x == point3d.x && point3d2.y == point3d.y && point3d2.z == point3d.z;
    }

    public static boolean pointAndPoint(PickPoint pickPoint, Point3f point3f) {
        Point3d point3d = new Point3d();
        pickPoint.get(point3d);
        return (float)point3d.x == point3f.x && (float)point3d.y == point3f.y && (float)point3d.z == point3f.z;
    }

    public static boolean rayAndLine(PickRay pickRay, Point3d[] point3dArray, int n2, double[] dArray) {
        Point3d point3d = new Point3d();
        Vector3d vector3d = new Vector3d();
        if (point3dArray.length - n2 < 2) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect11"));
        }
        pickRay.get(point3d, vector3d);
        Point3d point3d2 = point3dArray[n2++];
        Point3d point3d3 = point3dArray[n2];
        return Intersect.lineAndRay(point3d2, point3d3, point3d, vector3d, dArray);
    }

    public static boolean rayAndLine(PickRay pickRay, Point3f[] point3fArray, int n2, double[] dArray) {
        Point3d point3d = new Point3d();
        Vector3d vector3d = new Vector3d();
        if (point3fArray.length - n2 < 2) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect11"));
        }
        pickRay.get(point3d, vector3d);
        Point3d point3d2 = new Point3d(point3fArray[n2++]);
        Point3d point3d3 = new Point3d(point3fArray[n2]);
        return Intersect.lineAndRay(point3d2, point3d3, point3d, vector3d, dArray);
    }

    public static boolean segmentAndLine(PickSegment pickSegment, Point3d[] point3dArray, int n2, double[] dArray) {
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Vector3d vector3d = new Vector3d();
        if (point3dArray.length - n2 < 2) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect13"));
        }
        pickSegment.get(point3d, point3d2);
        vector3d.x = point3d2.x - point3d.x;
        vector3d.y = point3d2.y - point3d.y;
        vector3d.z = point3d2.z - point3d.z;
        Point3d point3d3 = point3dArray[n2++];
        Point3d point3d4 = point3dArray[n2];
        return Intersect.lineAndRay(point3d3, point3d4, point3d, vector3d, dArray) && dArray[0] <= 1.0;
    }

    public static boolean segmentAndLine(PickSegment pickSegment, Point3f[] point3fArray, int n2, double[] dArray) {
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Vector3d vector3d = new Vector3d();
        if (point3fArray.length - n2 < 2) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect13"));
        }
        pickSegment.get(point3d, point3d2);
        vector3d.x = point3d2.x - point3d.x;
        vector3d.y = point3d2.y - point3d.y;
        vector3d.z = point3d2.z - point3d.z;
        Point3d point3d3 = new Point3d(point3fArray[n2++]);
        Point3d point3d4 = new Point3d(point3fArray[n2]);
        return Intersect.lineAndRay(point3d3, point3d4, point3d, vector3d, dArray) && dArray[0] <= 1.0;
    }

    public static boolean pointAndLine(PickPoint pickPoint, Point3d[] point3dArray, int n2) {
        if (point3dArray.length - n2 < 2) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect13"));
        }
        double[] dArray = new double[1];
        Point3d point3d = point3dArray[n2++];
        Point3d point3d2 = point3dArray[n2];
        Point3d point3d3 = new Point3d();
        Vector3d vector3d = new Vector3d();
        pickPoint.get(point3d3);
        vector3d.x = point3d2.x - point3d.x;
        vector3d.y = point3d2.y - point3d.y;
        vector3d.z = point3d2.z - point3d.z;
        return Intersect.rayAndPoint(point3d3, point3d, vector3d, dArray) && dArray[0] <= 1.0;
    }

    public static boolean pointAndLine(PickPoint pickPoint, Point3f[] point3fArray, int n2) {
        if (point3fArray.length - n2 < 2) {
            throw new RuntimeException(J3dUtilsI18N.getString("Intersect13"));
        }
        double[] dArray = new double[1];
        Point3d point3d = new Point3d(point3fArray[n2++]);
        Point3d point3d2 = new Point3d(point3fArray[n2]);
        Point3d point3d3 = new Point3d();
        Vector3d vector3d = new Vector3d();
        pickPoint.get(point3d3);
        vector3d.x = point3d2.x - point3d.x;
        vector3d.y = point3d2.y - point3d.y;
        vector3d.z = point3d2.z - point3d.z;
        return Intersect.rayAndPoint(point3d3, point3d, vector3d, dArray) && dArray[0] <= 1.0;
    }

    private static boolean pointAndPoly(Point3d[] point3dArray, PickPoint pickPoint) {
        int n2;
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        double d2 = 0.0;
        Vector3d vector3d4 = new Vector3d();
        double d3 = 0.0;
        int n3 = 0;
        while (n3 < point3dArray.length - 1) {
            vector3d.x = point3dArray[n3 + 1].x - point3dArray[n3].x;
            vector3d.y = point3dArray[n3 + 1].y - point3dArray[n3].y;
            vector3d.z = point3dArray[n3 + 1].z - point3dArray[n3++].z;
            if (!(vector3d.length() > 0.0)) continue;
        }
        for (n2 = n3; n2 < point3dArray.length - 1; ++n2) {
            vector3d2.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
            vector3d2.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
            vector3d2.z = point3dArray[n2 + 1].z - point3dArray[n2].z;
            if (vector3d2.length() > 0.0) break;
        }
        if (n2 == point3dArray.length - 1) {
            return false;
        }
        vector3d3.cross(vector3d, vector3d2);
        if (vector3d3.length() == 0.0) {
            return false;
        }
        vector3d4.set(point3dArray[0]);
        d2 = vector3d3.dot(vector3d4);
        Point3d point3d = new Point3d();
        pickPoint.get(point3d);
        vector3d4.set(point3d);
        return d2 - vector3d3.dot(vector3d4) == 0.0;
    }

    private static boolean lineAndRay(Point3d point3d, Point3d point3d2, Point3d point3d3, Vector3d vector3d, double[] dArray) {
        Vector3d vector3d2 = new Vector3d(point3d2.x - point3d.x, point3d2.y - point3d.y, point3d2.z - point3d.z);
        double d2 = vector3d2.x;
        double d3 = -vector3d.y;
        double d4 = vector3d2.y;
        double d5 = -vector3d.x;
        double d6 = d2 * d3 - d4 * d5;
        if (d6 == 0.0) {
            return false;
        }
        double d7 = 1.0 / d6;
        double d8 = d7 * d3;
        double d9 = d7 * -d5;
        double d10 = d7 * -d4;
        double d11 = d7 * d2;
        d7 = point3d3.x - point3d.x;
        double d12 = point3d3.y - point3d.y;
        double d13 = d8 * d7 + d9 * d12;
        double d14 = d10 * d7 + d11 * d12;
        if (d14 < 0.0) {
            return false;
        }
        if (d13 < 0.0 || d13 > 1.0) {
            return false;
        }
        d7 = point3d3.z + d14 * vector3d.z;
        d12 = point3d.z + d13 * vector3d2.z;
        if (d7 < d12 - Double.MIN_VALUE || d7 > d12 + Double.MIN_VALUE) {
            return false;
        }
        dArray[0] = d14;
        return true;
    }

    private static boolean rayAndPoint(Point3d point3d, Point3d point3d2, Vector3d vector3d, double[] dArray) {
        double d2;
        int n2 = 0;
        if (vector3d.x != 0.0) {
            n2 = 0;
            dArray[0] = (point3d.x - point3d2.x) / vector3d.x;
        } else if (vector3d.y != 0.0) {
            if (point3d.x != point3d2.x) {
                return false;
            }
            n2 = 1;
            dArray[0] = (point3d.y - point3d2.y) / vector3d.y;
        } else if (vector3d.z != 0.0) {
            if (point3d.x != point3d2.x || point3d.y != point3d2.y) {
                return false;
            }
            n2 = 2;
            dArray[0] = (point3d.z - point3d2.z) / vector3d.z;
        } else {
            return false;
        }
        if (dArray[0] < 0.0) {
            return false;
        }
        if (n2 == 0 && (point3d.y < (d2 = point3d2.y + dArray[0] * vector3d.y) - Double.MIN_VALUE || point3d.y > d2 + Double.MIN_VALUE)) {
            return false;
        }
        return n2 >= 2 || !(point3d.z < (d2 = point3d2.z + dArray[0] * vector3d.z) - Double.MIN_VALUE) && !(point3d.z > d2 + Double.MIN_VALUE);
    }

    private static boolean rayAndPoly(Point3d[] point3dArray, PickRay pickRay, double[] dArray) {
        int n2;
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        double d2 = 0.0;
        Vector3d vector3d4 = new Vector3d();
        double d3 = 0.0;
        Point3d point3d = new Point3d();
        Vector3d vector3d5 = new Vector3d();
        Point3d point3d2 = new Point3d();
        double[] dArray2 = new double[4];
        double[] dArray3 = new double[4];
        int n3 = 0;
        while (n3 < point3dArray.length - 1) {
            vector3d.x = point3dArray[n3 + 1].x - point3dArray[n3].x;
            vector3d.y = point3dArray[n3 + 1].y - point3dArray[n3].y;
            vector3d.z = point3dArray[n3 + 1].z - point3dArray[n3++].z;
            if (!(vector3d.length() > 0.0)) continue;
        }
        for (n2 = n3; n2 < point3dArray.length - 1; ++n2) {
            vector3d2.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
            vector3d2.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
            vector3d2.z = point3dArray[n2 + 1].z - point3dArray[n2].z;
            if (vector3d2.length() > 0.0) break;
        }
        if (n2 == point3dArray.length - 1) {
            return false;
        }
        vector3d3.cross(vector3d, vector3d2);
        if (vector3d3.length() == 0.0) {
            return false;
        }
        pickRay.get(point3d, vector3d5);
        vector3d4.set(point3dArray[0]);
        d2 = vector3d3.dot(vector3d4);
        d3 = vector3d3.dot(vector3d5);
        if (d3 == 0.0) {
            return false;
        }
        vector3d4.set(point3d);
        dArray[0] = (d2 - vector3d3.dot(vector3d4)) / d3;
        if (dArray[0] < 0.0) {
            return false;
        }
        point3d2.x = point3d.x + vector3d5.x * dArray[0];
        point3d2.y = point3d.y + vector3d5.y * dArray[0];
        point3d2.z = point3d.z + vector3d5.z * dArray[0];
        double d4 = Math.abs(vector3d3.x);
        double d5 = Math.abs(vector3d3.y);
        double d6 = Math.abs(vector3d3.z);
        int n4 = d4 > d5 ? 0 : 1;
        if (n4 == 0) {
            if (d4 < d6) {
                n4 = 2;
            }
        } else if (n4 == 1 && d5 < d6) {
            n4 = 2;
        }
        block7: for (n3 = 0; n3 < point3dArray.length; ++n3) {
            switch (n4) {
                case 0: {
                    dArray2[n3] = point3dArray[n3].y - point3d2.y;
                    dArray3[n3] = point3dArray[n3].z - point3d2.z;
                    continue block7;
                }
                case 1: {
                    dArray2[n3] = point3dArray[n3].x - point3d2.x;
                    dArray3[n3] = point3dArray[n3].z - point3d2.z;
                    continue block7;
                }
                case 2: {
                    dArray2[n3] = point3dArray[n3].x - point3d2.x;
                    dArray3[n3] = point3dArray[n3].y - point3d2.y;
                }
            }
        }
        int n5 = 0;
        int n6 = dArray3[0] < 0.0 ? -1 : 1;
        for (n3 = 0; n3 < point3dArray.length; ++n3) {
            double d7;
            int n7;
            n2 = n3 + 1;
            if (n2 == point3dArray.length) {
                n2 = 0;
            }
            if (n6 == (n7 = dArray3[n2] < 0.0 ? -1 : 1)) continue;
            if (dArray2[n3] > 0.0 && dArray2[n2] > 0.0) {
                ++n5;
            } else if ((dArray2[n3] > 0.0 || dArray2[n2] > 0.0) && (d7 = dArray2[n3] - dArray3[n3] * (dArray2[n2] - dArray2[n3]) / (dArray3[n2] - dArray3[n3])) > 0.0) {
                ++n5;
            }
            n6 = n7;
        }
        if (n5 % 2 == 1) {
            dArray[0] = dArray[0] * vector3d5.length();
            return true;
        }
        return false;
    }

    private static boolean segmentAndPoly(Point3d[] point3dArray, PickSegment pickSegment, double[] dArray) {
        int n2;
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        double d2 = 0.0;
        Vector3d vector3d4 = new Vector3d();
        Vector3d vector3d5 = new Vector3d();
        double d3 = 0.0;
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        Point3d point3d3 = new Point3d();
        double[] dArray2 = new double[4];
        double[] dArray3 = new double[4];
        int n3 = 0;
        while (n3 < point3dArray.length - 1) {
            vector3d.x = point3dArray[n3 + 1].x - point3dArray[n3].x;
            vector3d.y = point3dArray[n3 + 1].y - point3dArray[n3].y;
            vector3d.z = point3dArray[n3 + 1].z - point3dArray[n3++].z;
            if (!(vector3d.length() > 0.0)) continue;
        }
        for (n2 = n3; n2 < point3dArray.length - 1; ++n2) {
            vector3d2.x = point3dArray[n2 + 1].x - point3dArray[n2].x;
            vector3d2.y = point3dArray[n2 + 1].y - point3dArray[n2].y;
            vector3d2.z = point3dArray[n2 + 1].z - point3dArray[n2].z;
            if (vector3d2.length() > 0.0) break;
        }
        if (n2 == point3dArray.length - 1) {
            return false;
        }
        vector3d3.cross(vector3d, vector3d2);
        if (vector3d3.length() == 0.0) {
            return false;
        }
        vector3d4.set(point3dArray[0]);
        d2 = vector3d3.dot(vector3d4);
        pickSegment.get(point3d, point3d2);
        vector3d5.x = point3d2.x - point3d.x;
        vector3d5.y = point3d2.y - point3d.y;
        vector3d5.z = point3d2.z - point3d.z;
        d3 = vector3d3.dot(vector3d5);
        if (d3 == 0.0) {
            return false;
        }
        vector3d4.set(point3d);
        dArray[0] = (d2 - vector3d3.dot(vector3d4)) / d3;
        if (dArray[0] < 0.0 || dArray[0] > 1.0) {
            return false;
        }
        point3d3.x = point3d.x + vector3d5.x * dArray[0];
        point3d3.y = point3d.y + vector3d5.y * dArray[0];
        point3d3.z = point3d.z + vector3d5.z * dArray[0];
        double d4 = Math.abs(vector3d3.x);
        double d5 = Math.abs(vector3d3.y);
        double d6 = Math.abs(vector3d3.z);
        int n4 = d4 > d5 ? 0 : 1;
        if (n4 == 0) {
            if (d4 < d6) {
                n4 = 2;
            }
        } else if (n4 == 1 && d5 < d6) {
            n4 = 2;
        }
        block7: for (n3 = 0; n3 < point3dArray.length; ++n3) {
            switch (n4) {
                case 0: {
                    dArray2[n3] = point3dArray[n3].y - point3d3.y;
                    dArray3[n3] = point3dArray[n3].z - point3d3.z;
                    continue block7;
                }
                case 1: {
                    dArray2[n3] = point3dArray[n3].x - point3d3.x;
                    dArray3[n3] = point3dArray[n3].z - point3d3.z;
                    continue block7;
                }
                case 2: {
                    dArray2[n3] = point3dArray[n3].x - point3d3.x;
                    dArray3[n3] = point3dArray[n3].y - point3d3.y;
                }
            }
        }
        int n5 = 0;
        int n6 = dArray3[0] < 0.0 ? -1 : 1;
        for (n3 = 0; n3 < point3dArray.length; ++n3) {
            double d7;
            int n7;
            n2 = n3 + 1;
            if (n2 == point3dArray.length) {
                n2 = 0;
            }
            if (n6 == (n7 = dArray3[n2] < 0.0 ? -1 : 1)) continue;
            if (dArray2[n3] > 0.0 && dArray2[n2] > 0.0) {
                ++n5;
            } else if ((dArray2[n3] > 0.0 || dArray2[n2] > 0.0) && (d7 = dArray2[n3] - dArray3[n3] * (dArray2[n2] - dArray2[n3]) / (dArray3[n2] - dArray3[n3])) > 0.0) {
                ++n5;
            }
            n6 = n7;
        }
        if (n5 % 2 == 1) {
            dArray[0] = dArray[0] * vector3d5.length();
            return true;
        }
        return false;
    }
}

