/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.picking;

import com.sun.j3d.utils.behaviors.picking.PickObject;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOr;

public abstract class PickMouseBehavior
extends Behavior {
    protected PickObject pickScene;
    protected WakeupCriterion[] conditions;
    protected WakeupOr wakeupCondition;
    protected boolean buttonPress = false;
    protected TransformGroup currGrp = new TransformGroup();
    protected static final boolean debug = false;
    protected MouseEvent mevent;

    public PickMouseBehavior(Canvas3D canvas3D, BranchGroup branchGroup, Bounds bounds) {
        this.currGrp.setCapability(18);
        this.currGrp.setCapability(17);
        branchGroup.addChild(this.currGrp);
        this.pickScene = new PickObject(canvas3D, branchGroup);
    }

    public void initialize() {
        this.conditions = new WakeupCriterion[2];
        this.conditions[0] = new WakeupOnAWTEvent(503);
        this.conditions[1] = new WakeupOnAWTEvent(501);
        this.wakeupCondition = new WakeupOr(this.conditions);
        this.wakeupOn(this.wakeupCondition);
    }

    private void processMouseEvent(MouseEvent mouseEvent) {
        this.buttonPress = false;
        if (mouseEvent.getID() == 501 | mouseEvent.getID() == 500) {
            this.buttonPress = true;
            return;
        }
        if (mouseEvent.getID() == 503) {
            // empty if block
        }
    }

    public void processStimulus(Enumeration enumeration) {
        AWTEvent[] aWTEventArray = null;
        int n2 = 0;
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            WakeupCriterion wakeupCriterion = (WakeupCriterion)enumeration.nextElement();
            if (!(wakeupCriterion instanceof WakeupOnAWTEvent)) continue;
            aWTEventArray = ((WakeupOnAWTEvent)wakeupCriterion).getAWTEvent();
        }
        if (aWTEventArray[0] instanceof MouseEvent) {
            this.mevent = (MouseEvent)aWTEventArray[0];
            this.processMouseEvent((MouseEvent)aWTEventArray[0]);
            n2 = this.mevent.getPoint().x;
            n3 = this.mevent.getPoint().y;
        }
        if (this.buttonPress) {
            this.updateScene(n2, n3);
        }
        this.wakeupOn(this.wakeupCondition);
    }

    public abstract void updateScene(int var1, int var2);
}

