/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.sensor;

import com.sun.j3d.utils.behaviors.sensor.SensorEvent;
import com.sun.j3d.utils.behaviors.sensor.SensorEventAgent;
import com.sun.j3d.utils.behaviors.sensor.SensorGnomonEcho;
import com.sun.j3d.utils.behaviors.sensor.SensorReadListener;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.Sensor;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;

public class Mouse6DPointerBehavior
extends Behavior {
    private Sensor sensor = null;
    private SensorEventAgent eventAgent = null;
    private TransformGroup echoTransformGroup = null;
    private WakeupCondition conditions = new WakeupOnElapsedFrames(0);

    public Mouse6DPointerBehavior(Sensor sensor, double d2, boolean bl) {
        this.sensor = sensor;
        this.echoTransformGroup = new TransformGroup();
        this.echoTransformGroup.setCapability(18);
        Point3d point3d = new Point3d();
        sensor.getHotspot(point3d);
        Transform3D transform3D = new Transform3D();
        Vector3f vector3f = new Vector3f(point3d);
        transform3D.set(vector3f);
        SensorGnomonEcho sensorGnomonEcho = new SensorGnomonEcho(transform3D, 0.001 * d2, 0.005 * d2, bl);
        this.echoTransformGroup.addChild(sensorGnomonEcho);
        this.eventAgent = new SensorEventAgent(this);
        this.eventAgent.addSensorReadListener(sensor, new EchoReadListener());
    }

    public Mouse6DPointerBehavior(Sensor sensor, TransformGroup transformGroup) {
        this.sensor = sensor;
        this.echoTransformGroup = transformGroup;
        this.eventAgent = new SensorEventAgent(this);
        this.eventAgent.addSensorReadListener(sensor, new EchoReadListener());
    }

    public Sensor getSensor() {
        return this.sensor;
    }

    public TransformGroup getEcho() {
        return this.echoTransformGroup;
    }

    public SensorEventAgent getSensorEventAgent() {
        return this.eventAgent;
    }

    public void initialize() {
        this.wakeupOn(this.conditions);
    }

    public void processStimulus(Enumeration enumeration) {
        this.eventAgent.dispatchEvents();
        this.wakeupOn(this.conditions);
    }

    public class EchoReadListener
    implements SensorReadListener {
        private Transform3D t3d = new Transform3D();

        public void read(SensorEvent sensorEvent) {
            Mouse6DPointerBehavior.this.getView().getSensorToVworld(sensorEvent.getSensor(), this.t3d);
            Mouse6DPointerBehavior.this.echoTransformGroup.setTransform(this.t3d);
        }
    }
}

