/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.sensor;

import javax.media.j3d.Sensor;
import javax.media.j3d.Transform3D;

public class SensorEvent {
    public static final int PRESSED = 1;
    public static final int RELEASED = 2;
    public static final int DRAGGED = 3;
    public static final int READ = 4;
    public static final int NOBUTTON = -1;
    private int id = 0;
    private Object source = null;
    private Sensor sensor = null;
    private int button = -1;
    private int[] buttonState = null;
    private Transform3D sensorRead = null;
    private long time = 0L;
    private long lastTime = 0L;
    private boolean ephemeral = false;

    public SensorEvent(Object object, int n2, Sensor sensor, Transform3D transform3D, int[] nArray, int n3, long l2, long l3) {
        this.source = object;
        this.id = n2;
        this.sensor = sensor;
        this.button = n3;
        this.time = l2;
        this.lastTime = l3;
        if (transform3D == null) {
            throw new NullPointerException("sensorRead can't be null");
        }
        this.sensorRead = new Transform3D(transform3D);
        if (nArray != null) {
            this.buttonState = new int[nArray.length];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                this.buttonState[i2] = nArray[i2];
            }
        }
        this.ephemeral = false;
    }

    public SensorEvent() {
        this.ephemeral = true;
    }

    public SensorEvent(SensorEvent sensorEvent) {
        this.source = sensorEvent.source;
        this.id = sensorEvent.id;
        this.sensor = sensorEvent.sensor;
        this.button = sensorEvent.button;
        this.time = sensorEvent.time;
        this.lastTime = sensorEvent.lastTime;
        if (sensorEvent.sensorRead == null) {
            throw new NullPointerException("sensorRead can't be null");
        }
        this.sensorRead = new Transform3D(sensorEvent.sensorRead);
        if (sensorEvent.buttonState != null) {
            this.buttonState = new int[sensorEvent.buttonState.length];
            for (int i2 = 0; i2 < sensorEvent.buttonState.length; ++i2) {
                this.buttonState[i2] = sensorEvent.buttonState[i2];
            }
        }
        this.ephemeral = false;
    }

    public void set(Object object, int n2, Sensor sensor, Transform3D transform3D, int[] nArray, int n3, long l2, long l3) {
        if (!this.ephemeral) {
            throw new IllegalStateException("Can't set the fields of non-ephemeral events");
        }
        this.source = object;
        this.id = n2;
        this.sensor = sensor;
        if (transform3D == null) {
            throw new NullPointerException("sensorRead can't be null");
        }
        this.sensorRead = transform3D;
        this.buttonState = nArray;
        this.button = n3;
        this.time = l2;
        this.lastTime = l3;
    }

    public Object getSource() {
        return this.source;
    }

    public int getID() {
        return this.id;
    }

    public Sensor getSensor() {
        return this.sensor;
    }

    public long getTime() {
        return this.time;
    }

    public long getLastTime() {
        return this.lastTime;
    }

    public void getSensorRead(Transform3D transform3D) {
        transform3D.set(this.sensorRead);
    }

    public int getButton() {
        return this.button;
    }

    public void getButtonState(int[] nArray) {
        if (nArray.length != this.buttonState.length) {
            throw new ArrayIndexOutOfBoundsException("buttonState array is the wrong length");
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = this.buttonState[i2];
        }
    }

    public boolean isEphemeral() {
        return this.ephemeral;
    }
}

